/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.dialog;

import com.kms.katalon.composer.components.impl.control.ScrollableComposite;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.windows.dialog.WindowsObjectDialog;
import com.kms.katalon.composer.windows.element.BasicWindowsElement;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class WindowsDeviceDialog
extends Dialog {
    private static final String DIALOG_TITLE = "Screen View";
    private Image currentScreenShot;
    private Canvas canvas;
    public static final int DIALOG_WIDTH = 400;
    public static final int DIALOG_HEIGHT = 600;
    private double currentX = 0.0;
    private double currentY = 0.0;
    private double currentWidth = 0.0;
    private double currentHeight = 0.0;
    private double hRatio;
    private boolean isDisposed;
    private Point initialLocation;
    private WindowsObjectDialog mobileInspetorDialog;
    private ScrolledComposite scrolledComposite;

    public WindowsDeviceDialog(Shell parentShell, WindowsObjectDialog mobileInspectorDialog, Point location) {
        super(parentShell);
        this.mobileInspetorDialog = mobileInspectorDialog;
        this.initialLocation = location;
        this.isDisposed = false;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout dialogAreaGridLayout = (GridLayout)dialogArea.getLayout();
        dialogAreaGridLayout.marginWidth = 0;
        dialogAreaGridLayout.marginHeight = 0;
        this.scrolledComposite = new ScrollableComposite(dialogArea, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setLayout((Layout)new GridLayout());
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite container = new Composite((Composite)this.scrolledComposite, 0);
        container.setLayout((Layout)new FillLayout());
        this.scrolledComposite.setContent((Control)container);
        this.canvas = new Canvas(container, 0);
        this.canvas.pack();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (WindowsDeviceDialog.this.currentScreenShot != null && !WindowsDeviceDialog.this.currentScreenShot.isDisposed()) {
                    e.gc.drawImage(WindowsDeviceDialog.this.currentScreenShot, 0, 0);
                    if (WindowsDeviceDialog.this.currentWidth != 0.0 && WindowsDeviceDialog.this.currentHeight != 0.0) {
                        Color oldForegroundColor = e.gc.getForeground();
                        e.gc.setForeground(ColorUtil.getColor((String)"#76BF42"));
                        int x = WindowsDeviceDialog.safeRoundDouble(WindowsDeviceDialog.this.currentX);
                        int y = WindowsDeviceDialog.safeRoundDouble(WindowsDeviceDialog.this.currentY);
                        int width = WindowsDeviceDialog.safeRoundDouble(WindowsDeviceDialog.this.currentWidth);
                        int height = WindowsDeviceDialog.safeRoundDouble(WindowsDeviceDialog.this.currentHeight);
                        e.gc.drawRectangle(x, y, width, height);
                        e.gc.drawRectangle(x + 1, Math.max(y + 1, 0), Math.max(width - 2, 0), Math.max(height - 2, 0));
                        e.gc.setForeground(oldForegroundColor);
                    }
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    WindowsDeviceDialog.this.inspectElementAt(e.x, e.y);
                }
            }
        });
        return dialogArea;
    }

    protected boolean isResizable() {
        return true;
    }

    private void inspectElementAt(int x, int y) {
        Double realX = (double)x / this.hRatio;
        Double realY = (double)y / this.hRatio;
        this.mobileInspetorDialog.setSelectedElementByLocation(WindowsDeviceDialog.safeRoundDouble(realX), WindowsDeviceDialog.safeRoundDouble(realY));
    }

    private boolean isElementOnScreen(Double x, Double y, Double width, Double height) {
        Rectangle elementRect = new Rectangle(x.intValue(), y.intValue(), width.intValue(), height.intValue());
        return elementRect.intersects(this.getCurrentViewportRect());
    }

    private void scrollToElement(Double x, Double y) {
        this.scrolledComposite.setOrigin(x.intValue(), y.intValue());
    }

    private Rectangle getCurrentViewportRect() {
        ScrollBar verticalBar = this.scrolledComposite.getVerticalBar();
        ScrollBar horizontalBar = this.scrolledComposite.getHorizontalBar();
        int viewPortY = verticalBar.isVisible() ? verticalBar.getSelection() : 0;
        int viewPortX = horizontalBar.isVisible() ? horizontalBar.getSelection() : 0;
        Point viewPortSize = this.scrolledComposite.getSize();
        Rectangle viewPortRect = new Rectangle(viewPortX, viewPortY, viewPortSize.x, viewPortSize.y);
        return viewPortRect;
    }

    public void highlight(final double x, final double y, final double width, final double height) {
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                double currentX = x * WindowsDeviceDialog.this.hRatio;
                double currentY = y * WindowsDeviceDialog.this.hRatio;
                double currentWidth = width * WindowsDeviceDialog.this.hRatio;
                double currentHeight = height * WindowsDeviceDialog.this.hRatio;
                if (!WindowsDeviceDialog.this.isElementOnScreen(currentX, currentY, currentWidth, currentHeight)) {
                    WindowsDeviceDialog.this.scrollToElement(currentX, currentY);
                }
            }
        });
        Thread highlightThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < 9) {
                    if (i % 2 == 1) {
                        WindowsDeviceDialog.this.currentX = x * WindowsDeviceDialog.this.hRatio;
                        WindowsDeviceDialog.this.currentY = y * WindowsDeviceDialog.this.hRatio;
                        WindowsDeviceDialog.this.currentWidth = width * WindowsDeviceDialog.this.hRatio;
                        WindowsDeviceDialog.this.currentHeight = height * WindowsDeviceDialog.this.hRatio;
                    } else {
                        WindowsDeviceDialog.this.currentX = 0.0;
                        WindowsDeviceDialog.this.currentY = 0.0;
                        WindowsDeviceDialog.this.currentWidth = 0.0;
                        WindowsDeviceDialog.this.currentHeight = 0.0;
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    UISynchronizeService.syncExec(() -> WindowsDeviceDialog.this.canvas.redraw());
                    ++i;
                }
            }
        });
        highlightThread.start();
    }

    private Image scaleImage(Image image, double newWidth, double newHeight) {
        Image scaled = new Image((Device)Display.getDefault(), WindowsDeviceDialog.safeRoundDouble(newWidth), WindowsDeviceDialog.safeRoundDouble(newHeight));
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, WindowsDeviceDialog.safeRoundDouble(newWidth), WindowsDeviceDialog.safeRoundDouble(newHeight));
        gc.dispose();
        image.dispose();
        return scaled;
    }

    protected Point getInitialSize() {
        return new Point(400, 657);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(1264);
        this.setBlockOnOpen(false);
    }

    public void closeApp() {
        this.handleShellCloseEvent();
    }

    public void highlightElement(BasicWindowsElement selectedElement) {
        Map<String, String> attributes = selectedElement.getProperties();
        if (!(attributes != null && attributes.containsKey("x") && attributes.containsKey("y") && attributes.containsKey("width") && attributes.containsKey("height"))) {
            return;
        }
        double x = Double.parseDouble(attributes.get("x"));
        double y = Double.parseDouble(attributes.get("y"));
        double w = Double.parseDouble(attributes.get("width"));
        double h = Double.parseDouble(attributes.get("height"));
        this.highlight(x, y, w, h);
    }

    public void refreshDialog(File imageFile) {
        try {
            ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL());
            Image img = imgDesc.createImage();
            this.hRatio = 1.0;
            this.currentScreenShot = this.scaleImage(img, (double)img.getBounds().width * this.hRatio, (double)img.getBounds().height * this.hRatio);
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WindowsDeviceDialog.this.canvas.redraw();
                }
            });
            this.refreshView();
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void refreshView() {
        if (this.scrolledComposite == null || this.currentScreenShot == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                WindowsDeviceDialog.this.scrolledComposite.setMinSize(WindowsDeviceDialog.this.currentScreenShot.getImageData().width, WindowsDeviceDialog.this.currentScreenShot.getImageData().height);
            }
        });
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.dispose();
    }

    public void dispose() {
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    protected Point getInitialLocation(Point initialSize) {
        if ((this.getShell().getStyle() & 0x10) == 0) {
            return new Point(this.initialLocation.x, this.initialLocation.y + 5);
        }
        return this.initialLocation;
    }

    public static int safeRoundDouble(double d) {
        long rounded = Math.round(d);
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, rounded));
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }
}

