/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.element;

import com.kms.katalon.composer.mobile.objectspy.element.Converter;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CapturedWindowsElementConverter
implements Converter<CapturedWindowsElement, WindowsElementEntity> {
    public WindowsElementEntity convert(CapturedWindowsElement capturedElement) {
        if (capturedElement == null) {
            return null;
        }
        WindowsElementEntity windowsElementEntity = new WindowsElementEntity();
        windowsElementEntity.setName(capturedElement.getName());
        windowsElementEntity.setLocator(capturedElement.getLocator());
        windowsElementEntity.setLocatorStrategy(capturedElement.getLocatorStrategy());
        List properties = capturedElement.getProperties().entrySet().stream().map(e -> {
            WebElementPropertyEntity property = new WebElementPropertyEntity();
            property.setName((String)e.getKey());
            property.setValue((String)e.getValue());
            return property;
        }).collect(Collectors.toList());
        windowsElementEntity.setProperties(properties);
        return windowsElementEntity;
    }

    public WindowsElementEntity convert(CapturedWindowsElement capturedElement, FolderEntity folder) throws Exception {
        WindowsElementEntity windowsElement = this.convert(capturedElement);
        windowsElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(folder, ObjectRepositoryController.toValidFileName((String)StringUtils.trim((String)windowsElement.getName()))));
        windowsElement.setParentFolder(folder);
        windowsElement.setProject(folder.getProject());
        return windowsElement;
    }

    public CapturedWindowsElement revert(WindowsElementEntity windowsElement) {
        if (windowsElement == null) {
            return null;
        }
        CapturedWindowsElement capturedWindowsElement = new CapturedWindowsElement();
        capturedWindowsElement.setName(windowsElement.getName());
        capturedWindowsElement.setLocator(windowsElement.getLocator());
        capturedWindowsElement.setLocatorStrategy(windowsElement.getLocatorStrategy());
        HashMap<String, String> properties = new HashMap<String, String>(windowsElement.getProperties().stream().collect(Collectors.toMap(WebElementPropertyEntity::getName, WebElementPropertyEntity::getValue)));
        capturedWindowsElement.setProperties(properties);
        return capturedWindowsElement;
    }
}

