/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.spy;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.providers.TypeCheckStyleCellTableLabelProvider;
import com.kms.katalon.composer.testcase.ast.dialogs.IAstDialogBuilder;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CapturedWindowsElementBrowserDialog
extends AbstractDialog
implements IAstDialogBuilder {
    private CTableViewer tableViewer;
    private List<CapturedWindowsElement> capturedElements;
    private CapturedWindowsElement selectedElement;

    public CapturedWindowsElementBrowserDialog(Shell parentShell, List<CapturedWindowsElement> capturedElements, CapturedWindowsElement selectedElement) {
        super(parentShell);
        this.capturedElements = capturedElements;
        this.selectedElement = selectedElement;
    }

    protected void registerControlModifyListeners() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CapturedWindowsElement webElement = (CapturedWindowsElement)CapturedWindowsElementBrowserDialog.this.tableViewer.getStructuredSelection().getFirstElement();
                if (webElement != null) {
                    CapturedWindowsElementBrowserDialog.this.selectedElement = webElement;
                }
                CapturedWindowsElementBrowserDialog.this.getButton(0).setEnabled(webElement instanceof CapturedWindowsElement);
            }
        });
    }

    protected void setInput() {
        this.tableViewer.setInput(this.capturedElements);
        if (this.selectedElement != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedElement));
        }
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.tableViewer = new CTableViewer(container, 2050);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new WindowsElementLabelProvider(0));
        return container;
    }

    public Object getReturnValue() {
        return this.selectedElement;
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    public String getDialogTitle() {
        return "Captured Windows Object";
    }

    private class WindowsElementLabelProvider
    extends TypeCheckStyleCellTableLabelProvider<CapturedWindowsElement> {
        public WindowsElementLabelProvider(int columnIndex) {
            super(columnIndex);
        }

        protected Class<CapturedWindowsElement> getElementType() {
            return CapturedWindowsElement.class;
        }

        protected Image getImage(CapturedWindowsElement element) {
            return null;
        }

        protected String getText(CapturedWindowsElement element) {
            return element.getName();
        }
    }
}

