/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.spy;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumStreamHandler;
import com.kms.katalon.composer.mobile.objectspy.util.Util;
import com.kms.katalon.composer.windows.action.WindowsAction;
import com.kms.katalon.composer.windows.action.WindowsActionButtonWrapper;
import com.kms.katalon.composer.windows.action.WindowsActionHandler;
import com.kms.katalon.composer.windows.action.WindowsActionMapping;
import com.kms.katalon.composer.windows.element.BasicWindowsElement;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.element.SnapshotWindowsElement;
import com.kms.katalon.composer.windows.element.TreeWindowsElement;
import com.kms.katalon.composer.windows.exception.WindowsComposerException;
import com.kms.katalon.core.enums.windows.LocatorStrategy;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.testobject.WindowsTestObject;
import com.kms.katalon.core.windows.driver.WindowsDesiredCapsBuilder;
import com.kms.katalon.core.windows.driver.WindowsDriverFactory;
import com.kms.katalon.core.windows.driver.WindowsSession;
import com.kms.katalon.core.windows.keyword.helper.WindowsActionHelper;
import com.kms.katalon.core.windows.model.StringMatchingStrategy;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.execution.windows.WindowsDriverConnector;
import com.kms.katalon.util.DocumentBuilderProvider;
import io.appium.java_client.windows.WindowsDriver;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrMatcher;
import org.eclipse.swt.widgets.Shell;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class WindowsInspectorController {
    private static final Logger logger = LoggerFactory.getLogger((String)WindowsInspectorController.class.getName());
    private WindowsSession session;
    private AppiumStreamHandler streamHandler;
    private Thread appiumTailerThread;

    public WindowsDriverConnector buildDriverConnector(String projectDir) throws InvocationTargetException {
        try {
            return WindowsDriverConnector.getInstance((String)projectDir);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void closeAppiumTailerThread() {
        if (this.appiumTailerThread != null && this.appiumTailerThread.isAlive()) {
            this.appiumTailerThread.interrupt();
        }
        this.appiumTailerThread = null;
    }

    public WindowsDriver getDriver() {
        return this.session != null ? this.session.getRunningDriver() : null;
    }

    public boolean closeApp() {
        try {
            WindowsDriver driver = this.getDriver();
            if (driver != null && driver.getSessionId() != null) {
                driver.quit();
            }
            this.closeAppiumTailerThread();
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    public String captureScreenshot() throws Exception {
        String screenshotFolder = Util.getDefaultMobileScreenshotPath();
        File screenshot = (File)this.getDriver().getScreenshotAs(OutputType.FILE);
        if (!screenshot.exists()) {
            throw new Exception(ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_UNABLE_TO_CAPTURE_SCREEN);
        }
        String fileName = new String("screenshot_" + new Date().getTime() + ".jpg");
        String path = screenshotFolder + System.getProperty("file.separator") + fileName;
        FileUtils.copyFile((File)screenshot, (File)new File(path));
        try {
            FileUtils.forceDelete((File)screenshot);
        }
        catch (Exception exception) {}
        return path;
    }

    public TreeWindowsElement getWindowsObjectRoot() {
        try {
            InputSource is;
            String pageSource = this.getDriver().getPageSource();
            DocumentBuilder db = DocumentBuilderProvider.newBuilderInstance();
            Document doc = null;
            try {
                is = new InputSource();
                is.setCharacterStream(new StringReader(pageSource));
                doc = db.parse(is);
            }
            catch (SAXParseException sAXParseException) {
                is = new InputSource();
                is.setCharacterStream(new StringReader(WindowsInspectorController.removeEscapeCharacter(pageSource)));
                doc = db.parse(is);
            }
            Element rootElement = doc.getDocumentElement();
            SnapshotWindowsElement htmlMobileElementRootNode = new SnapshotWindowsElement();
            htmlMobileElementRootNode.render(rootElement);
            return htmlMobileElementRootNode;
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            return null;
        }
    }

    private static String removeEscapeCharacter(String contentBuilder) {
        String pattern = "(\\\"([^=])*\\\")";
        Pattern pattern2 = Pattern.compile(pattern);
        Matcher matcher = pattern2.matcher(contentBuilder);
        StrBuilder sb = new StrBuilder(contentBuilder);
        while (matcher.find()) {
            String str = matcher.group(1).substring(1, matcher.group(1).length() - 1);
            sb = sb.replaceFirst(StrMatcher.stringMatcher((String)str), StringEscapeUtils.escapeXml((String)str));
        }
        return sb.toString();
    }

    public AppiumStreamHandler getStreamHandler() {
        return this.streamHandler;
    }

    public void setStreamHandler(AppiumStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
    }

    public void startApplication(WindowsDriverConnector driverConnector, String appFile, String applicationTitle, StringMatchingStrategy strategy) throws IOException, URISyntaxException, InterruptedException {
        String driverUrl = driverConnector.getDriverUrl();
        DesiredCapabilities desiredCapabilities = new WindowsDesiredCapsBuilder().merge(driverConnector.getDesiredCapabilities()).build();
        ProxyInformation proxyInfo = ProxyPreferences.getSystemProxyInformation();
        this.session = WindowsDriverFactory.startApplication((URL)new URL(driverUrl), (String)appFile, (DesiredCapabilities)desiredCapabilities, (ProxyInformation)proxyInfo, (String)applicationTitle, (StringMatchingStrategy)strategy);
    }

    public void reattachToApplicationIfPossible() throws IOException, URISyntaxException, InterruptedException {
        if (this.session == null) {
            return;
        }
        WindowsActionHelper.create((WindowsSession)this.session).reattachToApplicationIfPossible();
    }

    public void resetDriver() {
        this.session = null;
    }

    public WindowsSession getWindowsSession() {
        return this.session;
    }

    public void updateActionButtonsEnabledState(List<WindowsActionButtonWrapper> actionButtons, BasicWindowsElement selectedElement) {
        UISynchronizeService.syncExec(() -> actionButtons.stream().forEach(actionButton -> {
            WindowsAction action = actionButton.getWindowsAction();
            actionButton.setEnabledButton(this.getDriver() != null && (!action.hasElement() || selectedElement != null));
        }));
    }

    public WindowsActionMapping performAction(WindowsAction action, SnapshotWindowsElement element, Shell shell) throws WindowsComposerException {
        WindowsActionHandler actionHandler = new WindowsActionHandler(this.getWindowsSession(), action);
        return actionHandler.perform(element, shell);
    }

    public boolean safelyGetAndUpdateAdditionalAttributes(CapturedWindowsElement targetElement) {
        try {
            WindowsTestObject testObject = new WindowsTestObject(targetElement.getName());
            testObject.setLocator(targetElement.getLocator());
            testObject.setLocatorStrategy(LocatorStrategy.valueOf((String)targetElement.getLocatorStrategy().name()));
            Map additionalAttrs = WindowsActionHelper.create((WindowsSession)this.session).getAdditionalAttributes(testObject);
            targetElement.getProperties().putAll(additionalAttrs);
            return true;
        }
        catch (Exception ex) {
            logger.error("Failed to query additional attributes. Element will have basic attributes only", (Throwable)ex);
            return false;
        }
    }

    public boolean capableOfCapturingObjects() {
        if (this.session == null) {
            return false;
        }
        if (WindowsSession.TargetAppType.ROOT_APP.equals((Object)this.session.getTargetAppType())) {
            return true;
        }
        return this.isApplicationOpened();
    }

    private boolean isApplicationOpened() {
        try {
            this.session.getApplicationDriver().getWindowHandle();
            return true;
        }
        catch (NoSuchWindowException noSuchWindowException) {
            return false;
        }
    }
}

