/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.jd.decompiler;

import org.jd.core.v1.api.printer.Printer;

public class JDCorePrinter
implements Printer {
    protected static final String TAB = "  ";
    protected static final String NEWLINE = "\n";
    protected final StringBuilder sb = new StringBuilder(4096);
    protected int indentationCount;
    protected int realLineNumber = 0;
    protected String lineNumberFormat;
    protected int lineNumberWidth;
    protected final boolean escapeUnicodeCharacters;
    protected final boolean printLineNumbers;

    public JDCorePrinter(boolean escapeUnicodeCharacters, boolean printLineNumbers) {
        this.escapeUnicodeCharacters = escapeUnicodeCharacters;
        this.printLineNumbers = printLineNumbers;
    }

    public void init() {
        this.sb.setLength(0);
        this.realLineNumber = 0;
        this.indentationCount = 0;
    }

    public String toString() {
        return this.sb.toString();
    }

    public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        this.indentationCount = 0;
        if (this.printLineNumbers) {
            if (maxLineNumber == 0) {
                this.lineNumberFormat = "%4d";
            } else {
                int width = 1;
                while (maxLineNumber >= 10) {
                    ++width;
                    maxLineNumber /= 10;
                }
                this.lineNumberFormat = "%" + width + "d";
                this.lineNumberWidth = width;
            }
        }
    }

    public void end() {
    }

    public void printText(String text) {
        if (this.escapeUnicodeCharacters) {
            int i = 0;
            int len = text.length();
            while (i < len) {
                char c = text.charAt(i);
                if (c < '\u007f') {
                    this.sb.append(c);
                } else {
                    int h = c >> 12;
                    this.sb.append("\\u");
                    this.sb.append((char)(h <= 9 ? h + 48 : h + 55));
                    h = c >> 8 & 0xF;
                    this.sb.append((char)(h <= 9 ? h + 48 : h + 55));
                    h = c >> 4 & 0xF;
                    this.sb.append((char)(h <= 9 ? h + 48 : h + 55));
                    h = c & 0xF;
                    this.sb.append((char)(h <= 9 ? h + 48 : h + 55));
                }
                ++i;
            }
        } else {
            this.sb.append(text);
        }
    }

    public void printNumericConstant(String constant) {
        this.sb.append(constant);
    }

    public void printStringConstant(String constant, String ownerInternalName) {
        this.printText(constant);
    }

    public void printKeyword(String keyword) {
        this.sb.append(keyword);
    }

    public void printDeclaration(int type, String internalTypeName, String name, String descriptor) {
        this.printText(name);
    }

    public void printReference(int type, String internalTypeName, String name, String descriptor, String ownerInternalName) {
        this.printText(name);
    }

    public void indent() {
        ++this.indentationCount;
    }

    public void unindent() {
        if (this.indentationCount > 0) {
            --this.indentationCount;
        }
    }

    public void startLine(int lineNumber) {
        this.printLineNumber(lineNumber);
        int i = 0;
        while (i < this.indentationCount) {
            this.sb.append(TAB);
            ++i;
        }
    }

    public void endLine() {
        this.sb.append(NEWLINE);
    }

    public void extraLine(int count) {
        while (count-- > 0) {
            this.printLineNumber(0);
            this.sb.append(NEWLINE);
        }
    }

    public void startMarker(int type) {
    }

    public void endMarker(int type) {
    }

    protected void printLineNumber(int lineNumber) {
        if (!this.printLineNumbers) {
            return;
        }
        this.sb.append("/* ");
        if (lineNumber > 0) {
            this.sb.append(String.format(this.lineNumberFormat, lineNumber));
        } else {
            int i = 0;
            while (i < this.lineNumberWidth) {
                this.sb.append(' ');
                ++i;
            }
        }
        this.sb.append(" */ ");
    }
}

