/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.jd.decompiler;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.api.loader.LoaderException;
import org.objectweb.asm.ClassReader;
import org.sf.feeling.decompiler.util.IOUtils;
import org.sf.feeling.decompiler.util.Logger;

public class JDCoreZipLoader
implements Loader,
Closeable {
    private final ZipFile zipFile;
    private final EntriesCache entriesCache;
    private final Set<String> loadedEntries = new TreeSet<String>();

    public JDCoreZipLoader(Path zipFilePath, EntriesCache entriesCache) throws ZipException, IOException {
        if (entriesCache != null && !entriesCache.zipFilePath.equals(zipFilePath)) {
            throw new IllegalArgumentException("entriesCache is for the wrong zipFilePath");
        }
        this.zipFile = new ZipFile(zipFilePath.toFile());
        if (entriesCache == null) {
            entriesCache = new EntriesCache(zipFilePath);
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if (!name.endsWith(".class")) continue;
                try {
                    String oldEntry;
                    ClassReader cr = new ClassReader(this.zipFile.getInputStream(entry));
                    String className = cr.getClassName();
                    if (className == null || className.isEmpty() || (oldEntry = entriesCache.entriesMap.put(className, entry.getName())) == null) continue;
                    Logger.info((String)("Duplicate class " + className + " found in JAR " + zipFilePath + ": " + entry.getName() + "/" + oldEntry));
                }
                catch (Exception e) {
                    Logger.error((String)("Failed to read entry " + name + ": " + e.toString()));
                }
            }
        }
        this.entriesCache = entriesCache;
    }

    public boolean canLoad(String internalName) {
        boolean result = this.entriesCache.entriesMap.containsKey(internalName);
        return result;
    }

    /*
     * Loose catch block
     */
    public byte[] load(String internalName) throws LoaderException {
        String entryName = (String)this.entriesCache.entriesMap.get(internalName);
        if (entryName == null) {
            Logger.error((String)("Class not found: " + internalName));
            return new byte[0];
        }
        ZipEntry entry = this.zipFile.getEntry(entryName);
        if (entry == null) {
            Logger.error((String)("Entry - missing for class file: " + entryName));
            return new byte[0];
        }
        int initialSize = entry.getSize() > 0L ? (int)entry.getSize() : 4096;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream(initialSize);){
                byte[] byArray;
                InputStream in;
                Throwable throwable2;
                block23: {
                    throwable2 = null;
                    Object var9_13 = null;
                    in = this.zipFile.getInputStream(entry);
                    IOUtils.copy((InputStream)in, (OutputStream)out, (int)8192);
                    this.loadedEntries.add(internalName);
                    byArray = out.toByteArray();
                    if (in == null) break block23;
                    in.close();
                }
                return byArray;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LoaderException((Throwable)e);
        }
    }

    public Set<String> getLoadedEntries() {
        return this.loadedEntries;
    }

    public EntriesCache getEntriesCache() {
        return this.entriesCache;
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    public static class EntriesCache {
        private final Path zipFilePath;
        private final FileTime zipFileLastModified;
        private final Map<String, String> entriesMap = new TreeMap<String, String>();

        public EntriesCache(Path zipFilePath) throws IOException {
            this.zipFilePath = zipFilePath;
            this.zipFileLastModified = Files.getLastModifiedTime(zipFilePath, new LinkOption[0]);
        }

        public Path getZipFilePath() {
            return this.zipFilePath;
        }

        public boolean isForTheSameFile(Path fileToTest) throws IOException {
            boolean equal = this.zipFilePath.equals(fileToTest);
            if (equal) {
                FileTime lastMod = Files.getLastModifiedTime(fileToTest, new LinkOption[0]);
                return this.zipFileLastModified.equals(lastMod);
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.zipFilePath == null ? 0 : this.zipFilePath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntriesCache other = (EntriesCache)obj;
            return !(this.zipFilePath == null ? other.zipFilePath != null : !this.zipFilePath.equals(other.zipFilePath));
        }
    }
}

