/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.procyon.decompiler;

import com.strobel.decompiler.languages.LineNumberPosition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.sf.feeling.decompiler.procyon.decompiler.LineNumberPrintWriter;

public class LineNumberFormatter {
    private final List<LineNumberPosition> _positions;
    private final File _file;
    private final EnumSet<LineNumberOption> _options;

    public LineNumberFormatter(File file, List<LineNumberPosition> lineNumberPositions, EnumSet<LineNumberOption> options) {
        this._file = file;
        this._positions = lineNumberPositions;
        this._options = options == null ? EnumSet.noneOf(LineNumberOption.class) : options;
    }

    public String reformatFile() throws IOException {
        ArrayList<LineNumberPosition> lineBrokenPositions = new ArrayList<LineNumberPosition>();
        List<String> brokenLines = this.breakLines(lineBrokenPositions);
        Throwable throwable = null;
        Object var4_5 = null;
        try (StringWriter sw = new StringWriter();){
            this.emitFormatted(brokenLines, lineBrokenPositions, sw);
            return sw.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<String> breakLines(List<LineNumberPosition> o_LineBrokenPositions) throws IOException {
        int numLinesRead = 0;
        int lineOffset = 0;
        ArrayList<String> brokenLines = new ArrayList<String>();
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedReader r = new BufferedReader(new FileReader(this._file));){
            String line;
            int posIndex = 0;
            while (posIndex < this._positions.size()) {
                LineNumberPosition nextPos;
                LineNumberPosition pos = this._positions.get(posIndex);
                o_LineBrokenPositions.add(new LineNumberPosition(pos.getOriginalLine(), pos.getEmittedLine() + lineOffset, pos.getEmittedColumn()));
                while (numLinesRead < pos.getEmittedLine() - 1) {
                    brokenLines.add(r.readLine());
                    ++numLinesRead;
                }
                String line2 = r.readLine();
                ++numLinesRead;
                int prevPartLen = 0;
                char[] indent = new char[]{};
                do {
                    LineNumberPosition lineNumberPosition = nextPos = posIndex < this._positions.size() - 1 ? this._positions.get(posIndex + 1) : null;
                    if (nextPos != null && nextPos.getEmittedLine() == pos.getEmittedLine() && nextPos.getOriginalLine() > pos.getOriginalLine()) {
                        ++posIndex;
                        ++lineOffset;
                        String firstPart = line2.substring(0, nextPos.getEmittedColumn() - prevPartLen - 1);
                        brokenLines.add(String.valueOf(new String(indent)) + firstPart);
                        indent = new char[prevPartLen += firstPart.length()];
                        Arrays.fill(indent, ' ');
                        line2 = line2.substring(firstPart.length(), line2.length());
                        o_LineBrokenPositions.add(new LineNumberPosition(nextPos.getOriginalLine(), nextPos.getEmittedLine() + lineOffset, nextPos.getEmittedColumn()));
                        continue;
                    }
                    nextPos = null;
                } while (nextPos != null);
                brokenLines.add(String.valueOf(new String(indent)) + line2);
                ++posIndex;
            }
            while ((line = r.readLine()) != null) {
                brokenLines.add(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return brokenLines;
    }

    /*
     * Unable to fully structure code
     */
    private void emitFormatted(List<String> brokenLines, List<LineNumberPosition> lineBrokenPositions, Writer writer) throws IOException {
        tempFile = new File(String.valueOf(this._file.getAbsolutePath()) + ".fixed");
        globalOffset = 0;
        numLinesRead = 0;
        lines = brokenLines.iterator();
        maxLineNo = LineNumberPosition.computeMaxLineNumber(lineBrokenPositions);
        var9_9 = null;
        var10_11 = null;
        try {
            w = new LineNumberPrintWriter(maxLineNo, writer);
            try {
                if (!this._options.contains((Object)LineNumberOption.LEADING_COMMENTS)) {
                    w.suppressLineNumbers();
                }
                doStretching = this._options.contains((Object)LineNumberOption.STRETCHED);
                for (LineNumberPosition pos : lineBrokenPositions) {
                    nextTarget = pos.getOriginalLine();
                    nextActual = pos.getEmittedLine();
                    requiredAdjustment = nextTarget - nextActual - globalOffset;
                    if (!doStretching || requiredAdjustment >= 0) ** GOTO lbl60
                    stripped = new ArrayList<String>();
                    while (numLinesRead < nextActual - 1) {
                        line = lines.next();
                        ++numLinesRead;
                        if (requiredAdjustment < 0 && line.trim().isEmpty()) {
                            ++requiredAdjustment;
                            --globalOffset;
                            continue;
                        }
                        stripped.add(line);
                    }
                    lineNoToPrint = stripped.size() + requiredAdjustment <= 0 ? nextTarget : -1;
                    for (String line : stripped) {
                        if (requiredAdjustment < 0) {
                            w.print(lineNoToPrint, line);
                            w.print("  ");
                            ++requiredAdjustment;
                            --globalOffset;
                            continue;
                        }
                        w.println(lineNoToPrint, line);
                    }
                    line = lines.next();
                    ++numLinesRead;
                    if (requiredAdjustment < 0) {
                        w.print(nextTarget, line);
                        w.print("  ");
                        --globalOffset;
                        continue;
                    }
                    w.println(nextTarget, line);
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        line = lines.next();
                        isLast = ++numLinesRead >= nextActual;
                        v0 = lineNoToPrint = isLast != false ? nextTarget : -1;
                        if (requiredAdjustment > 0 && doStretching) {
                            do {
                                w.println("");
                                ++globalOffset;
                            } while (isLast && --requiredAdjustment > 0);
                            w.println(lineNoToPrint, line);
                            continue;
                        }
                        w.println(lineNoToPrint, line);
lbl60:
                        // 3 sources

                        ** while (numLinesRead < nextActual)
                    }
lbl61:
                    // 1 sources

                }
                while (lines.hasNext()) {
                    line = lines.next();
                    w.println(line);
                }
            }
            finally {
                if (w != null) {
                    w.close();
                }
            }
        }
        catch (Throwable var10_12) {
            if (var9_9 == null) {
                var9_9 = var10_12;
            } else if (var9_9 != var10_12) {
                var9_9.addSuppressed(var10_12);
            }
            throw var9_9;
        }
        this._file.delete();
        tempFile.renameTo(this._file);
    }

    public static enum LineNumberOption {
        LEADING_COMMENTS,
        STRETCHED;

    }
}

