/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.testcloud.dialogs;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.integration.testcloud.constants.IntegrationTestCloudComposerMessageConstants;
import com.kms.katalon.composer.integration.testcloud.utils.TestCloudMobileUtils;
import com.kms.katalon.testcloud.core.model.TestCloudMobileAvailability;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOS;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOSVersion;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TestCloudMobileBrowsersTab
extends CTabItem {
    public static final int DEFAULT_HORIZONTAL_INDENT = 10;
    public static final int BUTTON_HORIZONTAL_INDENT = 7;
    public static final int CBB_WIDTH = 30;
    private Combo cbbMobileBrowserOS;
    private Combo cbbMobileBrowserOSVersion;
    private Combo cbbMobileBrowserDeviceName;
    private Button btnHighAvailableDevice;
    private List<TestCloudMobileOS> mobileDeviceList;
    private List<TestCloudMobileOS> originalMobileDeviceList;
    private String latestSelectionOs;
    private String latestSelectionOsVersion;
    private String latestSelectionDeviceName;

    public TestCloudMobileBrowsersTab(CTabFolder parent, List<TestCloudMobileOS> mobileDeviceList) {
        super(parent, 0);
        this.originalMobileDeviceList = mobileDeviceList;
        this.mobileDeviceList = TestCloudMobileUtils.filteredMobileDeviceList(mobileDeviceList, TestCloudMobileAvailability.HIGH);
        this.createMobileBrowserTab(parent);
        this.registerControlListeners();
        this.btnHighAvailableDevice.setSelection(true);
        this.loadDataForCbbMobileBrowserOs(this.mobileDeviceList);
    }

    private void createMobileBrowserTab(CTabFolder tabFolder) {
        this.setText("Mobile Browsers");
        Composite tabContent = (Composite)ComponentBuilder.gridContainer((Composite)tabFolder, (int)3).fill().margin(10, 10).center().build();
        this.cbbMobileBrowserOS = (Combo)ComponentBuilder.comboBox((Composite)tabContent, (int)8).horizontalIndent(10).autoWidth(90).fillHorizontal().build();
        this.cbbMobileBrowserOSVersion = (Combo)ComponentBuilder.comboBox((Composite)tabContent, (int)8).autoWidth(90).fillHorizontal().horizontalIndent(7).build();
        this.cbbMobileBrowserDeviceName = (Combo)ComponentBuilder.comboBox((Composite)tabContent, (int)8).autoWidth(120).fillHorizontal().horizontalIndent(7).build();
        this.btnHighAvailableDevice = (Button)ComponentBuilder.button((Composite)tabContent, (int)32).text(IntegrationTestCloudComposerMessageConstants.DIA_BTN_HIGH_AVAILABILITY_DEVICES).horizontalIndent(7).build();
        this.setControl((Control)tabContent);
    }

    private void registerControlListeners() {
        this.cbbMobileBrowserOS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudMobileBrowsersTab.this.latestSelectionOs = TestCloudMobileBrowsersTab.this.cbbMobileBrowserOS.getText();
                TestCloudMobileBrowsersTab.this.latestSelectionOsVersion = null;
                TestCloudMobileBrowsersTab.this.latestSelectionDeviceName = null;
                if (TestCloudMobileBrowsersTab.this.mobileDeviceList != null && !TestCloudMobileBrowsersTab.this.mobileDeviceList.isEmpty()) {
                    TestCloudMobileOS selectedOS = TestCloudMobileBrowsersTab.this.mobileDeviceList.get(TestCloudMobileBrowsersTab.this.cbbMobileBrowserOS.getSelectionIndex());
                    TestCloudMobileBrowsersTab.this.loadDataForCbbMobileBrowserOsVersion(selectedOS.getOsVersions());
                }
            }
        });
        this.cbbMobileBrowserOSVersion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudMobileBrowsersTab.this.latestSelectionOsVersion = TestCloudMobileBrowsersTab.this.cbbMobileBrowserOSVersion.getText();
                if (TestCloudMobileBrowsersTab.this.mobileDeviceList != null && !TestCloudMobileBrowsersTab.this.mobileDeviceList.isEmpty()) {
                    TestCloudMobileOSVersion selectedOSVersion = (TestCloudMobileOSVersion)TestCloudMobileBrowsersTab.this.mobileDeviceList.get(TestCloudMobileBrowsersTab.this.cbbMobileBrowserOS.getSelectionIndex()).getOsVersions().get(TestCloudMobileBrowsersTab.this.cbbMobileBrowserOSVersion.getSelectionIndex());
                    TestCloudMobileBrowsersTab.this.loadDataForCbbMobileBrowserDevice(selectedOSVersion.getDeviceList());
                }
            }
        });
        this.cbbMobileBrowserDeviceName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudMobileBrowsersTab.this.latestSelectionDeviceName = TestCloudMobileBrowsersTab.this.cbbMobileBrowserDeviceName.getText();
                TestCloudMobileBrowsersTab.this.cbbMobileBrowserDeviceName.setToolTipText(TestCloudMobileBrowsersTab.this.cbbMobileBrowserDeviceName.getText());
            }
        });
        this.btnHighAvailableDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudMobileBrowsersTab.this.latestSelectionOs = TestCloudMobileBrowsersTab.this.cbbMobileBrowserOS.getText();
                TestCloudMobileBrowsersTab.this.latestSelectionOsVersion = TestCloudMobileBrowsersTab.this.cbbMobileBrowserOSVersion.getText();
                TestCloudMobileBrowsersTab.this.latestSelectionDeviceName = TestCloudMobileBrowsersTab.this.cbbMobileBrowserDeviceName.getText();
                TestCloudMobileBrowsersTab.this.mobileDeviceList = TestCloudMobileBrowsersTab.this.btnHighAvailableDevice.getSelection() ? TestCloudMobileUtils.filteredMobileDeviceList(TestCloudMobileBrowsersTab.this.originalMobileDeviceList, TestCloudMobileAvailability.HIGH) : TestCloudMobileBrowsersTab.this.originalMobileDeviceList;
                if (TestCloudMobileBrowsersTab.this.mobileDeviceList != null && !TestCloudMobileBrowsersTab.this.mobileDeviceList.isEmpty()) {
                    TestCloudMobileOS selectedOS = TestCloudMobileBrowsersTab.this.mobileDeviceList.get(TestCloudMobileBrowsersTab.this.cbbMobileBrowserOS.getSelectionIndex());
                    TestCloudMobileBrowsersTab.this.loadDataForCbbMobileBrowserOsVersion(selectedOS.getOsVersions());
                }
            }
        });
    }

    private void loadDataForCbbMobileBrowserOs(List<TestCloudMobileOS> mobileOs) {
        int foundIndex;
        String[] osList = new String[mobileOs.size()];
        int i = 0;
        while (i < mobileOs.size()) {
            osList[i] = mobileOs.get(i).getOs();
            ++i;
        }
        this.cbbMobileBrowserOS.setItems(osList);
        int indexSelectedOs = 0;
        if (this.latestSelectionOs != null && (foundIndex = Arrays.asList(osList).indexOf(this.latestSelectionOs)) != -1) {
            indexSelectedOs = foundIndex;
        }
        this.cbbMobileBrowserOS.select(indexSelectedOs);
        if (!mobileOs.isEmpty()) {
            this.loadDataForCbbMobileBrowserOsVersion(mobileOs.get(indexSelectedOs).getOsVersions());
        }
    }

    private void loadDataForCbbMobileBrowserOsVersion(List<TestCloudMobileOSVersion> osVersions) {
        int foundIndex;
        String[] osVersionList = new String[osVersions.size()];
        int i = 0;
        while (i < osVersions.size()) {
            osVersionList[i] = osVersions.get(i).getOsVersion();
            ++i;
        }
        this.cbbMobileBrowserOSVersion.setItems(osVersionList);
        int indexSelectedOsVersion = 0;
        if (this.latestSelectionOsVersion != null && (foundIndex = Arrays.asList(osVersionList).indexOf(this.latestSelectionOsVersion)) != -1) {
            indexSelectedOsVersion = foundIndex;
        }
        this.cbbMobileBrowserOSVersion.select(indexSelectedOsVersion);
        if (!osVersions.isEmpty()) {
            this.loadDataForCbbMobileBrowserDevice(osVersions.get(indexSelectedOsVersion).getDeviceList());
        }
    }

    private void loadDataForCbbMobileBrowserDevice(List<TestCloudMobileDevice> listDevice) {
        int foundIndex;
        listDevice.sort(TestCloudMobileUtils.sortPrivateDevicesFirst());
        String[] deviceName = new String[listDevice.size()];
        int i = 0;
        while (i < listDevice.size()) {
            deviceName[i] = TestCloudMobileUtils.getDeviceDisplayName(listDevice.get(i));
            ++i;
        }
        this.cbbMobileBrowserDeviceName.setItems(deviceName);
        int indexDevice = 0;
        if (this.latestSelectionDeviceName != null && (foundIndex = Arrays.asList(deviceName).indexOf(this.latestSelectionDeviceName)) != -1) {
            indexDevice = foundIndex;
        }
        this.cbbMobileBrowserDeviceName.select(indexDevice);
        this.cbbMobileBrowserDeviceName.setToolTipText(this.cbbMobileBrowserDeviceName.getText());
    }

    public void selectMobileBrowserOS(String browserOS) {
        this.cbbMobileBrowserOS.setText(browserOS);
        if (this.mobileDeviceList != null && !this.mobileDeviceList.isEmpty()) {
            TestCloudMobileOS selectedOS = this.mobileDeviceList.get(this.cbbMobileBrowserOS.getSelectionIndex());
            this.loadDataForCbbMobileBrowserOsVersion(selectedOS.getOsVersions());
        }
    }

    public void selectMobileBrowserOSVersion(String browserOSVersion) {
        this.cbbMobileBrowserOSVersion.setText(browserOSVersion);
        if (this.mobileDeviceList != null && !this.mobileDeviceList.isEmpty()) {
            this.loadDataForCbbMobileBrowserDevice(((TestCloudMobileOSVersion)this.mobileDeviceList.get(this.cbbMobileBrowserOS.getSelectionIndex()).getOsVersions().get(this.cbbMobileBrowserOSVersion.getSelectionIndex())).getDeviceList());
        }
    }

    public void selectMobileBrowserDevice(String mobileBrowserDevice) {
        this.cbbMobileBrowserDeviceName.setText(mobileBrowserDevice);
        this.cbbMobileBrowserDeviceName.setToolTipText(this.cbbMobileBrowserDeviceName.getText());
    }

    public void selectHighAvailableDevice(boolean isHighAvailableDevice) {
        this.mobileDeviceList = isHighAvailableDevice ? TestCloudMobileUtils.filteredMobileDeviceList(this.originalMobileDeviceList, TestCloudMobileAvailability.HIGH) : this.originalMobileDeviceList;
        this.loadDataForCbbMobileBrowserOs(this.mobileDeviceList);
        this.btnHighAvailableDevice.setSelection(isHighAvailableDevice);
    }

    public void loadSelectedTestCloudMobileOptions(TestCloudMobileDevice mobile) {
        this.btnHighAvailableDevice.setSelection(mobile.isHighAvailableDevice());
        this.mobileDeviceList = mobile.isHighAvailableDevice() ? TestCloudMobileUtils.filteredMobileDeviceList(this.originalMobileDeviceList, TestCloudMobileAvailability.HIGH) : this.originalMobileDeviceList;
        String[] mobileOsList = this.cbbMobileBrowserOS.getItems();
        boolean foundOS = false;
        int i = 0;
        while (i < mobileOsList.length) {
            if (mobileOsList[i].equalsIgnoreCase(mobile.getOs())) {
                this.selectMobileBrowserOS(mobile.getOs());
                foundOS = true;
                break;
            }
            ++i;
        }
        if (!foundOS) {
            this.selectMobileBrowserOS("");
        }
        String[] mobileOsVersionList = this.cbbMobileBrowserOSVersion.getItems();
        boolean foundMobileOsVersion = false;
        int i2 = 0;
        while (i2 < mobileOsVersionList.length) {
            if (mobileOsVersionList[i2].equalsIgnoreCase(mobile.getOsVersion())) {
                this.selectMobileBrowserOSVersion(mobile.getOsVersion());
                foundMobileOsVersion = true;
                break;
            }
            ++i2;
        }
        if (!foundMobileOsVersion) {
            this.selectMobileBrowserOSVersion("");
        }
        String[] deviceNameList = this.cbbMobileBrowserDeviceName.getItems();
        int i3 = 0;
        while (i3 < deviceNameList.length) {
            if (deviceNameList[i3].equalsIgnoreCase(TestCloudMobileUtils.getDeviceDisplayName(mobile))) {
                this.selectMobileBrowserDevice(TestCloudMobileUtils.getDeviceDisplayName(mobile));
                return;
            }
            ++i3;
        }
        this.selectMobileBrowserDevice("");
    }

    public String getMobileBrowserOS() {
        return this.cbbMobileBrowserOS.getText();
    }

    public String getMobileBrowserOSVersion() {
        return this.cbbMobileBrowserOSVersion.getText();
    }

    public String getMobileBrowserDeviceName() {
        return this.cbbMobileBrowserDeviceName.getText();
    }

    public int getMobileBrowserOSIndex() {
        return this.cbbMobileBrowserOS.getSelectionIndex();
    }

    public int getMobileBrowserOSVersionIndex() {
        return this.cbbMobileBrowserOSVersion.getSelectionIndex();
    }

    public int getMobileBrowserDeviceNameIndex() {
        return this.cbbMobileBrowserDeviceName.getSelectionIndex();
    }

    public boolean getBtnHighAvailableDevice() {
        return this.btnHighAvailableDevice.getSelection();
    }
}

