/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.testcloud.dialogs;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.testcloud.core.model.TestCloudBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudBrowserVersion;
import com.kms.katalon.testcloud.core.model.TestCloudDesktopBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudOS;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TestCloudWindowsBrowsersTab
extends CTabItem {
    private List<TestCloudOS> environmentList;
    public static final int DEFAULT_HORIZONTAL_INDENT = 10;
    public static final int BUTTON_HORIZONTAL_INDENT = 7;
    public static final int CBB_WIDTH = 30;
    private Combo cbbOs;
    private Combo cbbBrowser;
    private Combo cbbBrowserVersion;

    public TestCloudWindowsBrowsersTab(CTabFolder parent, List<TestCloudOS> environmentList) {
        super(parent, 0);
        this.environmentList = environmentList;
        this.createDesktopBrowserTab(parent);
        this.registerControlListeners();
        this.loadDataForCbbOs(environmentList);
    }

    private void createDesktopBrowserTab(CTabFolder tabFolder) {
        this.setText("Desktop Browsers");
        Composite tabContent = (Composite)ComponentBuilder.gridContainer((Composite)tabFolder, (int)3).fill().margin(10, 10).center().build();
        this.cbbOs = (Combo)ComponentBuilder.comboBox((Composite)tabContent, (int)8).horizontalIndent(10).fillHorizontal().autoWidth(90).build();
        this.cbbBrowser = (Combo)ComponentBuilder.comboBox((Composite)tabContent, (int)8).autoWidth(90).fillHorizontal().horizontalIndent(7).build();
        this.cbbBrowserVersion = (Combo)ComponentBuilder.comboBox((Composite)tabContent, (int)8).autoWidth(120).fillHorizontal().horizontalIndent(7).build();
        this.setControl((Control)tabContent);
    }

    private void registerControlListeners() {
        this.cbbOs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudOS selectedOS = TestCloudWindowsBrowsersTab.this.environmentList.get(TestCloudWindowsBrowsersTab.this.cbbOs.getSelectionIndex());
                TestCloudWindowsBrowsersTab.this.loadDataForCbbBrowser(selectedOS.getBrowsers());
            }
        });
        this.cbbBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudBrowser selectedBrowser = (TestCloudBrowser)TestCloudWindowsBrowsersTab.this.environmentList.get(TestCloudWindowsBrowsersTab.this.cbbOs.getSelectionIndex()).getBrowsers().get(TestCloudWindowsBrowsersTab.this.cbbBrowser.getSelectionIndex());
                TestCloudWindowsBrowsersTab.this.loadDataForCbbBrowserVersion(selectedBrowser.getVersions());
            }
        });
    }

    private void loadDataForCbbOs(List<TestCloudOS> oses) {
        String[] osList = new String[oses.size()];
        int i = 0;
        while (i < oses.size()) {
            osList[i] = oses.get(i).getOsDisplayName();
            ++i;
        }
        this.cbbOs.setItems(osList);
        this.cbbOs.select(0);
        if (!oses.isEmpty()) {
            this.loadDataForCbbBrowser(oses.get(0).getBrowsers());
        }
    }

    private void loadDataForCbbBrowser(List<TestCloudBrowser> browsers) {
        String[] osList = new String[browsers.size()];
        int i = 0;
        while (i < browsers.size()) {
            osList[i] = browsers.get(i).getBrowserDisplayName();
            ++i;
        }
        this.cbbBrowser.setItems(osList);
        this.cbbBrowser.select(0);
        if (!browsers.isEmpty()) {
            this.loadDataForCbbBrowserVersion(browsers.get(0).getVersions());
        }
    }

    private void loadDataForCbbBrowserVersion(List<TestCloudBrowserVersion> versions) {
        String[] osList = new String[versions.size()];
        int i = 0;
        while (i < versions.size()) {
            osList[i] = TestCloudPropertyUtil.getInstance().buildBrowserFullVersion(versions.get(i).getBrowserVersion(), versions.get(i).getBrowserVersionType());
            ++i;
        }
        this.cbbBrowserVersion.setItems(osList);
        this.cbbBrowserVersion.select(0);
    }

    public void selectOS(String os) {
        this.cbbOs.setText(os);
        TestCloudOS selectedOS = this.environmentList.get(this.cbbOs.getSelectionIndex());
        this.loadDataForCbbBrowser(selectedOS.getBrowsers());
    }

    public void selectBrowserName(String browserName) {
        this.cbbBrowser.setText(browserName);
        TestCloudBrowser selectedBrowser = (TestCloudBrowser)this.environmentList.get(this.cbbOs.getSelectionIndex()).getBrowsers().get(this.cbbBrowser.getSelectionIndex());
        this.loadDataForCbbBrowserVersion(selectedBrowser.getVersions());
    }

    public void selectBrowserVersion(String browserVersion) {
        this.cbbBrowserVersion.setText(browserVersion);
    }

    public void loadSelectedTestCloudEnvironmentOptions(TestCloudDesktopBrowser environment) {
        String[] osList = this.cbbOs.getItems();
        boolean foundOS = false;
        int i = 0;
        while (i < osList.length) {
            if (osList[i].equalsIgnoreCase(environment.getOsDisplayName())) {
                this.selectOS(environment.getOsDisplayName());
                foundOS = true;
                break;
            }
            ++i;
        }
        if (!foundOS) {
            this.selectOS("");
        }
        String[] browserNameList = this.cbbBrowser.getItems();
        boolean foundBrowserName = false;
        int i2 = 0;
        while (i2 < browserNameList.length) {
            if (browserNameList[i2].equalsIgnoreCase(environment.getBrowserDisplayName())) {
                this.selectBrowserName(environment.getBrowserDisplayName());
                foundBrowserName = true;
                break;
            }
            ++i2;
        }
        if (!foundBrowserName) {
            this.selectBrowserName("");
        }
        String[] browserVersionList = this.cbbBrowserVersion.getItems();
        int i3 = 0;
        while (i3 < browserVersionList.length) {
            if (browserVersionList[i3].equalsIgnoreCase(environment.getBrowserVersion())) {
                this.selectBrowserVersion(environment.getBrowserVersion());
                return;
            }
            ++i3;
        }
        this.selectBrowserVersion("");
    }

    public String getOS() {
        return this.cbbOs.getText();
    }

    public String getBrowserName() {
        return this.cbbBrowser.getText();
    }

    public String getBrowserVersion() {
        return this.cbbBrowserVersion.getText();
    }

    public int getOSIndex() {
        return this.cbbOs.getSelectionIndex();
    }

    public int getBrowserNameIndex() {
        return this.cbbBrowser.getSelectionIndex();
    }

    public int getBrowserVersionIndex() {
        return this.cbbBrowserVersion.getSelectionIndex();
    }
}

