/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.testcloud.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.composer.components.dialogs.AbstractDialogCellEditor;
import com.kms.katalon.composer.integration.testcloud.dialogs.TestCloudConfigureWithTestSuiteCollectionDialog;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.webui.execution.testsuite.RemoteExecutionDriverEntry;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.json.adapters.LocalDateTimeAdapter;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudDesktopBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import com.kms.katalon.testcloud.core.model.TestCloudMobileBrowserName;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobilePlatformName;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TestCloudExecutionDriverEntry
extends RemoteExecutionDriverEntry {
    protected TestCloudExecutionDriverEntry(String groupName) {
        super((IDriverType)WebUIDriverType.TESTCLOUD_DRIVER, groupName, ImageManager.getImageURLString((String)"testcloud_icon_16x16.png"));
    }

    public CellEditor getRunConfigurationDataCellEditor(Composite parent) {
        return new AbstractDialogCellEditor(parent){

            protected void updateContents(Object value) {
                super.updateContents((Object)TestCloudExecutionDriverEntry.this.displayRunConfigurationData((Map)value));
            }

            protected Object openDialogBox(Control cellEditorWindow) {
                Map configuration = (Map)this.getValue();
                String applicationId = null;
                TestCloudApplication testCloudApplication = TestCloudExecutionDriverEntry.this.getTestCloudMobileApplication(configuration);
                if (Objects.nonNull(testCloudApplication)) {
                    applicationId = testCloudApplication.getId();
                }
                TestCloudConfigureWithTestSuiteCollectionDialog dialog = new TestCloudConfigureWithTestSuiteCollectionDialog(TestCloudExecutionDriverEntry.this.getTestCloudEntity(configuration), applicationId, TestCloudExecutionDriverEntry.this.getTestCloudSessionType(configuration));
                IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
                ContextInjectionFactory.inject((Object)dialog, (IEclipseContext)context);
                if (dialog.open() != 0) {
                    return null;
                }
                TestCloudEntity entity = dialog.getSelectingEntity();
                TestCloudSessionType sessionType = dialog.getSelectingSessionType();
                TestCloudApplication mobileApplication = dialog.getSelectingMobileApplication();
                HashMap<String, String> runConfigurationData = new HashMap<String, String>();
                if (entity instanceof TestCloudDesktopBrowser) {
                    runConfigurationData.put("testCloudDesktopBrowser", JsonUtil.toJson((Object)entity));
                } else {
                    runConfigurationData.put("testCloudMobileDevice", JsonUtil.toJson((Object)entity));
                }
                runConfigurationData.put("testCloudSessionType", sessionType.toString());
                if (Objects.nonNull(mobileApplication)) {
                    Gson gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).create();
                    runConfigurationData.put("testCloudOverrideMobileApplication", gson.toJson((Object)mobileApplication));
                }
                return runConfigurationData;
            }
        };
    }

    public Map<String, String> changeRunConfigurationData(Shell shell, Map<String, String> runConfigurationData) {
        String applicationId = null;
        TestCloudApplication testCloudApplication = this.getTestCloudMobileApplication(runConfigurationData);
        if (Objects.nonNull(testCloudApplication)) {
            applicationId = testCloudApplication.getId();
        }
        TestCloudConfigureWithTestSuiteCollectionDialog dialog = new TestCloudConfigureWithTestSuiteCollectionDialog(this.getTestCloudEntity(runConfigurationData), applicationId, this.getTestCloudSessionType(runConfigurationData));
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        ContextInjectionFactory.inject((Object)dialog, (IEclipseContext)context);
        if (dialog.open() != 0) {
            return runConfigurationData;
        }
        HashMap<String, String> updatedData = new HashMap<String, String>();
        TestCloudEntity entity = dialog.getSelectingEntity();
        if (entity instanceof TestCloudDesktopBrowser) {
            updatedData.put("testCloudDesktopBrowser", JsonUtil.toJson((Object)entity));
        } else {
            updatedData.put("testCloudMobileDevice", JsonUtil.toJson((Object)entity));
        }
        TestCloudSessionType sessionType = dialog.getSelectingSessionType();
        updatedData.put("testCloudSessionType", sessionType.toString());
        TestCloudApplication mobileApplication = dialog.getSelectingMobileApplication();
        if (Objects.nonNull(mobileApplication)) {
            Gson gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).create();
            updatedData.put("testCloudOverrideMobileApplication", gson.toJson((Object)mobileApplication));
        }
        return updatedData;
    }

    public String displayRunConfigurationData(Map<String, String> runConfigurationData) {
        TestCloudEntity entity = this.getTestCloudEntity(runConfigurationData);
        if (Objects.isNull(entity)) {
            return "";
        }
        TestCloudSessionType testCloudSessionType = this.getTestCloudSessionType(runConfigurationData);
        if (TestCloudSessionType.DESKTOP_BROWSER.equals((Object)testCloudSessionType)) {
            return this.getBrowserDisplayName((TestCloudDesktopBrowser)entity, testCloudSessionType);
        }
        if (TestCloudSessionType.MOBILE_BROWSER.equals((Object)testCloudSessionType)) {
            TestCloudMobileBrowserName browserName = null;
            if (entity.getPlatformName().equals((Object)TestCloudMobilePlatformName.ANDROID)) {
                browserName = TestCloudMobileBrowserName.CHROME;
            } else if (entity.getPlatformName().equals((Object)TestCloudMobilePlatformName.ANDROID)) {
                browserName = TestCloudMobileBrowserName.SAFARI;
            }
            String browserDisplayName = "";
            if (Objects.nonNull(browserName)) {
                browserDisplayName = StringUtils.capitalize((String)browserName.toString().toLowerCase());
            }
            return this.getMobileDisplayName((TestCloudMobileDevice)entity, testCloudSessionType) + ", " + browserDisplayName;
        }
        if (TestCloudSessionType.MOBILE_NATIVE.equals((Object)testCloudSessionType)) {
            TestCloudApplication mobileApplication = this.getTestCloudMobileApplication(runConfigurationData);
            if (Objects.nonNull(mobileApplication)) {
                return this.getMobileDisplayName((TestCloudMobileDevice)entity, testCloudSessionType) + ", " + mobileApplication.getName();
            }
            return this.getMobileDisplayName((TestCloudMobileDevice)entity, testCloudSessionType);
        }
        return "";
    }

    private String getMobileDisplayName(TestCloudMobileDevice testCloudEntity, TestCloudSessionType sessionType) {
        if (testCloudEntity.getDisplayName() == null) {
            testCloudEntity.setDisplayName(testCloudEntity.getName());
        }
        if (TestCloudSessionType.MOBILE_NATIVE.equals((Object)sessionType)) {
            return testCloudEntity.getDisplayName() + ", version=" + testCloudEntity.getOsVersion();
        }
        return testCloudEntity.getDisplayName() + ", version=" + testCloudEntity.getOsVersion() + ", Tunnel=" + testCloudEntity.isUsingTunnel();
    }

    private String getBrowserDisplayName(TestCloudDesktopBrowser testCloudEntity, TestCloudSessionType sessionType) {
        String browserFullVersion = TestCloudPropertyUtil.getInstance().buildBrowserFullVersion(testCloudEntity.getBrowserVersion(), testCloudEntity.getBrowserVersionType());
        return testCloudEntity.getOsDisplayName() + " " + testCloudEntity.getBrowserDisplayName() + " " + browserFullVersion + ", Tunnel=" + testCloudEntity.isUsingTunnel();
    }

    private TestCloudEntity getTestCloudEntity(Map<String, String> runConfigurationData) {
        if (runConfigurationData == null) {
            return null;
        }
        String desktopBrowserEntityJson = runConfigurationData.get("testCloudDesktopBrowser");
        if (StringUtils.isNotBlank((String)desktopBrowserEntityJson)) {
            return (TestCloudEntity)JsonUtil.fromJson((String)desktopBrowserEntityJson, TestCloudDesktopBrowser.class);
        }
        String mobileDeviceEntityJson = runConfigurationData.get("testCloudMobileDevice");
        if (StringUtils.isNotBlank((String)mobileDeviceEntityJson)) {
            TestCloudMobileDevice testCloudMobileDevice = (TestCloudMobileDevice)JsonUtil.fromJson((String)mobileDeviceEntityJson, TestCloudMobileDevice.class);
            if (StringUtils.isBlank((String)testCloudMobileDevice.getDisplayName()) && StringUtils.isNotBlank((String)testCloudMobileDevice.getName())) {
                testCloudMobileDevice.setDisplayName(testCloudMobileDevice.getName());
            }
            return testCloudMobileDevice;
        }
        String environmentEntityJson = runConfigurationData.get("testCloudEnvironment");
        if (StringUtils.isNotBlank((String)environmentEntityJson)) {
            return (TestCloudEntity)JsonUtil.fromJson((String)environmentEntityJson, TestCloudDesktopBrowser.class);
        }
        String mobileEntityJson = runConfigurationData.get("testCloudMobile");
        if (StringUtils.isNotBlank((String)mobileEntityJson)) {
            return (TestCloudEntity)JsonUtil.fromJson((String)mobileEntityJson, TestCloudMobileDevice.class);
        }
        return null;
    }

    private TestCloudSessionType getTestCloudSessionType(Map<String, String> runConfigurationData) {
        if (runConfigurationData == null) {
            return TestCloudSessionType.DESKTOP_BROWSER;
        }
        String sessionType = runConfigurationData.get("testCloudSessionType");
        if (StringUtils.isBlank((String)sessionType)) {
            return TestCloudSessionType.DESKTOP_BROWSER;
        }
        return TestCloudSessionType.valueOf((String)sessionType);
    }

    private TestCloudApplication getTestCloudMobileApplication(Map<String, String> runConfigurationData) {
        String applicationJson = runConfigurationData.get("testCloudOverrideMobileApplication");
        if (StringUtils.isNotBlank((String)applicationJson)) {
            Gson gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).create();
            return (TestCloudApplication)gson.fromJson(applicationJson, TestCloudApplication.class);
        }
        return null;
    }

    public boolean requiresExtraConfiguration() {
        return true;
    }
}

