/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.mobile.models;

import com.katalon.capability.constant.DriverType;
import com.katalon.mobile.constants.StringConstants;
import com.katalon.mobile.core.interfaces.IMobileDevice;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class LocalAndroidDevice
implements IMobileDevice {
    private final String ANDROID_EMULATOR_PREFIX = "emulator-";
    private final String RO_PRODUCT_MANUFACTURER = "ro.product.manufacturer";
    private final String RO_PRODUCT_MODEL = "ro.product.model";
    private final String RO_PRODUCT_MARKET_NAME = "ro.product.marketname";
    private final String RO_BUILD_VERSION_RELEASE = "ro.build.version.release";
    private final String NET_BT_NAME = "net.bt.name";
    private final String AVD_NAME = "ro.boot.qemu.avd_name";
    private String deviceId;
    private boolean isEmulator;
    private Map<String, String> properties = new HashMap<String, String>();

    public LocalAndroidDevice(String deviceId) throws IOException, InterruptedException {
        this.deviceId = deviceId;
        this.isEmulator = deviceId.startsWith("emulator-");
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceManufacturer() {
        return this.properties.get("ro.product.manufacturer");
    }

    public String getDeviceModel() {
        return this.properties.get("ro.product.model");
    }

    public String getDeviceName() {
        if (this.isRealDevice()) {
            String deviceName = this.properties.get("ro.product.marketname");
            if (StringUtils.isEmpty((CharSequence)deviceName)) {
                deviceName = this.properties.get("net.bt.name");
            }
            if (StringUtils.isEmpty((CharSequence)deviceName) || deviceName.equalsIgnoreCase("android")) {
                deviceName = this.properties.get("ro.product.model");
            }
            return deviceName;
        }
        return this.properties.get("ro.boot.qemu.avd_name");
    }

    public String getDeviceOs() {
        return "Android";
    }

    public String getDeviceOsVersion() {
        return this.properties.get("ro.build.version.release");
    }

    public boolean isRealDevice() {
        return !this.isEmulator;
    }

    public Map<String, Object> getDeviceSystemProperties() {
        HashMap<String, Object> systemProperties = new HashMap<String, Object>();
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_ID, this.getDeviceId());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_NAME, this.getDeviceName());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_MANUFACTURER, this.getDeviceManufacturer());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_MODEL, this.getDeviceModel());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_OS, this.getDeviceOs());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_OS_VERSON, this.getDeviceOsVersion());
        return systemProperties;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.deviceId).append((Object)this.getDeviceManufacturer()).append((Object)this.getDeviceModel()).append((Object)this.getDeviceOs()).append((Object)this.getDeviceOsVersion()).append(this.isRealDevice()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalAndroidDevice other = (LocalAndroidDevice)obj;
        return new EqualsBuilder().append((Object)this.deviceId, (Object)other.deviceId).append((Object)this.getDeviceManufacturer(), (Object)other.getDeviceManufacturer()).append((Object)this.getDeviceModel(), (Object)other.getDeviceModel()).append((Object)this.getDeviceOs(), (Object)other.getDeviceOs()).append((Object)this.getDeviceOsVersion(), (Object)other.getDeviceOsVersion()).append(this.isRealDevice(), other.isRealDevice()).isEquals();
    }

    public DriverType getDriverType() {
        return DriverType.ANDROID_DRIVER;
    }
}

