/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.mobile.models;

import com.katalon.capability.constant.DriverType;
import com.katalon.mobile.constants.StringConstants;
import com.katalon.mobile.core.interfaces.IMobileDevice;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class LocalIosDevice
implements IMobileDevice {
    private final String PRODUCT_TYPE_INFO = "ProductType";
    private final String PRODUCT_VERSION_INFO = "ProductVersion";
    private final String DEVICE_NAME_INFO = "DeviceName";
    private final String DEVICE_CLASS_INFO = "DeviceClass";
    private final String DEVICE_MANUFACTURER_APPLE = "Apple";
    private final String IPHONE_NAME = "iPhone";
    private final String IPHONE_OS_NAME = "iOS";
    private final String IPAD_NAME = "iPad";
    private final String IPAD_OS_NAME = "iPadOS";
    private String deviceId;
    private Map<String, String> properties = new HashMap<String, String>();

    public LocalIosDevice(String deviceId) throws IOException, InterruptedException {
        this.deviceId = deviceId;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceManufacturer() {
        return "Apple";
    }

    public String getDeviceModel() {
        return this.properties.get("ProductType");
    }

    public String getDeviceName() {
        return this.properties.get("DeviceName");
    }

    public String getDeviceOs() {
        String model = this.getDeviceModel();
        return model.startsWith("iPhone") ? "iOS" : (model.startsWith("iPad") ? "iPadOS" : "Unknown");
    }

    public String getDeviceOsVersion() {
        return this.properties.get("ProductVersion");
    }

    public boolean isRealDevice() {
        return true;
    }

    public Map<String, Object> getDeviceSystemProperties() {
        HashMap<String, Object> systemProperties = new HashMap<String, Object>();
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_ID, this.getDeviceId());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_NAME, this.getDeviceName());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_MANUFACTURER, this.getDeviceManufacturer());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_MODEL, this.getDeviceModel());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_OS, this.getDeviceOs());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_OS_VERSON, this.getDeviceOsVersion());
        return systemProperties;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getDeviceId()).append((Object)this.getDeviceManufacturer()).append((Object)this.getDeviceModel()).append((Object)this.getDeviceOs()).append((Object)this.getDeviceOsVersion()).append(this.isRealDevice()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalIosDevice other = (LocalIosDevice)obj;
        return new EqualsBuilder().append((Object)this.getDeviceId(), (Object)other.getDeviceId()).append((Object)this.getDeviceManufacturer(), (Object)other.getDeviceManufacturer()).append((Object)this.getDeviceModel(), (Object)other.getDeviceModel()).append((Object)this.getDeviceOs(), (Object)other.getDeviceOs()).append((Object)this.getDeviceOsVersion(), (Object)other.getDeviceOsVersion()).append(this.isRealDevice(), other.isRealDevice()).isEquals();
    }

    public DriverType getDriverType() {
        return DriverType.IOS_DRIVER;
    }
}

