/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.mobile.utils;

import com.katalon.mobile.utils.AndroidSdkUtil;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;

public class AdbUtil {
    private static final Pattern LINE_PATTERN = Pattern.compile("\\[(.*?)\\]: \\[(.*?)\\]");
    private static final String ADB = "adb";
    private static final String ADB_WINDOW = "adb.exe";
    private static final String S_FLAG = "-s";
    private static final String SHELL = "shell";
    private static final String GETPROP_COMMAND = "getprop";
    private static final String ANDROID_ADB_DEVICES_COMMAND = "devices";
    private static final String LIST_OF_DEVICES = "list of devices";
    private static final String ANDROID_DEVICE = "device";
    private static String adbPath;

    public static List<String> getDeviceIds() throws IOException, InterruptedException {
        String[] getDevicesCommand = new String[]{AdbUtil.getAdbPath(), ANDROID_ADB_DEVICES_COMMAND};
        ArrayList<String> deviceIds = new ArrayList<String>();
        List resultLines = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])getDevicesCommand);
        if (resultLines != null && !resultLines.isEmpty()) {
            for (String resultLine : resultLines) {
                String trimmedLowerCaseResult = resultLine.toLowerCase().trim();
                if (StringUtils.isEmpty((CharSequence)resultLine) || trimmedLowerCaseResult.contains(LIST_OF_DEVICES) || !trimmedLowerCaseResult.contains(ANDROID_DEVICE)) continue;
                deviceIds.add(resultLine.split("\\s")[0]);
            }
        }
        return deviceIds;
    }

    public static Map<String, String> getDeviceProperties(String deviceId) throws IOException, InterruptedException {
        String[] getPropCommand = new String[]{AdbUtil.getAdbPath(), S_FLAG, deviceId, SHELL, GETPROP_COMMAND};
        List resultLines = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])getPropCommand);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (String resultLine : resultLines) {
            Matcher matcher;
            if (resultLine == null || resultLine.trim().isEmpty() || !(matcher = LINE_PATTERN.matcher(resultLine.trim())).find()) continue;
            String key = matcher.group(1);
            String value = matcher.group(2);
            properties.put(key, value);
        }
        return properties;
    }

    public static Dimension getDeviceResolution(String deviceId) throws IOException, InterruptedException {
        String[] getResolutionCommand = new String[]{AdbUtil.getAdbPath(), S_FLAG, deviceId, SHELL, "wm", "size"};
        List resultLines = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])getResolutionCommand);
        for (String line : resultLines) {
            String sizePart;
            String[] parts;
            if (line == null || !line.trim().startsWith("Physical size:") || (parts = (sizePart = line.trim().replace("Physical size:", "").trim()).split("x")).length != 2) continue;
            int width = Integer.parseInt(parts[0].trim());
            int height = Integer.parseInt(parts[1].trim());
            return new Dimension(width, height);
        }
        throw new IllegalStateException("Unable to detect resolution for " + deviceId);
    }

    public static String getAdbPath() {
        if (adbPath != null && new File(adbPath).exists()) {
            return adbPath;
        }
        String adbFileName = "win32".equals(Platform.getOS()) ? ADB_WINDOW : ADB;
        File adb = new File(AndroidSdkUtil.getPlatformToolsFolder(), adbFileName);
        if (adb != null && adb.exists()) {
            adbPath = adb.toString();
        }
        return adbPath;
    }
}

