/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.mobile.utils;

import com.kms.katalon.core.util.ConsoleCommandExecutor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDeviceUtil {
    private static final Logger logger = LoggerFactory.getLogger(IDeviceUtil.class);
    private static final String PATH = "PATH";

    public static List<String> getDeviceIds() throws IOException, InterruptedException {
        String[] getIosDeviceIdsCommand = new String[]{"/bin/sh", "-c", "idevice_id", "-l"};
        return ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])getIosDeviceIdsCommand, IDeviceUtil.getAdditionalEnvironmentVariables());
    }

    public static Map<String, String> getDeviceProperties(String deviceId) throws IOException, InterruptedException {
        String[] getIosDeviceInfoCommand = new String[]{"/bin/sh", "-c", "ideviceinfo", "-u", deviceId};
        return IDeviceUtil.parseIosDeviceInfo(ConsoleCommandExecutor.runConsoleCommand((String[])getIosDeviceInfoCommand, IDeviceUtil.getAdditionalEnvironmentVariables()));
    }

    public static boolean validateIosDevicePairing(String deviceId) throws IOException, InterruptedException {
        String[] validateIosDevicePairingCommand = new String[]{"/bin/sh", "-c", "idevicepair", "validate", "-u", deviceId};
        List resultLines = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])validateIosDevicePairingCommand, IDeviceUtil.getAdditionalEnvironmentVariables());
        String result = StringUtils.join((Iterable)resultLines, (String)"\n");
        return StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"SUCCESS");
    }

    public static Dimension getIosDeviceResolution(String deviceId) throws IOException, InterruptedException {
        String[] getResolutionCommand = new String[]{"/bin/sh", "-c", "ideviceinfo -u " + deviceId + " -q com.apple.mobile.iTunes"};
        List resultLines = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])getResolutionCommand, IDeviceUtil.getAdditionalEnvironmentVariables());
        Integer width = null;
        Integer height = null;
        for (String line : resultLines) {
            try {
                if (line.startsWith("ScreenWidth:")) {
                    width = Integer.parseInt(line.split(":", 2)[1].trim());
                    continue;
                }
                if (!line.startsWith("ScreenHeight:")) continue;
                height = Integer.parseInt(line.split(":", 2)[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                logger.error("Skipping malformed dimension line: " + line);
            }
        }
        if (width != null && height != null) {
            return new Dimension(width, height);
        }
        throw new IllegalStateException("Unable to detect resolution for " + deviceId);
    }

    public static Integer getIosDeviceScaleFactor(String deviceId) throws IOException, InterruptedException {
        String[] getScaleCommand = new String[]{"/bin/sh", "-c", "ideviceinfo -u " + deviceId + " -q com.apple.mobile.iTunes"};
        List resultLines = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])getScaleCommand, IDeviceUtil.getAdditionalEnvironmentVariables());
        for (String line : resultLines) {
            if (!line.startsWith("ScreenScaleFactor:")) continue;
            return Integer.parseInt(line.split(":", 2)[1].trim());
        }
        return null;
    }

    private static Map<String, String> parseIosDeviceInfo(String input) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Pattern kvPattern = Pattern.compile("^([^:]+):\\s*(.*)$");
        Pattern listItemPattern = Pattern.compile("^(\\s+)([^:]+):\\s*(.*)$");
        Throwable throwable = null;
        Object var5_6 = null;
        try (Scanner scanner = new Scanner(input);){
            ArrayDeque<String> contextStack = new ArrayDeque<String>();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.trim().isEmpty()) continue;
                Matcher kv = kvPattern.matcher(line);
                if (kv.matches() && !line.startsWith(" ")) {
                    String key = kv.group(1).trim();
                    String value = kv.group(2).trim();
                    if (value.isEmpty()) {
                        contextStack.clear();
                        contextStack.push(key);
                        continue;
                    }
                    map.put(key, value);
                    continue;
                }
                Matcher listItem = listItemPattern.matcher(line);
                if (!listItem.matches()) continue;
                String indentKey = listItem.group(2).trim();
                String value = listItem.group(3).trim();
                String prefix = StringUtils.join(contextStack.descendingIterator(), (char)'.');
                String fullKey = prefix.isEmpty() ? indentKey : prefix + "." + indentKey;
                map.put(fullKey, value);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return map;
    }

    private static Map<String, String> getAdditionalEnvironmentVariables() {
        HashMap<String, String> additionalEnvironmentVariables = new HashMap<String, String>();
        String path = StringUtils.defaultString((String)System.getenv(PATH));
        StringBuilder sb = new StringBuilder(path);
        sb.append(File.pathSeparator).append("/usr/local/bin");
        sb.append(File.pathSeparator).append("/opt/homebrew/bin");
        additionalEnvironmentVariables.put(PATH, sb.toString());
        return additionalEnvironmentVariables;
    }
}

