/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.mobile.utils;

import com.kms.katalon.core.util.ConsoleCommandExecutor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class XcrunUtil {
    private static final Pattern DEVICE_PATTERN = Pattern.compile("^\\s{4}(.+)\\s\\(([0-9A-Fa-f-]+)\\)\\s\\((\\w+)\\)\\s");
    public static final String SIMULATOR_DEVICE_NAME = "SIMULATOR_DEVICE_NAME";
    public static final String SIMULATOR_DEVICE_MODEL = "SIMULATOR_MODEL_IDENTIFIER";
    public static final String SIMULATOR_OS_VERSION = "SIMULATOR_RUNTIME_VERSION";
    public static final String SIMULATOR_DEVICE_SCREEN_WIDTH = "SIMULATOR_DEVICE_SCREEN_WIDTH";
    public static final String SIMULATOR_DEVICE_SCREEN_HEIGHT = "SIMULATOR_DEVICE_SCREEN_HEIGHT";
    public static final String SIMULATOR_DEVICE_SCREEN_SCALE = "SIMULATOR_DEVICE_SCREEN_SCALE";

    public static List<String> getSimulatorIds() throws IOException, InterruptedException {
        String[] getIosSimulatorIdsCommand = new String[]{"xcrun", "simctl", "list"};
        return XcrunUtil.parseUdids(ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])getIosSimulatorIdsCommand));
    }

    public static Map<String, String> getSimulatorProperties(String deviceId) throws IOException, InterruptedException {
        String osVersion;
        String deviceModel;
        HashMap<String, String> map = new HashMap<String, String>();
        String deviceName = XcrunUtil.getIosSimulatorProperty(deviceId, SIMULATOR_DEVICE_NAME);
        if (StringUtils.isNotEmpty((CharSequence)deviceName)) {
            map.put(SIMULATOR_DEVICE_NAME, deviceName);
        }
        if (StringUtils.isNotEmpty((CharSequence)(deviceModel = XcrunUtil.getIosSimulatorProperty(deviceId, SIMULATOR_DEVICE_MODEL)))) {
            map.put(SIMULATOR_DEVICE_MODEL, deviceModel);
        }
        if (StringUtils.isNotEmpty((CharSequence)(osVersion = XcrunUtil.getIosSimulatorProperty(deviceId, SIMULATOR_OS_VERSION)))) {
            map.put(SIMULATOR_OS_VERSION, osVersion);
        }
        return map;
    }

    private static String getIosSimulatorProperty(String deviceId, String property) throws IOException, InterruptedException {
        String[] getIosSimulatorPropertyCommand = new String[]{"xcrun", "simctl", "getenv", deviceId, property};
        return ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])getIosSimulatorPropertyCommand);
    }

    private static List<String> parseUdids(List<String> lines) {
        ArrayList<String> udids = new ArrayList<String>();
        boolean insideDevicesSection = false;
        for (String line : lines) {
            if (line.startsWith("== Devices ==")) {
                insideDevicesSection = true;
                continue;
            }
            if (!insideDevicesSection) continue;
            if (line.startsWith("== Device Pairs ==")) break;
            Matcher matcher = DEVICE_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            udids.add(matcher.group(2).trim());
        }
        return udids;
    }
}

