/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.folder.handlers.deletion.IDeleteFolderHandler;
import com.kms.katalon.composer.testdata.constants.ComposerTestdataMessageConstants;
import com.kms.katalon.composer.testdata.handlers.DeleteTestDataHandler;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteTestDataFolderHandler
extends DeleteTestDataHandler
implements IDeleteFolderHandler {
    public FolderEntity.FolderType getFolderType() {
        return FolderEntity.FolderType.DATAFILE;
    }

    public boolean execute(FolderTreeEntity folderTreeEntity, IProgressMonitor monitor) {
        try {
            if (folderTreeEntity == null || folderTreeEntity.getObject() == null) {
                return false;
            }
            FolderEntity folderEntity = folderTreeEntity.getObject();
            String folderId = folderEntity.getIdForDisplay();
            List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(folderEntity);
            monitor.beginTask(MessageFormat.format(ComposerTestdataMessageConstants.HAND_JOB_DELETING_FOLDER, folderId), descendantEntities.size() + 1);
            List affectedTestCaseScripts = TestArtifactScriptRefactor.createForFolderEntity((FolderEntity)folderEntity).findReferrersInTestCaseScripts(ProjectController.getInstance().getCurrentProject());
            ArrayList<DataFileEntity> undeleteTestDatas = new ArrayList<DataFileEntity>();
            for (Object entity : descendantEntities) {
                if (monitor.isCanceled()) {
                    return false;
                }
                if (entity instanceof DataFileEntity && !this.deleteTestData((DataFileEntity)entity, monitor, affectedTestCaseScripts)) {
                    undeleteTestDatas.add((DataFileEntity)entity);
                    continue;
                }
                if (!(entity instanceof FolderEntity)) continue;
                this.deleteFolder((FolderEntity)entity, undeleteTestDatas, monitor);
            }
            this.deleteFolder(folderEntity, undeleteTestDatas, monitor);
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)folderTreeEntity.getParent());
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private boolean deleteTestData(DataFileEntity testData, IProgressMonitor monitor, List<IFile> affectedTestCaseScripts) {
        try {
            String testDataId = testData.getIdForDisplay();
            monitor.subTask(MessageFormat.format(ComposerTestdataMessageConstants.HAND_JOB_DELETING_ENTITY, testDataId));
            boolean bl = this.performDeleteTestData(testData, TestArtifactScriptRefactor.createForTestDataEntity((String)testDataId).findReferrers(affectedTestCaseScripts));
            return bl;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.worked(1);
        }
    }
}

