/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.handlers;

import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.AbstractDeleteReferredEntityHandler;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.composer.testdata.constants.ComposerTestdataMessageConstants;
import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.composer.testdata.dialog.TestDataReferencesDialog;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testcase.events.TestCaseUpdatedEvent;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

public class DeleteTestDataHandler
extends AbstractDeleteReferredEntityHandler {
    public Class<? extends ITreeEntity> entityType() {
        return TestDataTreeEntity.class;
    }

    public boolean execute(ITreeEntity entity, IProgressMonitor monitor) {
        try {
            if (entity == null || !(entity instanceof TestDataTreeEntity)) {
                return false;
            }
            DataFileEntity testData = (DataFileEntity)entity.getObject();
            if (testData == null) {
                return false;
            }
            monitor.beginTask(MessageFormat.format(ComposerTestdataMessageConstants.HAND_JOB_DELETING_ENTITY_W_TYPE_NAME, entity.getTypeName(), entity.getText()), 1);
            String testDataId = testData.getIdForDisplay();
            if (this.performDeleteTestData(testData, TestArtifactScriptRefactor.createForTestDataEntity((String)testDataId).findReferrersInTestCaseScripts(ProjectController.getInstance().getCurrentProject()))) {
                this.eventBroker.post("EXPLORER/DELETED_SELECTED_ITEM", (Object)testDataId);
                return true;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)ComposerTestdataMessageConstants.HAND_ERROR_MSG_UNABLE_TO_DEL_TEST_DATA);
        }
        finally {
            monitor.done();
        }
        return false;
    }

    protected boolean performDeleteTestData(final DataFileEntity testData, final List<IFile> affectedTestCaseScripts) {
        this.isDeleted = false;
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String testDataId = testData.getIdForDisplay();
                    TestDataController tdController = TestDataController.getInstance();
                    Map referencesInTestSuite = tdController.getTestDataReferences(testData);
                    List affectedTestCases = TestCaseEntityUtil.getTestCaseEntities((List)affectedTestCaseScripts);
                    List affectedTestCasesBinding = tdController.getTestDataReferencesInTestCaseBinding(testData);
                    for (TestCaseEntity tc : affectedTestCasesBinding) {
                        if (affectedTestCases.contains(tc)) continue;
                        affectedTestCases.add(tc);
                    }
                    if (!referencesInTestSuite.values().isEmpty() || !affectedTestCases.isEmpty()) {
                        if (DeleteTestDataHandler.this.isDefaultResponse()) {
                            TestDataReferencesDialog dialog = new TestDataReferencesDialog(null, testDataId, referencesInTestSuite, affectedTestCases, DeleteTestDataHandler.this.needYesNoToAllButtons());
                            DeleteTestDataHandler.this.setResponse(dialog.open());
                        }
                        if (DeleteTestDataHandler.this.isCancelResponse()) {
                            return;
                        }
                        if (DeleteTestDataHandler.this.isYesResponse()) {
                            DeleteTestDataHandler.this.removeReferencesInTestSuites(testData, referencesInTestSuite);
                            TestArtifactScriptRefactor.createForTestDataEntity((String)testDataId).removeReferences(affectedTestCaseScripts);
                            DeleteTestDataHandler.this.removeReferencesInTestCasesBinding(testData, affectedTestCasesBinding);
                        }
                    }
                    EntityPartUtil.closePart((IEntity)testData);
                    tdController.deleteDataFile(testData);
                    if (!DeleteTestDataHandler.this.isYesNoToAllResponse()) {
                        DeleteTestDataHandler.this.resetResponse();
                    }
                    DeleteTestDataHandler.this.isDeleted = true;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
        return this.isDeleted;
    }

    protected void removeReferencesInTestSuites(DataFileEntity dataFileEntity, Map<String, List<TestSuiteTestCaseLink>> testDataReferences) throws Exception {
        String dataFileId = dataFileEntity.getIdForDisplay();
        for (Map.Entry<String, List<TestSuiteTestCaseLink>> entry : testDataReferences.entrySet()) {
            for (TestSuiteTestCaseLink testCaseLink : entry.getValue()) {
                ArrayList<TestCaseTestDataLink> removedTestDataLinks = new ArrayList<TestCaseTestDataLink>();
                for (TestCaseTestDataLink testDataLink : testCaseLink.getTestDataLinks()) {
                    if (!dataFileId.equals(testDataLink.getTestDataId())) continue;
                    removedTestDataLinks.add(testDataLink);
                    for (VariableLink variableLink : testCaseLink.getVariableLinks()) {
                        if (!testDataLink.getId().equals(variableLink.getTestDataLinkId())) continue;
                        variableLink.setTestDataLinkId(StringConstants.EMPTY);
                        variableLink.setType(VariableLink.VariableType.DEFAULT);
                        variableLink.setValue(StringConstants.EMPTY);
                    }
                }
                testCaseLink.getTestDataLinks().removeAll(removedTestDataLinks);
            }
            TestSuiteController tsController = TestSuiteController.getInstance();
            TestSuiteEntity testSuite = tsController.getTestSuiteByDisplayId(entry.getKey(), ProjectController.getInstance().getCurrentProject());
            tsController.updateTestSuite(testSuite);
            this.eventBroker.post("TESTSUITE/UPDATED", (Object)new Object[]{testSuite.getId(), testSuite});
        }
    }

    private void removeReferencesInTestCasesBinding(DataFileEntity dataFileEntity, List<TestCaseEntity> testCaseReferences) throws Exception {
        String dataFileId = dataFileEntity.getIdForDisplay();
        for (TestCaseEntity tcEntity : testCaseReferences) {
            ArrayList<TestCaseTestDataLink> removedTestDataLinks = new ArrayList<TestCaseTestDataLink>();
            for (TestCaseTestDataLink testDataLink : tcEntity.getTestDataLinks()) {
                if (!dataFileId.equals(testDataLink.getTestDataId())) continue;
                removedTestDataLinks.add(testDataLink);
                for (VariableLink variableLink : tcEntity.getVariableLinks()) {
                    if (!testDataLink.getId().equals(variableLink.getTestDataLinkId())) continue;
                    variableLink.setTestDataLinkId(StringConstants.EMPTY);
                    variableLink.setType(VariableLink.VariableType.DEFAULT);
                    variableLink.setValue(StringConstants.EMPTY);
                }
            }
            tcEntity.getTestDataLinks().removeAll(removedTestDataLinks);
            TestCaseController tcController = TestCaseController.getInstance();
            tcController.updateTestCase(tcEntity);
            this.eventBroker.post("TESTCASE/UPDATED", (Object)new TestCaseUpdatedEvent(tcEntity.getId(), (FileEntity)tcEntity));
        }
    }
}

