/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RefreshTestDataHandler {
    @Inject
    IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                if (ProjectController.getInstance().getCurrentProject() == null) {
                    return;
                }
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof TestDataTreeEntity) {
                    try {
                        RefreshTestDataHandler.this.excute((TestDataTreeEntity)object);
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            }
        });
    }

    private void excute(TestDataTreeEntity testDataTreeEntity) throws Exception {
        if (testDataTreeEntity.getObject() == null) {
            ITreeEntity parentEntity = testDataTreeEntity.getParent();
            if (parentEntity != null && parentEntity instanceof FolderTreeEntity) {
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)parentEntity);
            } else {
                FolderEntity folder = FolderController.getInstance().getTestDataRoot(ProjectController.getInstance().getCurrentProject());
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)new FolderTreeEntity(folder, null));
            }
        } else {
            DataFileEntity dataFile = testDataTreeEntity.getObject();
            FolderController.getInstance().refreshFolder(dataFile.getParentFolder());
        }
    }
}

