/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.application;

import com.kms.katalon.console.entity.ConsoleLauncherEntity;
import com.kms.katalon.console.handlers.ActivationHandler;
import com.kms.katalon.console.handlers.ArgumentOptionsHandler;
import com.kms.katalon.console.handlers.FileReader;
import com.kms.katalon.console.strategy.ConsoleModeStrategy;
import com.kms.katalon.console.strategy.ConsoleModeStrategyFactory;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.testcloud.core.service.ITestCloudController;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ConsoleMain {
    @Inject
    private IEclipseContext context;
    @Inject
    private ActivationHandler activator;
    @Inject
    private ITestOpsController testOpsController;
    @Inject
    private ITestCloudController testCloudController;
    @Inject
    private ISessionController sessionController;
    @Inject
    private ConsoleModeStrategyFactory strategyFactory;
    private volatile boolean stopFlag = false;

    private int checkingEnvironment() {
        boolean isDevelopmentMode = Platform.inDevelopmentMode();
        boolean isRunningInKatalonC = ExecutionUtil.isRunningInKatalonC();
        if (!isDevelopmentMode && !isRunningInKatalonC) {
            LogUtil.printErrorLine((String)ExecutionMessageConstants.ACTIVATE_MOVE_TO_KATALONC);
            return 4;
        }
        return 200;
    }

    public void stopConsoleProcess() {
        if (this.stopFlag) {
            return;
        }
        this.stopFlag = true;
        this.alwaysStopAllLaunchers();
        this.waitForLaunchersToFinishOrTimeoutInMinute(Duration.ofMinutes(1L));
        try {
            this.activator.deactivate();
        }
        catch (Exception e) {
            LogUtil.printErrorLine((String)e.getMessage());
            LogUtil.logError((Throwable)e);
        }
    }

    public int launch(String[] arguments) {
        try {
            int exitCode;
            int code = this.checkingEnvironment();
            if (code != 200) {
                int n = code;
                return n;
            }
            ConsoleLauncherEntity consoleLauncherEntity = new ConsoleLauncherEntity(arguments);
            this.loadArgumentsFromFile(consoleLauncherEntity);
            ConsoleMode mode = ConsoleMode.EXECUTION;
            if (consoleLauncherEntity.getOptions().has("mode")) {
                String modeString = String.valueOf(consoleLauncherEntity.getOptions().valueOf("mode"));
                mode = ConsoleMode.fromString(modeString);
            }
            ConsoleModeStrategy strategy = this.strategyFactory.createStrategy(mode);
            int n = exitCode = strategy.execute(consoleLauncherEntity);
            return n;
        }
        catch (InvalidConsoleArgumentException e) {
            LogUtil.printErrorLine((String)e.getMessage());
            return 4;
        }
        catch (ExecutionException e) {
            if (e.getMessage().contains("Cannot execute this test suite")) {
                LogUtil.printErrorLine((String)e.getMessage());
            } else {
                LogUtil.printErrorLine((String)ExceptionUtils.getStackTrace((Throwable)e));
            }
            return 2;
        }
        catch (Throwable e) {
            LogUtil.printErrorLine((String)ExceptionUtils.getStackTrace((Throwable)e));
            return 2;
        }
        finally {
            this.activator.endScheduleCheckLicense();
            try {
                this.activator.deactivate();
            }
            catch (Exception ex) {
                LogUtil.printErrorLine((String)ex.getMessage());
            }
            LauncherManager.getInstance().removeAllTerminated();
        }
    }

    private void loadArgumentsFromFile(ConsoleLauncherEntity consoleLauncherEntity) throws Exception {
        FileReader.readArgumentFromFile(consoleLauncherEntity);
        consoleLauncherEntity.updateOptions();
        ArgumentOptionsHandler.getInstance().setOptions(consoleLauncherEntity.getOptions());
    }

    private void alwaysStopAllLaunchers() {
        try {
            LauncherManager.getInstance().getSortedLaunchers().forEach(launcher -> {
                try {
                    launcher.stop();
                }
                catch (Exception e) {
                    LogUtil.logError((String)("Error while stopping launcher: " + launcher.getName()));
                    LogUtil.logError((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            LogUtil.logError((String)"Error while stopping all launchers");
            LogUtil.logError((Throwable)e);
        }
    }

    private void waitForLaunchersToFinishOrTimeoutInMinute(Duration maxWaitTimeInMinute) {
        Duration pollInterval = Duration.ofMillis(100L);
        long pollIntervalMs = pollInterval.toMillis();
        long maxPollingCounts = maxWaitTimeInMinute.toMillis() / pollIntervalMs;
        int count = 0;
        try {
            while (LauncherManager.getInstance().isAnyLauncherRunning()) {
                Thread.sleep(pollIntervalMs);
                if ((long)count++ < maxPollingCounts) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            LogUtil.logError((String)"Thread interrupted while waiting for processes to finish");
            LogUtil.logError((Throwable)e);
        }
        catch (Exception e) {
            LogUtil.logError((String)"Error while waiting for launchers to finish or timeout");
            LogUtil.logError((Throwable)e);
        }
    }

    public static enum ConsoleMode {
        EXECUTION("execution"),
        REPORTING("reporting");

        private final String mode;

        private ConsoleMode(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        public static ConsoleMode fromString(String modeString) {
            if (modeString == null || modeString.trim().isEmpty()) {
                return EXECUTION;
            }
            String normalizedMode = modeString.toLowerCase().trim();
            ConsoleMode[] consoleModeArray = ConsoleMode.values();
            int n = consoleModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleMode mode = consoleModeArray[n2];
                if (mode.getMode().equals(normalizedMode)) {
                    return mode;
                }
                ++n2;
            }
            return EXECUTION;
        }

        public String toString() {
            return this.mode;
        }
    }
}

