/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.http;

import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.qas.api.ApiServiceRequest;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.http.HttpRequest;
import org.qas.api.internal.util.google.base.Preconditions;
import org.qas.api.internal.util.google.base.Strings;

public abstract class AbstractHttpRequest<T>
implements HttpRequest<T> {
    protected final Request request;

    protected AbstractHttpRequest(Request request) {
        Preconditions.checkNotNull(request);
        this.request = request;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.request.getHttpMethod();
    }

    @Override
    public void setHttpMethod(HttpMethod httpMethod) {
        this.request.setHttpMethod(httpMethod);
    }

    @Override
    public InputStream getContent() {
        return this.request.getContent();
    }

    @Override
    public void setContent(InputStream content) {
        this.request.setContent(content);
    }

    @Override
    public int getTimeOffset() {
        return this.request.getTimeOffset();
    }

    @Override
    public void setTimeOffset(int timeOffset) {
        this.request.setTimeOffset(timeOffset);
    }

    @Override
    public String getResourcePath() {
        return this.request.getResourcePath();
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.request.setResourcePath(resourcePath);
    }

    @Override
    public String getServiceName() {
        return this.request.getServiceName();
    }

    @Override
    public URI getEndpoint() {
        return this.request.getEndpoint();
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.request.getHeaders());
    }

    @Override
    public void setHeader(String name, String value) {
        this.request.setHeader(name, value);
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.request.setHeaders(headers);
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.request.getParameters());
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.request.setParameters(parameters);
    }

    @Override
    public void addParameter(String name, String value) {
        this.request.addParameter(name, value);
    }

    @Override
    public ApiServiceRequest getOriginalRequest() {
        return this.request.getOriginalRequest();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<http-request>\n");
        builder.append("\t<service-name value=\"").append(this.getServiceName()).append("\"/>\n");
        builder.append("\t<http-method value=\"").append(this.getHttpMethod().name()).append("\"/>\n");
        builder.append("\t<endpoint value=\"").append(this.getEndpoint().toString()).append("\"/>\n");
        builder.append("\t<content-type value=\"").append(this.getContentType()).append("\"/>\n");
        builder.append("\t<content-length value=\"").append(this.getContentLength()).append("\"/>\n");
        String resourcePath = this.getResourcePath();
        if (!Strings.isNullOrEmpty(resourcePath)) {
            builder.append("\t<resource-path value=\"").append(resourcePath).append("\"/>\n");
        }
        builder.append("\t<time-offset value=\"").append(this.getTimeOffset()).append("\"/>\n");
        builder.append("\t<headers>").append(this.getHeaders().toString()).append("</headers>\n");
        builder.append("\t<parameters>").append(this.getParameters().toString()).append("</parameters>\n");
        builder.append("</http-request>");
        return builder.toString();
    }
}

