/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.attachment;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.qas.api.AuthClientException;
import org.qas.api.ClientConfiguration;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.services.attachment.AttachmentServiceAsync;
import org.qas.qtest.api.services.attachment.AttachmentServiceClient;
import org.qas.qtest.api.services.attachment.model.Attachment;
import org.qas.qtest.api.services.attachment.model.AttachmentRequest;

public class AttachmentServiceAsyncClient
extends AttachmentServiceClient
implements AttachmentServiceAsync {
    public AttachmentServiceAsyncClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public AttachmentServiceAsyncClient(ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), executorService);
    }

    public AttachmentServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AttachmentServiceAsyncClient(ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, executorService);
    }

    public AttachmentServiceAsyncClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public AttachmentServiceAsyncClient(QTestCredentials credentials, ExecutorService executorService) {
        this(credentials, new ClientConfiguration(), executorService);
    }

    public AttachmentServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        this(credentials, clientConfiguration, Executors.newCachedThreadPool());
    }

    public AttachmentServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new StaticQTestCredentialsProvider(credentials), clientConfiguration, executorService);
    }

    public AttachmentServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public AttachmentServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(credentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    @Override
    public Future<Attachment> attachAsync(AttachmentRequest attachmentRequest) throws AuthClientException {
        return this.executorService.submit(() -> this.attach(attachmentRequest));
    }

    @Override
    public Future<Attachment> attachAsync(AttachmentRequest attachmentRequest, AsyncHandler<AttachmentRequest, Attachment> asyncHandler) throws AuthClientException {
        return this.executorService.submit(() -> {
            Attachment attachment;
            try {
                attachment = this.attach(attachmentRequest);
            }
            catch (Exception ex) {
                asyncHandler.onError(ex);
                throw ex;
            }
            asyncHandler.onSuccess(attachmentRequest, attachment);
            return attachment;
        });
    }
}

