/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.design.model.GetTestStepRequest;

public final class GetTestStepRequestMarshaller
extends AbstractMarshaller<Request, GetTestStepRequest> {
    @Override
    protected void validateRequest(GetTestStepRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to marshall(...)");
        }
        if (in.getProjectId() == null || in.getProjectId() <= 0L) {
            throw new AuthClientException("Invalid project id passed to marshall(...)");
        }
        if (in.getTestCaseId() == null || in.getTestCaseId() <= 0L) {
            throw new AuthClientException("Invalid test case id passed to marshall(...)");
        }
        if (in.getTestCaseVersion() == null || in.getTestCaseVersion() <= 0L) {
            throw new AuthClientException("Invalid test case version passed to marshall(...)");
        }
        if (in.getTestStepId() == null || in.getTestStepId() <= 0L) {
            throw new AuthClientException("Invalid test step id to passed to marshall(...)");
        }
    }

    @Override
    protected String getServiceName() {
        return "TestDesignService";
    }

    @Override
    protected String getActionName() {
        return "GetTestStep";
    }

    @Override
    protected String getContent(GetTestStepRequest in) throws Exception {
        return null;
    }

    @Override
    protected StringBuilder getResourcePath(GetTestStepRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/test-cases/").append(in.getTestCaseId()).append("/versions/").append(in.getTestCaseVersion()).append("/test-steps/").append(in.getTestStepId());
    }
}

