/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.UpdateTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestSuiteRequestMarshaller;

public final class UpdateTestSuiteRequestMarshaller
extends AbstractTestSuiteRequestMarshaller<UpdateTestSuiteRequest> {
    @Override
    public Request marshall(UpdateTestSuiteRequest testSuiteRequest) throws Exception {
        testSuiteRequest = ApiPreconditions.notNull(testSuiteRequest);
        UpdateTestSuiteRequestMarshaller.validateProjectId(testSuiteRequest.getProjectId());
        ApiPreconditions.notNull(testSuiteRequest.getTestSuite(), "Invalid test-suite data passed to marshall(...)");
        Long testSuiteId = testSuiteRequest.getTestSuiteId() != null ? testSuiteRequest.getTestSuiteId() : testSuiteRequest.getTestSuite().getId();
        UpdateTestSuiteRequestMarshaller.validateTestSuiteId(testSuiteId);
        testSuiteRequest.getTestSuite().setId(testSuiteId);
        Request request = this.createJsonRequest(testSuiteRequest, "UpdateTestSuite", HttpMethod.PUT);
        StringBuilder builder = this.createApiPathBuilder(testSuiteRequest.getProjectId());
        builder.append('/').append(testSuiteId);
        request.setResourcePath(builder.toString());
        request.setContent(new StringInputStream(JsonMapper.toJson(testSuiteRequest.getTestSuite())));
        return request;
    }
}

