/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractWebServiceImportHandler {
    private FolderTreeEntity objectRepositoryTreeRoot;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Optional Object[] selectedObjects, @Named(value="activeShell") Shell parentShell) {
        try {
            ITreeEntity parentTreeEntity = this.findParentTreeEntity(selectedObjects);
            if (parentTreeEntity == null) {
                if (this.objectRepositoryTreeRoot == null) {
                    return;
                }
                parentTreeEntity = this.objectRepositoryTreeRoot;
            }
            FolderEntity parentFolderEntity = (FolderEntity)parentTreeEntity.getObject();
            this.doExecute(parentShell, parentFolderEntity);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)ComposerWebserviceMessageConstants.ERROR_MSG_FAIL_TO_IMPORT_SOAPUI);
        }
    }

    protected abstract void doExecute(Shell var1, FolderEntity var2) throws Exception;

    private ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null) {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity) {
                    Object entityObject = ((ITreeEntity)entity).getObject();
                    if (entityObject instanceof FolderEntity) {
                        FolderEntity folder = (FolderEntity)entityObject;
                        if (folder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                            return (ITreeEntity)entity;
                        }
                    } else if (entityObject instanceof WebElementEntity) {
                        return ((ITreeEntity)entity).getParent();
                    }
                }
                ++n2;
            }
        }
        return this.objectRepositoryTreeRoot;
    }

    @Inject
    @Optional
    private void catchTestDataFolderTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            for (Object o : treeEntities) {
                FolderEntity folder;
                Object entityObject = ((ITreeEntity)o).getObject();
                if (!(entityObject instanceof FolderEntity) || (folder = (FolderEntity)entityObject).getFolderType() != FolderEntity.FolderType.WEBELEMENT) continue;
                this.objectRepositoryTreeRoot = (FolderTreeEntity)o;
                return;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

