/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.postman.Auth;
import com.kms.katalon.composer.webservice.postman.FormData;
import com.kms.katalon.composer.webservice.postman.Header;
import com.kms.katalon.composer.webservice.postman.Item;
import com.kms.katalon.composer.webservice.postman.PostmanCollection;
import com.kms.katalon.composer.webservice.postman.Query;
import com.kms.katalon.composer.webservice.postman.Request;
import com.kms.katalon.composer.webservice.postman.Urlencoded;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.entity.webservice.FormDataBodyParameter;
import com.kms.katalon.entity.webservice.ParameterizedBodyContent;
import com.kms.katalon.entity.webservice.TextBodyContent;
import com.kms.katalon.entity.webservice.UrlEncodedBodyParameter;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PostmanParseUtils {
    public static List<WebServiceRequestEntity> parseFromFileLocationToWSTestObject(FolderEntity parentFolder, String fileLocationOrUrl) throws JsonParseException, JsonMappingException, IOException, ControllerException, GeneralSecurityException, FilePathTooLongException, Exception {
        ApiCollectionEntity folderEntity = new ApiCollectionEntity();
        folderEntity.setParentFolder(parentFolder);
        folderEntity.setProject(parentFolder.getProject());
        folderEntity.setFolderType(parentFolder.getFolderType());
        folderEntity.setDescription(StringConstants.IMPORT_FOLDER_DESC_POSTMAN_COLLECTION);
        folderEntity.setCollectionType(ApiCollectionEntity.CollectionType.POSTMAN);
        String availableName = FolderController.getInstance().getAvailableFolderName(parentFolder, StringConstants.IMPORT_FOLDER_NAME_POSTMAN);
        folderEntity.setName(availableName);
        FolderController.getInstance().saveFolder((FolderEntity)folderEntity);
        ArrayList<WebServiceRequestEntity> newWSTestObjects = new ArrayList<WebServiceRequestEntity>();
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        PostmanCollection postman = (PostmanCollection)objectMapper.readValue(new File(fileLocationOrUrl), PostmanCollection.class);
        List<Item> rootItems = postman.getItem();
        ExecutionProfileEntity profileEntity = GlobalVariableController.getInstance().getExecutionProfile("default", ProjectController.getInstance().getCurrentProject());
        List globalVariableEntites = profileEntity.getGlobalVariableEntities();
        ArrayList<VariableEntity> allVariables = new ArrayList<VariableEntity>();
        ArrayList<String> requestItemNames = new ArrayList<String>();
        for (Item root : rootItems) {
            RequestVariable requestVariable = PostmanParseUtils.collectRequestVariablesFromItem((FolderEntity)folderEntity, root, requestItemNames);
            allVariables.addAll(requestVariable.getVariables());
            newWSTestObjects.addAll(requestVariable.getRequests());
        }
        globalVariableEntites.addAll(PostmanParseUtils.toGlobalVariables(allVariables));
        profileEntity.setGlobalVariableEntities(PostmanParseUtils.filterDuplicatedGlobalVariables(globalVariableEntites));
        GlobalVariableController.getInstance().updateExecutionProfile(profileEntity);
        Trackings.trackCreateOrImportApiCollection((String)"imported", (String)folderEntity.getName(), (String)folderEntity.getCollectionType().getDisplayName());
        return newWSTestObjects;
    }

    public static RequestVariable collectRequestVariablesFromItem(FolderEntity parentFolder, Item root, List<String> siblingNames) throws JsonParseException, JsonMappingException, IOException, ControllerException, GeneralSecurityException, FilePathTooLongException, Exception {
        ArrayList<WebServiceRequestEntity> allRequests = new ArrayList<WebServiceRequestEntity>();
        ArrayList<VariableEntity> allVariables = new ArrayList<VariableEntity>();
        if (root.getRequest() != null) {
            WebServiceRequestEntity entity = new WebServiceRequestEntity();
            Request request = root.getRequest();
            String rawURL = request.getURL().getRaw();
            String method = root.getRequest().getMethod();
            String name = root.getName();
            List<VariableEntity> variablesFromURL = PostmanParseUtils.collectVariablesFromRawString(rawURL);
            ArrayList<VariableEntity> variablesFromBody = new ArrayList();
            HttpHeaderVariable httpHeaderVariable = PostmanParseUtils.collectHttpHeaderVariable(request, root);
            PostmanParseUtils.setRequestEntityName(name, entity, siblingNames);
            entity.setRestRequestMethod(method.toString());
            entity.setRestUrl(PostmanParseUtils.getVariableString(variablesFromURL, rawURL));
            entity.setServiceType(WebServiceRequestEntity.SERVICE_TYPES[1]);
            List<WebElementPropertyEntity> httpHeaders = httpHeaderVariable.getHttpHeaders();
            Auth auth = root.getRequest().getAuth();
            List<WebElementPropertyEntity> authRequestHeaders = PostmanParseUtils.getHttpAuthentication(auth);
            httpHeaders.addAll(0, authRequestHeaders);
            if (auth != null) {
                entity.setAuthorizationRequest(auth.toRequestAuthorization());
            }
            entity.setHttpHeaderProperties(httpHeaders);
            if (request.getBody() != null) {
                String body = StringUtils.defaultString((String)request.getBody().getRaw());
                variablesFromBody = PostmanParseUtils.collectVariablesFromRawString(body);
                if (root.getRequest().getBody().getFormdata() != null) {
                    ParameterizedBodyContent<FormDataBodyParameter> formDataBodyParameters = PostmanParseUtils.collectFormDataBody(root);
                    entity.setHttpBodyType("form-data");
                    entity.setHttpBodyContent(JsonUtil.toJson(formDataBodyParameters));
                } else if (root.getRequest().getBody().getUrlencoded() != null) {
                    ParameterizedBodyContent<UrlEncodedBodyParameter> urlEncodedBodyParameters = PostmanParseUtils.collectUrlEncodedBody(root);
                    entity.setHttpBodyType("x-www-form-urlencoded");
                    entity.setHttpBodyContent(JsonUtil.toJson(urlEncodedBodyParameters));
                } else {
                    String textBody = PostmanParseUtils.getVariableString(variablesFromBody, body);
                    TextBodyContent textBodyContent = new TextBodyContent();
                    String contentType = PostmanParseUtils.getContentType(httpHeaders);
                    entity.setHttpBodyType("text");
                    textBodyContent.setContentType(TextContentType.evaluateContentType((String)contentType).getContentType());
                    textBodyContent.setText(textBody);
                    entity.setHttpBodyContent(JsonUtil.toJson((Object)textBodyContent));
                }
            }
            ArrayList<VariableEntity> collectedVariables = new ArrayList<VariableEntity>();
            collectedVariables.addAll(variablesFromURL);
            collectedVariables.addAll(httpHeaderVariable.getVariables());
            collectedVariables.addAll(variablesFromBody);
            List<VariableEntity> entityVariables = PostmanParseUtils.filterDuplicatedVariables(collectedVariables);
            entity.setVariables(entityVariables);
            entity.setParentFolder(parentFolder);
            allRequests.add(entity);
            allVariables.addAll(entityVariables);
        } else {
            ApiCollectionEntity folder = new ApiCollectionEntity();
            folder.setName(root.getName());
            folder.setParentFolder(parentFolder);
            folder.setProject(parentFolder.getProject());
            folder.setFolderType(parentFolder.getFolderType());
            folder.setCollectionType(ApiCollectionEntity.CollectionType.POSTMAN);
            try {
                String availableName = FolderController.getInstance().getAvailableFolderName(parentFolder, root.getName());
                folder.setName(availableName);
                FolderController.getInstance().saveFolder((FolderEntity)folder);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                throw e;
            }
            ArrayList<String> requestItemNames = new ArrayList<String>();
            for (Item item : root.getItem()) {
                RequestVariable childRequestVariable = PostmanParseUtils.collectRequestVariablesFromItem((FolderEntity)folder, item, requestItemNames);
                allRequests.addAll(childRequestVariable.getRequests());
                allVariables.addAll(childRequestVariable.getVariables());
            }
        }
        RequestVariable requestVariable = new RequestVariable();
        requestVariable.setRequests(allRequests);
        requestVariable.setVariables(allVariables);
        return requestVariable;
    }

    private static void setRequestEntityName(String suggestion, WebServiceRequestEntity entity, List<String> availableNames) {
        int index = 0;
        Object entityName = suggestion;
        while (PostmanParseUtils.isNameDuplicated((String)entityName, availableNames)) {
            entityName = suggestion + " (" + ++index + ")";
        }
        entity.setName((String)entityName);
        availableNames.add((String)entityName);
    }

    private static boolean isNameDuplicated(String name, List<String> availableNames) {
        return availableNames.stream().anyMatch(n -> n.equalsIgnoreCase(name));
    }

    public static List<WebElementPropertyEntity> getHttpAuthentication(Auth auth) throws UnsupportedEncodingException, GeneralSecurityException {
        if (auth == null || StringUtils.isEmpty((String)auth.getType())) {
            return Collections.emptyList();
        }
        ArrayList<WebElementPropertyEntity> authenticationHeaders = new ArrayList<WebElementPropertyEntity>();
        authenticationHeaders.addAll(auth.buildAuthorizationHeaders());
        return authenticationHeaders;
    }

    public static List<Item> flatten(Item item) {
        ArrayList<Item> leafItems = new ArrayList<Item>();
        if (item.getRequest() != null) {
            leafItems.add(item);
        }
        if (item.getItem() != null) {
            for (Item child : item.getItem()) {
                leafItems.addAll(PostmanParseUtils.flatten(child));
            }
        }
        return leafItems;
    }

    public static List<GlobalVariableEntity> filterDuplicatedGlobalVariables(List<GlobalVariableEntity> variableEntities) {
        LinkedHashSet<String> currentNames = new LinkedHashSet<String>();
        ArrayList<GlobalVariableEntity> filtedVariables = new ArrayList<GlobalVariableEntity>();
        for (GlobalVariableEntity variable : variableEntities) {
            String variableName = variable.getName();
            if (currentNames.contains(variableName)) continue;
            filtedVariables.add(variable);
            currentNames.add(variable.getName());
        }
        return filtedVariables;
    }

    public static List<GlobalVariableEntity> toGlobalVariables(List<VariableEntity> variableEntities) {
        ArrayList<GlobalVariableEntity> globalVariableEntities = new ArrayList<GlobalVariableEntity>();
        for (VariableEntity varible : variableEntities) {
            GlobalVariableEntity globalVariable = new GlobalVariableEntity(varible.getName(), "''");
            globalVariableEntities.add(globalVariable);
        }
        return globalVariableEntities;
    }

    public static List<VariableEntity> filterDuplicatedVariables(List<VariableEntity> variableEntities) {
        LinkedHashSet<String> currentNames = new LinkedHashSet<String>();
        ArrayList<VariableEntity> filtedVariables = new ArrayList<VariableEntity>();
        for (VariableEntity variable : variableEntities) {
            String variableName = variable.getName();
            if (currentNames.contains(variableName)) continue;
            filtedVariables.add(variable);
            currentNames.add(variable.getName());
        }
        return filtedVariables;
    }

    public static String getContentType(List<WebElementPropertyEntity> headerProperties) {
        for (WebElementPropertyEntity property : headerProperties) {
            if (!"Content-Type".equals(property.getName())) continue;
            return property.getValue();
        }
        return "";
    }

    public static List<VariableEntity> collectVariablesFromRawString(String rawString) {
        ArrayList<VariableEntity> variables = new ArrayList<VariableEntity>();
        Pattern pattern = Pattern.compile("\\{\\{((?!\\{).)*\\}\\}");
        Matcher matcher = pattern.matcher(rawString);
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            VariableEntity variable = new VariableEntity();
            String variableName = rawString.substring(matchResult.start() + 2, matchResult.end() - 2);
            variable.setName(variableName);
            variable.setDefaultValue("GlobalVariable." + variableName);
            variables.add(variable);
        }
        return variables;
    }

    public static String getVariableString(List<VariableEntity> variables, String rawString) {
        String variableString = rawString;
        for (VariableEntity variable : variables) {
            String variableName = variable.getName();
            variableString = variableString.replace("{{" + variableName + "}}", "${" + variable.getName() + "}");
        }
        return variableString;
    }

    public static HttpHeaderVariable collectHttpHeaderVariable(Request request, Item childItem) {
        HttpHeaderVariable httpHeaderVariables = new HttpHeaderVariable();
        List<Header> header = childItem.getRequest().getHeader();
        ArrayList<WebElementPropertyEntity> propertyEntities = new ArrayList<WebElementPropertyEntity>();
        ArrayList<VariableEntity> variables = new ArrayList<VariableEntity>();
        int i = 0;
        while (i < header.size()) {
            WebElementPropertyEntity webElementProperty = new WebElementPropertyEntity();
            String rawKey = header.get(i).getKey();
            String rawValue = header.get(i).getValue();
            List<VariableEntity> variablesFromKey = PostmanParseUtils.collectVariablesFromRawString(rawKey);
            webElementProperty.setName(PostmanParseUtils.getVariableString(variablesFromKey, rawKey));
            List<VariableEntity> variablesFromValue = PostmanParseUtils.collectVariablesFromRawString(rawValue);
            webElementProperty.setValue(PostmanParseUtils.getVariableString(variablesFromValue, rawValue));
            propertyEntities.add(i, webElementProperty);
            variables.addAll(variablesFromKey);
            variables.addAll(variablesFromValue);
            ++i;
        }
        httpHeaderVariables.setHttpHeaders(propertyEntities);
        httpHeaderVariables.setVariables(variables);
        return httpHeaderVariables;
    }

    public static List<WebElementPropertyEntity> collectHttpHeaderItem(Request request, Item childItem) {
        List<Header> header = childItem.getRequest().getHeader();
        ArrayList<WebElementPropertyEntity> propertiesEntity = new ArrayList<WebElementPropertyEntity>();
        int i = 0;
        while (i < header.size()) {
            WebElementPropertyEntity webElementProperty = new WebElementPropertyEntity();
            String key = header.get(i).getKey();
            String value = header.get(i).getValue();
            webElementProperty.setName(key);
            webElementProperty.setValue(value);
            propertiesEntity.add(i, webElementProperty);
            ++i;
        }
        return propertiesEntity;
    }

    public static String collectNameItem(String name, Item item) {
        Object katalonVariableName = "";
        String[] pathAndVariables = ((String)name).toString().split("\\/");
        katalonVariableName = (String)katalonVariableName + pathAndVariables[0];
        if (pathAndVariables.length > 1) {
            int i = 1;
            while (i < pathAndVariables.length) {
                katalonVariableName = (String)katalonVariableName + " or " + pathAndVariables[i];
                ++i;
            }
        }
        name = katalonVariableName;
        return name;
    }

    public static List<VariableEntity> collectVariableItem(Request request) {
        ArrayList<VariableEntity> variable = new ArrayList<VariableEntity>();
        if (request.getURL().getVariable() != null) {
            int i = 0;
            while (i < request.getURL().getVariable().size()) {
                VariableEntity variableEntity = new VariableEntity();
                String keyVar = request.getURL().getVariable().get(i).getKey();
                String id = request.getURL().getVariable().get(i).getId();
                String valueVar = request.getURL().getVariable().get(i).getValue();
                String decription = request.getURL().getVariable().get(i).getDescription();
                variableEntity.setName(keyVar);
                variableEntity.setId(id);
                variableEntity.setDefaultValue(valueVar);
                variableEntity.setDescription(decription);
                variable.add(i, variableEntity);
                ++i;
            }
        }
        return variable;
    }

    public static ParameterizedBodyContent<FormDataBodyParameter> collectFormDataBody(Item item) {
        List<FormData> data = item.getRequest().getBody().getFormdata();
        ParameterizedBodyContent katalonFormParams = new ParameterizedBodyContent();
        if (data != null) {
            int i = 0;
            while (i < data.size()) {
                FormDataBodyParameter katalonFormParam = new FormDataBodyParameter();
                katalonFormParam.setName(data.get(i).getKey());
                katalonFormParam.setValue(data.get(i).getValue());
                katalonFormParam.setType(data.get(i).getType());
                katalonFormParams.addParameter((Object)katalonFormParam);
                ++i;
            }
        }
        return katalonFormParams;
    }

    public static ParameterizedBodyContent<UrlEncodedBodyParameter> collectUrlEncodedBody(Item item) {
        List<Urlencoded> urlEncoded = item.getRequest().getBody().getUrlencoded();
        ParameterizedBodyContent urlEncodedBodyParams = new ParameterizedBodyContent();
        if (urlEncoded != null) {
            int i = 0;
            while (i < urlEncoded.size()) {
                UrlEncodedBodyParameter urlEncodedBodyParam = new UrlEncodedBodyParameter();
                urlEncodedBodyParam.setName(urlEncoded.get(i).getKey());
                urlEncodedBodyParam.setValue(urlEncoded.get(i).getValue());
                urlEncodedBodyParams.addParameter((Object)urlEncodedBodyParam);
                ++i;
            }
        }
        return urlEncodedBodyParams;
    }

    public static List<WebElementPropertyEntity> collectQueryParameter(Item childItem) {
        List<Query> query = childItem.getRequest().getURL().getQuery();
        ArrayList<WebElementPropertyEntity> propertiesEntity = new ArrayList<WebElementPropertyEntity>();
        int i = 0;
        while (i < query.size()) {
            WebElementPropertyEntity webElementProperty = new WebElementPropertyEntity();
            String key = query.get(i).getKey();
            String value = query.get(i).getValue();
            webElementProperty.setName(key);
            webElementProperty.setValue(value);
            propertiesEntity.add(i, webElementProperty);
            ++i;
        }
        return propertiesEntity;
    }

    public static List<WebServiceRequestEntity> newWSTestObjectsFromPostman(FolderEntity parentFolder, String directoryOfJsonFile) throws Exception {
        if (parentFolder == null) {
            return null;
        }
        List<WebServiceRequestEntity> newWSTestObjects = PostmanParseUtils.parseFromFileLocationToWSTestObject(parentFolder, directoryOfJsonFile);
        for (WebServiceRequestEntity entity : newWSTestObjects) {
            entity.setElementGuidId(Util.generateGuid());
            entity.setProject(parentFolder.getProject());
        }
        return newWSTestObjects;
    }

    public static class HttpHeaderVariable {
        private List<WebElementPropertyEntity> httpHeaders;
        private List<VariableEntity> variables;

        public List<WebElementPropertyEntity> getHttpHeaders() {
            return this.httpHeaders;
        }

        public void setHttpHeaders(List<WebElementPropertyEntity> httpHeaders) {
            this.httpHeaders = httpHeaders;
        }

        public List<VariableEntity> getVariables() {
            return this.variables;
        }

        public void setVariables(List<VariableEntity> variables) {
            this.variables = variables;
        }
    }

    public static class RequestVariable {
        private List<WebServiceRequestEntity> requests;
        private List<VariableEntity> variables;

        public List<VariableEntity> getVariables() {
            return this.variables;
        }

        public void setVariables(List<VariableEntity> variables) {
            this.variables = variables;
        }

        public List<WebServiceRequestEntity> getRequests() {
            return this.requests;
        }

        public void setRequests(List<WebServiceRequestEntity> requests) {
            this.requests = requests;
        }
    }
}

