/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.postman;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kms.katalon.composer.webservice.postman.Auth;
import com.kms.katalon.composer.webservice.postman.AuthParameter;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.OAuth1Authorization;
import com.kms.katalon.core.testobject.authorization.OAuth1SignatureMethod;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OAuth1Auth
extends Auth {
    private static final String CONSUMER_KEY = "consumerKey";
    private static final String CONSUMER_SECRET = "consumerSecret";
    private static final String SIGNATURE_METHOD = "signatureMethod";
    private static final String TOKEN = "token";
    private static final String TOKEN_SECRET = "tokenSecret";
    private static final String REALM = "realm";
    @JsonProperty(value="oauth1")
    List<AuthParameter> oauth1 = new ArrayList<AuthParameter>();

    public List<AuthParameter> getOauth1() {
        return this.oauth1;
    }

    public void setOauth1(List<AuthParameter> oauth1) {
        this.oauth1 = oauth1;
    }

    public OAuth1Auth() {
        super("oauth1");
    }

    @Override
    public List<WebElementPropertyEntity> buildAuthorizationHeaders() {
        List<AuthParameter> oauth1Items = this.getOauth1();
        if (oauth1Items == null || oauth1Items.isEmpty()) {
            this.logger.debug("No OAuth1 parameters found");
            throw new UnsupportedOperationException("No OAuth1 parameters found");
        }
        Map<String, String> authorizationInfo = ((List)Optional.ofNullable(oauth1Items).orElse(new ArrayList())).stream().filter(item -> item.getKey() != null && item.getValue() != null).collect(Collectors.toMap(AuthParameter::getKey, AuthParameter::getValueAsString, (existing, replacement) -> replacement));
        String consumerKey = authorizationInfo.getOrDefault(CONSUMER_KEY, "");
        String consumerSecret = authorizationInfo.getOrDefault(CONSUMER_SECRET, "");
        OAuth1SignatureMethod signatureMethod = this.fromPostmanValue(authorizationInfo.getOrDefault(SIGNATURE_METHOD, ""));
        String token = authorizationInfo.getOrDefault(TOKEN, "");
        String tokenSecret = authorizationInfo.getOrDefault(TOKEN_SECRET, "");
        String realm = authorizationInfo.getOrDefault(REALM, "");
        ArrayList<WebElementPropertyEntity> oauth1Headers = new ArrayList<WebElementPropertyEntity>();
        oauth1Headers.add(new WebElementPropertyEntity("Authorization:oauth_consumer_key", consumerKey));
        oauth1Headers.add(new WebElementPropertyEntity("Authorization:oauth_consumer_secret", consumerSecret));
        oauth1Headers.add(new WebElementPropertyEntity("Authorization:oauth_signature_method", signatureMethod.name()));
        oauth1Headers.add(new WebElementPropertyEntity("Authorization:oauth_token", token));
        oauth1Headers.add(new WebElementPropertyEntity("Authorization:oauth_token_secret", tokenSecret));
        oauth1Headers.add(new WebElementPropertyEntity("Authorization:realm", realm));
        return oauth1Headers;
    }

    @Override
    public BasicRequestAuthorization toRequestAuthorization() {
        List<AuthParameter> oauth1Items = this.getOauth1();
        if (oauth1Items == null || oauth1Items.isEmpty()) {
            this.logger.debug("No OAuth1 parameters found");
            throw new UnsupportedOperationException("No OAuth1 parameters found");
        }
        Map<String, String> authorizationInfo = ((List)Optional.ofNullable(oauth1Items).orElse(new ArrayList())).stream().filter(item -> item.getKey() != null && item.getValue() != null).collect(Collectors.toMap(AuthParameter::getKey, AuthParameter::getValueAsString, (existing, replacement) -> replacement));
        try {
            String consumerKey = authorizationInfo.getOrDefault(CONSUMER_KEY, "");
            String consumerSecret = authorizationInfo.getOrDefault(CONSUMER_SECRET, "");
            OAuth1SignatureMethod signatureMethod = this.fromPostmanValue(authorizationInfo.getOrDefault(SIGNATURE_METHOD, ""));
            String token = authorizationInfo.getOrDefault(TOKEN, "");
            String tokenSecret = authorizationInfo.getOrDefault(TOKEN_SECRET, "");
            String realm = authorizationInfo.getOrDefault(REALM, "");
            return new OAuth1Authorization(consumerKey, consumerSecret, signatureMethod, token, tokenSecret, realm);
        }
        catch (Exception e) {
            this.logger.error("Error creating OAuth1 Authorization", (Throwable)e);
            throw new UnsupportedOperationException("Error creating OAuth1 Authorization", e);
        }
    }

    private OAuth1SignatureMethod fromPostmanValue(String signatureMethod) {
        try {
            return OAuth1SignatureMethod.fromDisplayName((String)signatureMethod);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.error("Unknown OAuth1 signature method: {}", (Object)signatureMethod);
            return OAuth1SignatureMethod.HMAC_SHA1;
        }
    }
}

