/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.postman;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kms.katalon.composer.webservice.postman.Auth;
import com.kms.katalon.composer.webservice.postman.AuthParameter;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.OAuth2Authorization;
import com.kms.katalon.core.testobject.authorization.OAuth2GrantType;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OAuth2Auth
extends Auth {
    private static final String GRANT_TYPE = "grant_type";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    private static final String ACCESS_TOKEN_URL = "accessTokenUrl";
    private static final String AUTH_URL = "authUrl";
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String SCOPE = "scope";
    private static final String STATE = "state";
    private static final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    private static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private static final String GRANT_TYPE_PASSWORD_CREDENTIALS = "password_credentials";
    private static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    @JsonProperty(value="oauth2")
    private List<AuthParameter> oauth2 = new ArrayList<AuthParameter>();

    public OAuth2Auth() {
        super("oauth2");
    }

    public List<AuthParameter> getOauth2() {
        return this.oauth2;
    }

    public void setOauth2(List<AuthParameter> oauth2) {
        this.oauth2 = oauth2;
    }

    @Override
    public List<WebElementPropertyEntity> buildAuthorizationHeaders() {
        List<AuthParameter> oauth2Items = this.getOauth2();
        if (oauth2Items == null || oauth2Items.isEmpty()) {
            this.logger.debug("No OAuth2 parameters found");
            throw new UnsupportedOperationException("No OAuth2 parameters found");
        }
        Map<String, String> authorizationInfo = ((List)Optional.ofNullable(oauth2Items).orElse(new ArrayList())).stream().filter(item -> item.getKey() != null && item.getValue() != null).collect(Collectors.toMap(AuthParameter::getKey, AuthParameter::getValueAsString, (existing, replacement) -> replacement));
        String grantTypeText = authorizationInfo.getOrDefault(GRANT_TYPE, "");
        OAuth2GrantType grantType = this.fromPostmanValue(grantTypeText);
        String clientId = authorizationInfo.getOrDefault(CLIENT_ID, "");
        String clientSecret = authorizationInfo.getOrDefault(CLIENT_SECRET, "");
        String accessTokenUrl = authorizationInfo.getOrDefault(ACCESS_TOKEN_URL, "");
        String authUrl = authorizationInfo.getOrDefault(AUTH_URL, "");
        String redirectUri = authorizationInfo.getOrDefault(REDIRECT_URI, "");
        String scope = authorizationInfo.getOrDefault(SCOPE, "");
        String state = authorizationInfo.getOrDefault(STATE, "");
        String username = authorizationInfo.getOrDefault(USERNAME, "");
        String password = authorizationInfo.getOrDefault(PASSWORD, "");
        ArrayList<WebElementPropertyEntity> oauth2Headers = new ArrayList<WebElementPropertyEntity>();
        oauth2Headers.add(new WebElementPropertyEntity("Authorization:type", "OAuth 2.0"));
        oauth2Headers.add(new WebElementPropertyEntity("Authorization:grant_type", grantType.name()));
        oauth2Headers.add(new WebElementPropertyEntity("Authorization:access_token_url", accessTokenUrl));
        oauth2Headers.add(new WebElementPropertyEntity("Authorization:state", state));
        oauth2Headers.add(new WebElementPropertyEntity("Authorization:scope", scope));
        oauth2Headers.add(new WebElementPropertyEntity("Authorization:oauth_consumer_key", clientId));
        oauth2Headers.add(new WebElementPropertyEntity("Authorization:oauth_consumer_secret", clientSecret));
        switch (grantType) {
            case PASSWORD_CREDENTIALS: {
                oauth2Headers.add(new WebElementPropertyEntity("Authorization:user_name", username));
                oauth2Headers.add(new WebElementPropertyEntity("Authorization:password", password));
                break;
            }
            case AUTHORIZATION_CODE: {
                oauth2Headers.add(new WebElementPropertyEntity("Authorization:callback_url", redirectUri));
                oauth2Headers.add(new WebElementPropertyEntity("Authorization:auth_url", authUrl));
                break;
            }
        }
        return oauth2Headers;
    }

    @Override
    public BasicRequestAuthorization toRequestAuthorization() throws UnsupportedEncodingException, GeneralSecurityException {
        List<AuthParameter> oauth2Items = this.getOauth2();
        if (oauth2Items == null || oauth2Items.isEmpty()) {
            this.logger.debug("No OAuth2 parameters found");
            throw new UnsupportedOperationException("No OAuth2 parameters found");
        }
        Map<String, String> authorizationInfo = ((List)Optional.ofNullable(oauth2Items).orElse(new ArrayList())).stream().filter(item -> item.getKey() != null && item.getValue() != null).collect(Collectors.toMap(AuthParameter::getKey, AuthParameter::getValueAsString, (existing, replacement) -> replacement));
        String postmanGrantType = authorizationInfo.getOrDefault(GRANT_TYPE, "");
        OAuth2GrantType grantType = this.fromPostmanValue(postmanGrantType);
        String clientId = authorizationInfo.getOrDefault(CLIENT_ID, "");
        String clientSecret = authorizationInfo.getOrDefault(CLIENT_SECRET, "");
        String accessTokenUrl = authorizationInfo.getOrDefault(ACCESS_TOKEN_URL, "");
        String authUrl = authorizationInfo.getOrDefault(AUTH_URL, "");
        String redirectUri = authorizationInfo.getOrDefault(REDIRECT_URI, "");
        String scope = authorizationInfo.getOrDefault(SCOPE, "");
        String state = authorizationInfo.getOrDefault(STATE, "");
        String username = authorizationInfo.getOrDefault(USERNAME, "");
        String password = authorizationInfo.getOrDefault(PASSWORD, "");
        String accessToken = "";
        String refreshToken = "";
        String tokenType = "";
        String authorizationCode = "";
        try {
            return new OAuth2Authorization(grantType, username, password, redirectUri, authUrl, accessTokenUrl, state, clientId, clientSecret, authorizationCode, scope, accessToken, refreshToken, tokenType);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Invalid OAuth2 Authorization parameters", (Throwable)e);
            throw new UnsupportedOperationException("Invalid OAuth2 Authorization parameters", e);
        }
        catch (Exception e) {
            this.logger.error("Error creating OAuth2 Authorization", (Throwable)e);
            throw new UnsupportedOperationException("Error creating OAuth2 Authorization", e);
        }
    }

    private OAuth2GrantType fromPostmanValue(String postmanValue) {
        switch (postmanValue.toLowerCase()) {
            case "authorization_code": {
                return OAuth2GrantType.AUTHORIZATION_CODE;
            }
            case "client_credentials": {
                return OAuth2GrantType.CLIENT_CREDENTIALS;
            }
            case "password_credentials": {
                return OAuth2GrantType.PASSWORD_CREDENTIALS;
            }
            case "refresh_token": {
                return OAuth2GrantType.REFRESH_TOKEN;
            }
        }
        this.logger.error("Unknown OAuth2 grant type: {}", (Object)postmanValue);
        return OAuth2GrantType.AUTHORIZATION_CODE;
    }
}

