/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.postman;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "key", "value", "type", "name", "description", "system", "disabled"})
public class Variable
implements Serializable {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="A variable ID is a unique user-defined value that identifies the variable within a collection. In traditional terms, this would be a variable name.")
    private String id;
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="A variable key is a human friendly value that identifies the variable within a collection. In traditional terms, this would be a variable name.")
    private String key;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="The value that a variable holds in this collection. Ultimately, the variables will be replaced by this value, when say running a set of requests from a collection")
    private String value;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="A variable may have multiple types. This field specifies the type of the variable.")
    private Type type;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Variable name")
    private String name;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="A Description can be a raw text, or be an object, which holds the description along with its format.")
    private String description;
    @JsonProperty(value="system")
    @JsonPropertyDescription(value="When set to true, indicates that this variable has been set by Postman")
    private boolean system = false;
    @JsonProperty(value="disabled")
    private boolean disabled = false;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private static final long serialVersionUID = -6958213284199326401L;

    public Variable() {
    }

    public Variable(String id, String key, String value, Type type, String name, String description, boolean system, boolean disabled) {
        this.id = id;
        this.key = key;
        this.value = value;
        this.type = type;
        this.name = name;
        this.description = description;
        this.system = system;
        this.disabled = disabled;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="system")
    public boolean isSystem() {
        return this.system;
    }

    @JsonProperty(value="system")
    public void setSystem(boolean system) {
        this.system = system;
    }

    @JsonProperty(value="disabled")
    public boolean isDisabled() {
        return this.disabled;
    }

    @JsonProperty(value="disabled")
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, String value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("key", (Object)this.key).append("value", (Object)this.value).append("type", (Object)this.type).append("name", (Object)this.name).append("description", (Object)this.description).append("system", this.system).append("disabled", this.disabled).append("additionalProperties", this.additionalProperties).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append(this.system).append(this.additionalProperties).append((Object)this.description).append((Object)this.name).append((Object)this.value).append((Object)this.type).append(this.disabled).append((Object)this.key).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Variable)) {
            return false;
        }
        Variable rhs = (Variable)other;
        return new EqualsBuilder().append((Object)this.id, (Object)rhs.id).append(this.system, rhs.system).append(this.additionalProperties, rhs.additionalProperties).append((Object)this.description, (Object)rhs.description).append((Object)this.name, (Object)rhs.name).append((Object)this.value, (Object)rhs.value).append((Object)this.type, (Object)rhs.type).append(this.disabled, rhs.disabled).append((Object)this.key, (Object)rhs.key).isEquals();
    }

    public static enum Type {
        STRING("string"),
        BOOLEAN("boolean"),
        ANY("any"),
        NUMBER("number"),
        DEFAULT("default");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        static {
            CONSTANTS = new HashMap<String, Type>();
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type c = typeArray[n2];
                CONSTANTS.put(c.value, c);
                ++n2;
            }
        }

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }
    }
}

