/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.response.header;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.response.header.HeaderPrettyEditor;
import com.kms.katalon.composer.webservice.response.header.HeaderRawEditor;
import com.kms.katalon.composer.webservice.response.header.ResponseHeaderEditor;
import com.kms.katalon.core.testobject.ResponseObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;

public class ResponseHeaderEditorsComposite
extends Composite {
    protected final String WS_BUNDLE_NAME = FrameworkUtil.getBundle(ResponseHeaderEditorsComposite.class).getSymbolicName();
    private Map<EditorMode, ResponseHeaderEditor> headerEditors = new HashMap<EditorMode, ResponseHeaderEditor>();
    private Map<EditorMode, Button> headerSelectionButtons = new HashMap<EditorMode, Button>();
    private StackLayout slHeaderContent;
    private ResponseObject responseObject;
    private EditorMode selectedEditorMode = EditorMode.PRETTY;

    public ResponseHeaderEditorsComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Composite headerTypeComposite = new Composite((Composite)this, 0);
        headerTypeComposite.setLayoutData((Object)new GridData(768));
        GridLayout glHeaderType = new GridLayout(2, false);
        glHeaderType.marginHeight = 0;
        glHeaderType.marginWidth = 0;
        headerTypeComposite.setLayout((Layout)glHeaderType);
        Composite headerContentComposite = new Composite((Composite)this, 0);
        headerContentComposite.setLayoutData((Object)new GridData(1808));
        this.slHeaderContent = new StackLayout();
        headerContentComposite.setLayout((Layout)this.slHeaderContent);
        Button prettyRadio = new Button(headerTypeComposite, 16);
        prettyRadio.setText("pretty");
        prettyRadio.setSelection(true);
        this.headerSelectionButtons.put(EditorMode.PRETTY, prettyRadio);
        Button rawRadio = new Button(headerTypeComposite, 16);
        rawRadio.setText("raw");
        this.headerSelectionButtons.put(EditorMode.RAW, rawRadio);
        HeaderPrettyEditor prettyEditor = new HeaderPrettyEditor(headerContentComposite, 0);
        this.headerEditors.put(EditorMode.PRETTY, prettyEditor);
        HeaderRawEditor rawEditor = new HeaderRawEditor(headerContentComposite, 0);
        this.headerEditors.put(EditorMode.RAW, rawEditor);
        this.slHeaderContent.topControl = prettyEditor;
        headerContentComposite.layout();
        this.setupEventListeners();
    }

    private void setupEventListeners() {
        SelectionAdapter headerTypeSelectedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    try {
                        ResponseHeaderEditorsComposite.this.selectedEditorMode = EditorMode.valueOf(source.getText().toUpperCase());
                        ResponseHeaderEditor editorComposite = ResponseHeaderEditorsComposite.this.headerEditors.get((Object)ResponseHeaderEditorsComposite.this.selectedEditorMode);
                        editorComposite.switchModeHeaderContent(ResponseHeaderEditorsComposite.this.responseObject);
                        ResponseHeaderEditorsComposite.this.slHeaderContent.topControl = (Composite)editorComposite;
                        ((Composite)editorComposite).getParent().layout();
                    }
                    catch (Exception ex) {
                        LoggerSingleton.logError((Throwable)ex);
                        ErrorDialog.openError((Shell)ResponseHeaderEditorsComposite.this.getShell(), (String)StringConstants.ERROR_TITLE, (String)"There was a problem while parsing the response headers.", (IStatus)new Status(4, ResponseHeaderEditorsComposite.this.WS_BUNDLE_NAME, ex.getMessage(), (Throwable)ex));
                    }
                }
            }
        };
        this.headerSelectionButtons.values().forEach(button -> button.addSelectionListener((SelectionListener)headerTypeSelectedListener));
    }

    public void setInput(ResponseObject responseObj) {
        try {
            this.responseObject = responseObj;
            for (ResponseHeaderEditor editor : this.headerEditors.values()) {
                editor.setHeaderContent(responseObj);
            }
            ResponseHeaderEditor activeEditor = this.headerEditors.get((Object)this.selectedEditorMode);
            this.slHeaderContent.topControl = (Composite)activeEditor;
            ((Composite)activeEditor).getParent().layout();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)"There was a problem while parsing the response headers.", (IStatus)new Status(4, this.WS_BUNDLE_NAME, e.getMessage(), (Throwable)e));
        }
    }

    public ResponseObject getResponseObject() {
        return this.responseObject;
    }

    private static enum EditorMode {
        PRETTY,
        RAW;

    }
}

