/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.support;

import com.kms.katalon.composer.components.adapter.CComboContentAdapter;
import com.kms.katalon.composer.components.impl.editors.StringComboBoxCellEditor;
import com.kms.katalon.composer.webservice.constants.HttpHeaderConstants;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PropertyNameEditingSupport
extends EditingSupport {
    private TableViewer viewer;
    private MDirtyable dirtyable;
    private boolean isHeaderField = false;

    public PropertyNameEditingSupport(TableViewer viewer, MDirtyable dirtyable) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.dirtyable = dirtyable;
    }

    public PropertyNameEditingSupport(TableViewer viewer, MDirtyable dirtyable, boolean isHeaderField) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.dirtyable = dirtyable;
        this.isHeaderField = isHeaderField;
    }

    protected CellEditor getCellEditor(Object element) {
        if (this.isHeaderField) {
            return new HttpHeaderNameCellEditor(element, HttpHeaderConstants.PRE_DEFINDED_HTTP_HEADER_FIELD_NAMES);
        }
        return new TextCellEditor((Composite)this.viewer.getTable());
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element != null && element instanceof WebElementPropertyEntity) {
            WebElementPropertyEntity property = (WebElementPropertyEntity)element;
            return property.getName();
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        WebElementPropertyEntity property;
        if (element != null && element instanceof WebElementPropertyEntity && value != null && value instanceof String && !value.equals((property = (WebElementPropertyEntity)element).getName())) {
            property.setName((String)value);
            if (this.dirtyable != null) {
                this.dirtyable.setDirty(true);
            }
            this.viewer.update(element, null);
        }
    }

    private class HttpHeaderNameCellEditor
    extends StringComboBoxCellEditor {
        private Object element;

        public HttpHeaderNameCellEditor(final Object element, String[] items) {
            super((Composite)PropertyNameEditingSupport.this.viewer.getTable(), items);
            this.element = element;
            final CCombo combo = (CCombo)this.getControl();
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String text = combo.getText();
                    PropertyNameEditingSupport.this.setValue(element, text);
                }
            });
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String text = combo.getText();
                    PropertyNameEditingSupport.this.setValue(element, text);
                }
            });
        }

        public AutoCompleteField getAutoCompleteField(String[] newItems) {
            return new AutoCompleteField(this.getControl(), (IControlContentAdapter)new HeaderNameComboContentAdapter(), newItems);
        }

        private class HeaderNameComboContentAdapter
        extends CComboContentAdapter {
            private HeaderNameComboContentAdapter() {
            }

            public void setControlContents(Control control, String text, int cursorPosition) {
                super.setControlContents(control, text, cursorPosition);
                PropertyNameEditingSupport.this.setValue(HttpHeaderNameCellEditor.this.element, text);
            }
        }
    }
}

