/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.support;

import com.kms.katalon.composer.components.adapter.CComboContentAdapter;
import com.kms.katalon.composer.components.impl.editors.StringComboBoxCellEditor;
import com.kms.katalon.composer.webservice.constants.HttpHeaderConstants;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PropertyValueEditingSupport
extends EditingSupport {
    private TableViewer viewer;
    private MDirtyable dirtyable;
    private boolean isHeaderField = false;

    public PropertyValueEditingSupport(TableViewer viewer, MDirtyable dirtyable) {
        this(viewer, dirtyable, false);
    }

    public PropertyValueEditingSupport(TableViewer viewer, MDirtyable dirtyable, boolean isHeaderField) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.dirtyable = dirtyable;
        this.isHeaderField = isHeaderField;
    }

    protected CellEditor getCellEditor(Object element) {
        if (this.isHeaderField) {
            return new HttpHeaderValueCellEditor(element, HttpHeaderConstants.PRE_DEFINDED_HTTP_HEADER_FIELD_VALUES);
        }
        return new TextCellEditor((Composite)this.viewer.getTable());
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element != null && element instanceof WebElementPropertyEntity) {
            WebElementPropertyEntity property = (WebElementPropertyEntity)element;
            return property.getValue();
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        WebElementPropertyEntity property;
        if (element != null && element instanceof WebElementPropertyEntity && value != null && value instanceof String && !value.equals((property = (WebElementPropertyEntity)element).getValue())) {
            property.setValue((String)value);
            this.viewer.update(element, null);
            this.dirtyable.setDirty(true);
        }
    }

    private class HttpHeaderValueCellEditor
    extends StringComboBoxCellEditor {
        private Object element;

        public HttpHeaderValueCellEditor(final Object element, String[] items) {
            super((Composite)PropertyValueEditingSupport.this.viewer.getTable(), items);
            this.element = element;
            final CCombo combo = (CCombo)this.getControl();
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String text = combo.getText();
                    PropertyValueEditingSupport.this.setValue(element, text);
                }
            });
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String text = combo.getText();
                    PropertyValueEditingSupport.this.setValue(element, text);
                }
            });
        }

        public AutoCompleteField getAutoCompleteField(String[] newItems) {
            return new AutoCompleteField(this.getControl(), (IControlContentAdapter)new HeaderValueComboContentAdapter(), newItems);
        }

        private class HeaderValueComboContentAdapter
        extends CComboContentAdapter {
            private HeaderValueComboContentAdapter() {
            }

            public void setControlContents(Control control, String text, int cursorPosition) {
                super.setControlContents(control, text, cursorPosition);
                PropertyValueEditingSupport.this.setValue(HttpHeaderValueCellEditor.this.element, text);
            }
        }
    }
}

