/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class XPathUtils {
    public static String getXmlPropertyForSoapBody(String xpath) {
        return StringUtils.replaceFirst((String)xpath, (String)"Body.", (String)"");
    }

    public static Map<Integer, String> evaluateXmlProperty(String jsonString) throws IOException {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return Collections.emptyMap();
        }
        ObjectMapper mapper = new XmlMapper().configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).registerModule((Module)new SimpleModule().addDeserializer(Object.class, (JsonDeserializer)new FixedUntypedObjectDeserializer(null, null)));
        Object o = mapper.readValue(jsonString, Object.class);
        ObjectWriter w = new ObjectMapper().writerWithDefaultPrettyPrinter();
        JsonNode rootNode = new ObjectMapper().readTree(w.writeValueAsString(o));
        IndexedJsonNode indexedNode = new IndexedJsonNode();
        indexedNode.key = "";
        indexedNode.index = 0;
        indexedNode.xmlProperty = "";
        if (jsonString.startsWith("<?xml")) {
            indexedNode.startLine = 1;
            indexedNode.endLine = 1;
        } else {
            indexedNode.startLine = 0;
            indexedNode.endLine = 0;
        }
        IndexedJsonNode evaluatedRootNode = XPathUtils.walk(null, null, indexedNode, rootNode);
        return XPathUtils.collectXmlProperty(evaluatedRootNode);
    }

    private static Map<Integer, String> collectXmlProperty(IndexedJsonNode node) {
        HashMap<Integer, String> jsonPathCollection = new HashMap<Integer, String>();
        jsonPathCollection.put(node.startLine, node.xmlProperty);
        for (IndexedJsonNode childNode : node.children) {
            jsonPathCollection.putAll(XPathUtils.collectXmlProperty(childNode));
        }
        return jsonPathCollection;
    }

    private static IndexedJsonNode walk(IndexedJsonNode parentIndexedNode, JsonNode parentNode, IndexedJsonNode indexedNode, JsonNode node) {
        if (parentIndexedNode != null) {
            indexedNode.endLine = parentNode.getNodeType() != JsonNodeType.ARRAY ? (indexedNode.startLine = parentIndexedNode.endLine + 1) : (indexedNode.startLine = parentIndexedNode.endLine);
        }
        switch (node.getNodeType()) {
            case ARRAY: {
                Iterator childrenIterator = node.iterator();
                int index = 0;
                while (childrenIterator.hasNext()) {
                    JsonNode childNode = (JsonNode)childrenIterator.next();
                    IndexedJsonNode indexedChild = new IndexedJsonNode();
                    indexedChild.index = index;
                    indexedChild.xmlProperty = indexedNode.xmlProperty + "[" + index + "]";
                    indexedChild.key = "";
                    XPathUtils.walk(indexedNode, node, indexedChild, childNode);
                    indexedNode.endLine = indexedChild.endLine;
                    indexedNode.children.add(indexedChild);
                    ++index;
                }
                break;
            }
            case OBJECT: {
                if (!XPathUtils.hasAttribute(indexedNode, node)) {
                    Iterator childrenIterator = node.fields();
                    int index = 0;
                    while (childrenIterator.hasNext()) {
                        Map.Entry childEntry = (Map.Entry)childrenIterator.next();
                        JsonNode childNode = (JsonNode)childEntry.getValue();
                        IndexedJsonNode indexedChild = new IndexedJsonNode();
                        indexedChild.index = index;
                        indexedChild.xmlProperty = (String)(indexedNode.xmlProperty.isEmpty() ? "" : indexedNode.xmlProperty + ".") + (String)childEntry.getKey();
                        indexedChild.key = (String)childEntry.getKey();
                        XPathUtils.walk(indexedNode, node, indexedChild, childNode);
                        indexedNode.endLine = indexedChild.endLine;
                        indexedNode.children.add(indexedChild);
                        ++index;
                    }
                }
                ++indexedNode.endLine;
                break;
            }
            default: {
                ++indexedNode.endLine;
            }
        }
        return indexedNode;
    }

    private static boolean hasAttribute(IndexedJsonNode indexedNode, JsonNode node) {
        Iterator fieldNamesIterator = node.fieldNames();
        while (fieldNamesIterator.hasNext()) {
            if (!((String)fieldNamesIterator.next()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static class FixedUntypedObjectDeserializer
    extends UntypedObjectDeserializer {
        private static final long serialVersionUID = -5994468781168540578L;

        public FixedUntypedObjectDeserializer(JavaType listType, JavaType mapType) {
            super(listType, mapType);
        }

        protected Object mapObject(JsonParser p, DeserializationContext ctxt) throws IOException {
            String nextKey;
            String firstKey;
            JsonToken t = p.getCurrentToken();
            if (t == JsonToken.START_OBJECT) {
                firstKey = p.nextFieldName();
            } else if (t == JsonToken.FIELD_NAME) {
                firstKey = p.getCurrentName();
            } else {
                if (t != JsonToken.END_OBJECT) {
                    return ctxt.handleUnexpectedToken(this.handledType(), p);
                }
                firstKey = null;
            }
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(2);
            if (firstKey == null) {
                return resultMap;
            }
            p.nextToken();
            resultMap.put(firstKey, this.deserialize(p, ctxt));
            LinkedHashSet<String> listKeys = new LinkedHashSet<String>();
            while ((nextKey = p.nextFieldName()) != null) {
                p.nextToken();
                if (resultMap.containsKey(nextKey)) {
                    Object listObject = resultMap.get(nextKey);
                    if (!(listObject instanceof List)) {
                        listObject = new ArrayList();
                        ((List)listObject).add(resultMap.get(nextKey));
                        resultMap.put(nextKey, listObject);
                    }
                    ((List)listObject).add(this.deserialize(p, ctxt));
                    listKeys.add(nextKey);
                    continue;
                }
                resultMap.put(nextKey, this.deserialize(p, ctxt));
            }
            return resultMap;
        }
    }

    private static class IndexedJsonNode {
        private String key;
        private int index;
        private String xmlProperty;
        private int startLine;
        private int endLine;
        private List<IndexedJsonNode> children = new ArrayList<IndexedJsonNode>();

        private IndexedJsonNode() {
        }

        public String toString() {
            return "IndexedJsonNode [key=" + this.key + ", index=" + this.index + ", xmlProperty=" + this.xmlProperty + ", startLine=" + this.startLine + ", endLine=" + this.endLine + ", children=" + String.valueOf(this.children) + "]\n";
        }
    }
}

