/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.parser.OpenApiSpecParser;
import com.kms.katalon.composer.webservice.parts.ApiCollectionGenerateTestPart;
import com.kms.katalon.composer.webservice.report.ApiAiTestReportGenerator;
import com.kms.katalon.composer.webservice.viewmodel.AiTestingPreferences;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCollectionGenerateTestUI {
    private static final Logger logger = LoggerFactory.getLogger(ApiCollectionGenerateTestUI.class);
    private static final String TAB_TITLE_TEST_GENERATION = "Generate Test";
    private static final int OVERVIEW_CARD_WIDTH = 160;
    private static final int OVERVIEW_CARD_HEIGHT = 100;
    private static final int CONFIG_CARD_HEIGHT = 100;
    private static final int CATEGORY_CARD_WIDTH = 140;
    private static final int CATEGORY_CARD_HEIGHT = 150;
    private static final int TEXT_HEIGHT = 25;
    private static final int BUTTON_WIDTH = 180;
    private static final int BUTTON_HEIGHT = 35;
    private static final String COLOR_BLUE = "#2196F3";
    private static final String COLOR_GREEN = "#4CAF50";
    private static final String COLOR_ORANGE = "#FF9800";
    private static final String COLOR_RED = "#F44336";
    private static final String COLOR_WHITE = "#FFFFFF";
    private static final String DATA_KEY_LABELS = "labels";
    private static final String DATA_KEY_PERCENTAGE = "percentage";
    private static final String LABEL_SERVER_CONFIGURATION = "Server Configuration";
    private static final String LABEL_SERVER_URL = "Server URL";
    private static final String LABEL_OPEN_API_SPEC_FILE_PATH = "Open API Spec File path";
    private static final String LABEL_TEST_CONFIGURATION = "Test Configuration";
    private static final String LABEL_TEST_TYPE = "Test Type";
    private static final String LABEL_API_PATH = "API Path";
    private static final String LABEL_HTTP_METHOD = "HTTP Method";
    private static final String LABEL_GENERATE_TEST = "Generate Test";
    private static final String LABEL_CONSOLIDATED_TEST_RESULT = "Consolidated test result";
    private static final String LABEL_TOTAL_TESTS = "TOTAL TESTS";
    private static final String LABEL_PASSED = "PASSED";
    private static final String LABEL_WARNINGS = "WARNINGS";
    private static final String LABEL_ERRORS = "ERRORS";
    private static final String LABEL_CATEGORY_WISE_TEST_RESULTS = "Category-wise Test Results";
    private static final String LABEL_OPEN_REPORT = "Open Report";
    private static final String LABEL_NO_FILE_SELECTED = "No file selected";
    private static final String LABEL_BROWSE = "Browse...";
    private static final String LABEL_NO_API_PATHS_FOUND = "No API paths found in OpenAPI specification.";
    private static final String LABEL_NO_HTTP_METHODS_FOUND = "No HTTP methods found in OpenAPI specification.";
    private static final String LABEL_AI_TEST_GENERATION_AVAILABLE_ONLY_FOR_ROOT = "AI Test generation is available only for OpenAPI imported API Collection's root folder.";
    private static final String[][] CATEGORIES = new String[][]{{"Positive Testing", "\u2713"}, {"Negative Testing", "\u2717"}, {"Security Testing", "\ud83d\udd12"}, {"Edge Case Testing", "\u26a1"}};
    private static final String MSG_FOLDER_NOT_FOUND = "Folder Not Found";
    private static final String MSG_FOLDER_NOT_FOUND_DETAILS = "The 'OpenAPI Specification' folder does not exist in this project. Please import an OpenAPI specification first.";
    private static final String MSG_INVALID_LOCATION = "Invalid Location";
    private static final String MSG_INVALID_LOCATION_DETAILS = "Please select a file from the 'OpenAPI Specification' folder only.";
    private static final String MSG_INVALID_OPENAPI_FILE = "Invalid OpenAPI File";
    private static final String MSG_INVALID_OPENAPI_FILE_DETAILS = "Unable to extract title from the selected OpenAPI specification file. Please ensure the file is a valid OpenAPI specification.";
    private static final String MSG_SUCCESS = "Success";
    private static final String MSG_SUCCESS_DETAILS = "OpenAPI specification file linked successfully.";
    private static final String MSG_ERROR = "Error";
    private static final String MSG_ERROR_DETAILS_PREFIX = "An error occurred while processing the OpenAPI specification file: ";
    private static final String DIALOG_SELECT_OPENAPI_SPEC = "Select OpenAPI Specification File";
    private static final String FILTER_JSON = "JSON Files (*.json)";
    private static final String FILTER_YAML = "YAML Files (*.yaml, *.yml)";
    private Button btnGenerateTest;
    private Text txtServerUrl;
    private Composite testResultsGroup;
    private Button btnOpenReport;
    private ScrolledComposite scrollable;
    private Label lblTotalTestCases;
    private Label lblPassedTestCases;
    private Label lblFailedTestCases;
    private Label lblWarningsTestCases;
    private Composite totalTestsCard;
    private Composite passedCard;
    private Composite warningsCard;
    private Composite errorsCard;
    private Map<String, CategoryCardData> categoryCards = new HashMap<String, CategoryCardData>();
    private List<Button> testTypeCheckboxes = new ArrayList<Button>();
    private Map<String, Button> apiPathCheckboxes = new HashMap<String, Button>();
    private Map<String, Button> httpMethodCheckboxes = new HashMap<String, Button>();
    private List<String> cachedApiPaths;
    private List<String> cachedHttpMethods;
    private String cachedServerUrl;
    private CTabFolder currentTabFolder;
    private ApiCollectionEntity apiCollectionEntity;
    private String openApiSpecFilePath;
    private ApiCollectionGenerateTestPart part;
    private OpenApiSpecParser openApiSpecParser;

    public ApiCollectionGenerateTestUI(CTabFolder tabFolder, ApiCollectionEntity apiCollectionEntity, String openApiSpecFilePath) {
        this.apiCollectionEntity = apiCollectionEntity;
        this.openApiSpecFilePath = openApiSpecFilePath;
        this.openApiSpecParser = new OpenApiSpecParser();
        this.initializeOpenApiCache();
        this.part = new ApiCollectionGenerateTestPart(this, apiCollectionEntity, openApiSpecFilePath);
        this.createTab(tabFolder);
    }

    private void initializeOpenApiCache() {
        if (this.openApiSpecFilePath != null) {
            this.cachedApiPaths = this.openApiSpecParser.parseApiPaths(this.openApiSpecFilePath);
            this.cachedHttpMethods = this.openApiSpecParser.parseHttpMethods(this.openApiSpecFilePath);
            this.cachedServerUrl = this.openApiSpecParser.parseServerUrl(this.openApiSpecFilePath);
        }
    }

    private void createTab(CTabFolder tabFolder) {
        this.currentTabFolder = tabFolder;
        if (!this.isRootOpenApiCollection()) {
            this.createNonRootOpenApiView(tabFolder);
            return;
        }
        boolean isLegacyCollection = StringUtils.isBlank((CharSequence)this.apiCollectionEntity.getOpenApiSpecFileName());
        boolean needsFileBrowser = isLegacyCollection && StringUtils.isBlank((CharSequence)this.openApiSpecFilePath);
        CTabItem tabAiTesting = new CTabItem(tabFolder, 0);
        tabAiTesting.setText("Generate Test");
        Composite aiTestComposite = new Composite((Composite)tabFolder, 0);
        aiTestComposite.setLayout((Layout)new GridLayout(1, false));
        aiTestComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrollable = new ScrolledComposite(aiTestComposite, 768);
        this.scrollable.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite contentComposite = new Composite((Composite)this.scrollable, 0);
        contentComposite.setLayout((Layout)this.createGridLayout(1, 25, 25, 0, 20));
        this.createServerConfigurationSection(contentComposite, needsFileBrowser);
        this.createTestConfigurationSection(contentComposite);
        this.createGenerateTestButton(contentComposite, needsFileBrowser);
        this.createTestResultsSection(contentComposite);
        this.scrollable.setContent((Control)contentComposite);
        this.scrollable.setExpandHorizontal(true);
        this.scrollable.setExpandVertical(true);
        this.scrollable.setMinSize(contentComposite.computeSize(-1, -1));
        tabAiTesting.setControl((Control)aiTestComposite);
        this.part.loadPreferences();
        this.part.loadAndDisplayTestResults();
    }

    public void registerButtonListener() {
        this.part.registerButtonListener();
    }

    public List<String> getSelectedTestTypes() {
        return this.getSelectedItems(this.testTypeCheckboxes);
    }

    public List<String> getSelectedApiPaths() {
        return this.getSelectedItems(this.apiPathCheckboxes);
    }

    public List<String> getSelectedHttpMethods() {
        return this.getSelectedItems(this.httpMethodCheckboxes);
    }

    public String getServerUrl() {
        return this.txtServerUrl.getText();
    }

    public Button getBtnGenerateTest() {
        return this.btnGenerateTest;
    }

    public Map<String, Button> getHttpMethodCheckboxes() {
        return this.httpMethodCheckboxes;
    }

    public void scrollToOpenReportButton() {
        Display.getDefault().asyncExec(() -> {
            Control content;
            if (!(this.btnOpenReport == null || this.btnOpenReport.isDisposed() || this.scrollable == null || this.scrollable.isDisposed() || (content = this.scrollable.getContent()) == null || content.isDisposed())) {
                int buttonY = this.btnOpenReport.getLocation().y;
                Composite parent = this.btnOpenReport.getParent();
                while (parent != null && parent != content) {
                    buttonY += parent.getLocation().y;
                    parent = parent.getParent();
                }
                this.scrollable.setOrigin(0, Math.max(0, buttonY - 100));
            }
        });
    }

    public void applyPreferences(AiTestingPreferences preferences) {
        try {
            if (preferences.serverUrl() != null && !preferences.serverUrl().isEmpty() && this.txtServerUrl != null && !this.txtServerUrl.isDisposed()) {
                this.txtServerUrl.setText(preferences.serverUrl());
            }
            if (preferences.testTypes() != null && !preferences.testTypes().isEmpty()) {
                this.applySelections(this.testTypeCheckboxes, new HashSet<String>(preferences.testTypes()));
            }
            if (preferences.apiPaths() != null && !preferences.apiPaths().isEmpty()) {
                this.applySelections(this.apiPathCheckboxes, new HashSet<String>(preferences.apiPaths()));
            }
            if (preferences.httpMethods() != null && !preferences.httpMethods().isEmpty()) {
                this.applySelections(this.httpMethodCheckboxes, new HashSet<String>(preferences.httpMethods()));
            }
        }
        catch (Exception e) {
            logger.error("Failed to apply loaded preferences to UI", (Throwable)e);
        }
    }

    public void updateTestResultLabels(int totalTests, int passedTests, int failedTests, int warningsTests, int passedPositive, int passedNegative, int passedSecurity, int passedEdgeCase, int failedPositive, int failedNegative, int failedSecurity, int failedEdgeCase, int warningsPositive, int warningsNegative, int warningsSecurity, int warningsEdgeCase) {
        this.updateCard(this.lblTotalTestCases, totalTests, this.totalTestsCard, totalTests, false);
        this.updateCard(this.lblPassedTestCases, passedTests, this.passedCard, totalTests, true);
        this.updateCard(this.lblFailedTestCases, failedTests, this.errorsCard, totalTests, true);
        this.updateCard(this.lblWarningsTestCases, warningsTests, this.warningsCard, totalTests, true);
        int[][] categoryData = new int[][]{{passedPositive, warningsPositive, failedPositive}, {passedNegative, warningsNegative, failedNegative}, {passedSecurity, warningsSecurity, failedSecurity}, {passedEdgeCase, warningsEdgeCase, failedEdgeCase}};
        String[] categoryNames = new String[]{"Positive Testing", "Negative Testing", "Security Testing", "Edge Case Testing"};
        int i = 0;
        while (i < categoryNames.length) {
            CategoryCardData data = this.categoryCards.get(categoryNames[i]);
            if (data != null) {
                int total = categoryData[i][0] + categoryData[i][1] + categoryData[i][2];
                this.updateCard(data.passed, categoryData[i][0], null, 0, false);
                this.updateCard(data.warnings, categoryData[i][1], null, 0, false);
                this.updateCard(data.errors, categoryData[i][2], null, 0, false);
                this.updateCard(data.total, total, data.card, 0, false);
            }
            ++i;
        }
        this.refreshComposite(this.testResultsGroup);
    }

    private void createServerConfigurationSection(Composite parent, boolean needsFileBrowser) {
        Label serverConfigLabel = new Label(parent, 0);
        serverConfigLabel.setText(LABEL_SERVER_CONFIGURATION);
        this.setFontStyle((Control)serverConfigLabel, 1);
        GridData labelGd = new GridData(16384, 0x1000000, false, false);
        labelGd.verticalIndent = 5;
        serverConfigLabel.setLayoutData((Object)labelGd);
        Composite serverConfigComposite = new Composite(parent, 0);
        serverConfigComposite.setLayout((Layout)this.createGridLayout(2, 0, 0, 15, 0));
        GridData compositeGd = new GridData(4, 128, true, false);
        compositeGd.verticalIndent = 10;
        compositeGd.minimumWidth = 600;
        serverConfigComposite.setLayoutData((Object)compositeGd);
        this.createServerUrlCard(serverConfigComposite);
        this.createOpenApiSpecFileCard(serverConfigComposite, needsFileBrowser);
    }

    private void createServerUrlCard(Composite parent) {
        Composite serverUrlCard = this.createConfigCard(parent, LABEL_SERVER_URL, ColorUtil.getColor((String)COLOR_BLUE));
        Composite serverUrlContent = new Composite(serverUrlCard, 0);
        serverUrlContent.setLayout((Layout)this.createGridLayout(1, 10, 10, 0, 0));
        serverUrlContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.txtServerUrl = new Text(serverUrlContent, 2048);
        this.txtServerUrl.setLayoutData((Object)this.createGridDataWithHints(-1, 25));
        if (this.cachedServerUrl != null && !this.cachedServerUrl.isEmpty()) {
            this.txtServerUrl.setText(this.cachedServerUrl);
        }
    }

    private void createOpenApiSpecFileCard(Composite parent, boolean needsFileBrowser) {
        Composite openSpecCard = this.createConfigCard(parent, LABEL_OPEN_API_SPEC_FILE_PATH, ColorUtil.getColor((String)COLOR_GREEN));
        Composite openSpecContent = new Composite(openSpecCard, 0);
        if (needsFileBrowser) {
            this.createFileBrowserContent(openSpecContent);
        } else {
            this.createReadOnlyFilePathContent(openSpecContent);
        }
    }

    private void createFileBrowserContent(Composite parent) {
        parent.setLayout((Layout)this.createGridLayout(2, 10, 10, 5, 0));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        final Text txtSelectedPath = new Text(parent, 2056);
        txtSelectedPath.setText(LABEL_NO_FILE_SELECTED);
        GridData pathGd = new GridData(4, 0x1000000, true, false);
        pathGd.heightHint = 25;
        txtSelectedPath.setLayoutData((Object)pathGd);
        Button btnBrowseSpec = new Button(parent, 8);
        btnBrowseSpec.setText(LABEL_BROWSE);
        GridData btnGd = new GridData(0x1000008, 0x1000000, false, false);
        btnGd.widthHint = 100;
        btnGd.heightHint = 25;
        btnBrowseSpec.setLayoutData((Object)btnGd);
        btnBrowseSpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedPath = ApiCollectionGenerateTestUI.this.selectAndValidateOpenApiSpecForLegacy();
                if (selectedPath != null) {
                    txtSelectedPath.setText(selectedPath);
                    ApiCollectionGenerateTestUI.this.refreshTabWithFullUI(ApiCollectionGenerateTestUI.this.currentTabFolder, selectedPath);
                }
            }
        });
    }

    private void createReadOnlyFilePathContent(Composite parent) {
        parent.setLayout((Layout)this.createGridLayout(1, 10, 10, 0, 0));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Text txtOpenSpecFilePath = new Text(parent, 2122);
        String displayPath = this.getRelativePathFromOpenApiSpec(this.openApiSpecFilePath);
        txtOpenSpecFilePath.setText(displayPath != null ? displayPath : "");
        txtOpenSpecFilePath.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private String getRelativePathFromOpenApiSpec(String absolutePath) {
        if (absolutePath == null || absolutePath.isEmpty()) {
            return "";
        }
        try {
            String folderName = ComposerWebserviceMessageConstants.OPENAPI_SPECIFICATION_FOLDER_NAME;
            int index = absolutePath.indexOf(folderName);
            if (index != -1) {
                return absolutePath.substring(index);
            }
            File file = new File(absolutePath);
            return folderName + File.separator + file.getName();
        }
        catch (Exception e) {
            logger.error("Error extracting relative path from: " + absolutePath, (Throwable)e);
            return absolutePath;
        }
    }

    private void createTestConfigurationSection(Composite parent) {
        Label testConfigLabel = new Label(parent, 0);
        testConfigLabel.setText(LABEL_TEST_CONFIGURATION);
        this.setFontStyle((Control)testConfigLabel, 1);
        testConfigLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Composite testConfigComposite = new Composite(parent, 0);
        testConfigComposite.setLayout((Layout)this.createGridLayout(3, 0, 0, 15, 0));
        GridData compositeGd = new GridData(4, 128, true, false);
        compositeGd.minimumWidth = 600;
        compositeGd.heightHint = 200;
        testConfigComposite.setLayoutData((Object)compositeGd);
        this.createTestTypeCard(testConfigComposite);
        this.createApiPathCard(testConfigComposite);
        this.createHttpMethodCard(testConfigComposite);
    }

    private void createTestTypeCard(Composite parent) {
        String[] testTypes;
        Composite testTypeCard = this.createConfigCard(parent, LABEL_TEST_TYPE, ColorUtil.getColor((String)COLOR_BLUE));
        Composite testTypeContent = new Composite(testTypeCard, 0);
        testTypeContent.setLayout((Layout)this.createGridLayout(1, 10, 10, 0, 8));
        testTypeContent.setLayoutData((Object)new GridData(4, 4, true, true));
        String[] stringArray = testTypes = new String[]{"Positive Testing", "Negative Testing", "Security Testing", "Edge Case Testing"};
        int n = testTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String testType = stringArray[n2];
            Button checkbox = new Button(testTypeContent, 32);
            checkbox.setText(testType);
            checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.testTypeCheckboxes.add(checkbox);
            ++n2;
        }
    }

    private void createApiPathCard(Composite parent) {
        ArrayList apiPaths;
        Composite apiPathCard = this.createConfigCard(parent, LABEL_API_PATH, ColorUtil.getColor((String)COLOR_GREEN));
        Composite apiPathContent = new Composite(apiPathCard, 0);
        apiPathContent.setLayout((Layout)this.createGridLayout(1, 10, 10, 0, 0));
        apiPathContent.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite apiPathScrollable = new ScrolledComposite(apiPathContent, 2816);
        apiPathScrollable.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite apiPathContentComposite = new Composite((Composite)apiPathScrollable, 0);
        apiPathContentComposite.setLayout((Layout)this.createGridLayout(1, 5, 5, 0, 8));
        ArrayList arrayList = apiPaths = this.cachedApiPaths != null ? this.cachedApiPaths : new ArrayList();
        if (apiPaths.isEmpty()) {
            Label noPathsLabel = new Label(apiPathContentComposite, 64);
            noPathsLabel.setText(LABEL_NO_API_PATHS_FOUND);
            noPathsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        } else {
            for (String path : apiPaths) {
                Button checkbox = new Button(apiPathContentComposite, 32);
                checkbox.setText(this.convertApiPathToLabel(path));
                checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                this.apiPathCheckboxes.put(path, checkbox);
            }
        }
        apiPathScrollable.setContent((Control)apiPathContentComposite);
        apiPathScrollable.setExpandHorizontal(true);
        apiPathScrollable.setExpandVertical(true);
        apiPathScrollable.setMinSize(apiPathContentComposite.computeSize(-1, -1));
    }

    private void createHttpMethodCard(Composite parent) {
        ArrayList httpMethods;
        Composite httpMethodCard = this.createConfigCard(parent, LABEL_HTTP_METHOD, ColorUtil.getColor((String)COLOR_ORANGE));
        Composite httpMethodContent = new Composite(httpMethodCard, 0);
        httpMethodContent.setLayout((Layout)this.createGridLayout(1, 10, 10, 0, 8));
        httpMethodContent.setLayoutData((Object)new GridData(4, 4, true, true));
        ArrayList arrayList = httpMethods = this.cachedHttpMethods != null ? this.cachedHttpMethods : new ArrayList();
        if (httpMethods.isEmpty()) {
            Label noMethodsLabel = new Label(httpMethodContent, 64);
            noMethodsLabel.setText(LABEL_NO_HTTP_METHODS_FOUND);
            noMethodsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        } else {
            for (String method : httpMethods) {
                Button checkbox = new Button(httpMethodContent, 32);
                checkbox.setText(method);
                checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                this.httpMethodCheckboxes.put(method, checkbox);
            }
        }
    }

    private void createGenerateTestButton(Composite parent, boolean needsFileBrowser) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)this.createGridLayout(1, 0, 0, 0, 0));
        GridData buttonGd = new GridData(131072, 0x1000000, false, false);
        buttonGd.verticalIndent = 10;
        buttonComposite.setLayoutData((Object)buttonGd);
        this.btnGenerateTest = new Button(buttonComposite, 8);
        this.btnGenerateTest.setText("Generate Test");
        this.btnGenerateTest.setLayoutData((Object)this.createGridDataWithHints(180, 35));
        this.btnGenerateTest.setBackground(ColorUtil.getColor((String)COLOR_BLUE));
        this.btnGenerateTest.setForeground(ColorUtil.getColor((String)COLOR_WHITE));
        if (needsFileBrowser) {
            this.btnGenerateTest.setEnabled(false);
            this.btnGenerateTest.setBackground(ColorUtil.getColor((String)"#B0BEC5"));
            this.btnGenerateTest.setForeground(ColorUtil.getColor((String)COLOR_WHITE));
            this.btnGenerateTest.setToolTipText("Please select an OpenAPI specification file first");
        }
    }

    private void createTestResultsSection(Composite parent) {
        this.testResultsGroup = new Composite(parent, 0);
        this.testResultsGroup.setLayout((Layout)this.createGridLayout(1, 0, 0, 0, 20));
        GridData resultsGd = new GridData(4, 4, true, true);
        resultsGd.minimumWidth = 600;
        this.testResultsGroup.setLayoutData((Object)resultsGd);
        this.createConsolidatedResultsSection(this.testResultsGroup);
        this.createCategoryResultsSection(this.testResultsGroup);
        this.createOpenReportButton(this.testResultsGroup);
    }

    private void createConsolidatedResultsSection(Composite parent) {
        Label overviewLabel = new Label(parent, 0);
        overviewLabel.setText(LABEL_CONSOLIDATED_TEST_RESULT);
        this.setFontStyle((Control)overviewLabel, 1);
        GridData labelGd = new GridData(16384, 0x1000000, false, false);
        labelGd.verticalIndent = 5;
        overviewLabel.setLayoutData((Object)labelGd);
        Composite overviewComposite = new Composite(parent, 0);
        overviewComposite.setLayout((Layout)this.createGridLayout(4, 0, 0, 15, 0));
        GridData compositeGd = new GridData(4, 128, true, false);
        compositeGd.verticalIndent = 10;
        overviewComposite.setLayoutData((Object)compositeGd);
        this.totalTestsCard = this.createOverviewCard(overviewComposite, LABEL_TOTAL_TESTS, "0", ColorUtil.getColor((String)COLOR_BLUE), false);
        this.lblTotalTestCases = ((Label[])this.totalTestsCard.getData(DATA_KEY_LABELS))[1];
        this.passedCard = this.createOverviewCard(overviewComposite, LABEL_PASSED, "0", ColorUtil.getColor((String)COLOR_GREEN), true);
        this.lblPassedTestCases = ((Label[])this.passedCard.getData(DATA_KEY_LABELS))[1];
        this.warningsCard = this.createOverviewCard(overviewComposite, LABEL_WARNINGS, "0", ColorUtil.getColor((String)COLOR_ORANGE), true);
        this.lblWarningsTestCases = ((Label[])this.warningsCard.getData(DATA_KEY_LABELS))[1];
        this.errorsCard = this.createOverviewCard(overviewComposite, LABEL_ERRORS, "0", ColorUtil.getColor((String)COLOR_RED), true);
        this.lblFailedTestCases = ((Label[])this.errorsCard.getData(DATA_KEY_LABELS))[1];
    }

    private void createCategoryResultsSection(Composite parent) {
        Label categoryLabel = new Label(parent, 0);
        categoryLabel.setText(LABEL_CATEGORY_WISE_TEST_RESULTS);
        this.setFontStyle((Control)categoryLabel, 1);
        GridData labelGd = new GridData(16384, 0x1000000, false, false);
        labelGd.verticalIndent = 15;
        categoryLabel.setLayoutData((Object)labelGd);
        Composite categoryComposite = new Composite(parent, 0);
        categoryComposite.setLayout((Layout)this.createGridLayout(4, 0, 0, 15, 15));
        GridData compositeGd = new GridData(4, 4, true, true);
        compositeGd.verticalIndent = 10;
        categoryComposite.setLayoutData((Object)compositeGd);
        this.createCategoryCards(categoryComposite);
    }

    private void createCategoryCards(Composite parent) {
        String[][] stringArray = CATEGORIES;
        int n = CATEGORIES.length;
        int n2 = 0;
        while (n2 < n) {
            String[] cat = stringArray[n2];
            CategoryCardData data = new CategoryCardData(cat[0], cat[1]);
            data.card = this.createCategoryCard(parent, cat[0], cat[1]);
            this.createAndAssignCategoryLabels(data);
            this.categoryCards.put(cat[0], data);
            ++n2;
        }
    }

    private void createAndAssignCategoryLabels(CategoryCardData data) {
        String[] labelTexts = new String[]{LABEL_PASSED, LABEL_WARNINGS, LABEL_ERRORS, LABEL_TOTAL_TESTS};
        String[] stringArray = new String[4];
        stringArray[0] = COLOR_GREEN;
        stringArray[1] = COLOR_ORANGE;
        stringArray[2] = COLOR_RED;
        String[] colors = stringArray;
        Label[] valueLabels = new Label[4];
        int i = 0;
        while (i < labelTexts.length) {
            new Label(data.card, 0).setText(labelTexts[i]);
            valueLabels[i] = new Label(data.card, 0);
            valueLabels[i].setText("0");
            GridData valueGd = new GridData(16384, 0x1000000, false, false);
            valueGd.widthHint = 40;
            valueLabels[i].setLayoutData((Object)valueGd);
            if (colors[i] != null) {
                valueLabels[i].setForeground(ColorUtil.getColor((String)colors[i]));
            }
            ++i;
        }
        data.passed = valueLabels[0];
        data.warnings = valueLabels[1];
        data.errors = valueLabels[2];
        data.total = valueLabels[3];
    }

    private void createOpenReportButton(Composite parent) {
        this.btnOpenReport = new Button(parent, 8);
        this.btnOpenReport.setText(LABEL_OPEN_REPORT);
        GridData btnGd = new GridData(0x1000000, 0x1000000, false, false);
        btnGd.widthHint = 200;
        btnGd.heightHint = 35;
        btnGd.verticalIndent = 15;
        this.btnOpenReport.setLayoutData((Object)btnGd);
        this.btnOpenReport.setBackground(ColorUtil.getColor((String)COLOR_GREEN));
        this.btnOpenReport.setForeground(ColorUtil.getColor((String)COLOR_WHITE));
        this.btnOpenReport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiAiTestReportGenerator reportGenerator = new ApiAiTestReportGenerator(ApiCollectionGenerateTestUI.this.apiCollectionEntity, ApiCollectionGenerateTestUI.this.openApiSpecFilePath);
                reportGenerator.openReportInBrowser();
            }
        });
    }

    private Composite createConfigCard(Composite parent, String title, Color borderColor) {
        Composite card = new Composite(parent, 2048);
        card.setLayout((Layout)this.createGridLayout(1, 0, 0, 0, 0));
        GridData cardGd = new GridData(4, 4, true, true);
        cardGd.widthHint = 180;
        cardGd.heightHint = 100;
        card.setLayoutData((Object)cardGd);
        card.addPaintListener(e -> {
            Rectangle rect = card.getBounds();
            e.gc.setLineWidth(4);
            e.gc.setForeground(borderColor);
            e.gc.drawLine(0, 0, 0, rect.height);
        });
        Label titleLabel = new Label(card, 0);
        titleLabel.setText(title);
        this.setFontStyle((Control)titleLabel, 1);
        GridData titleGd = new GridData(16384, 0x1000000, false, false);
        titleGd.horizontalIndent = 10;
        titleGd.verticalIndent = 10;
        titleLabel.setLayoutData((Object)titleGd);
        return card;
    }

    private Composite createOverviewCard(Composite parent, String title, String value, Color borderColor, boolean showPercentage) {
        Composite card = new Composite(parent, 2048);
        card.setLayout((Layout)this.createGridLayout(1, 15, 15, 0, 5));
        GridData cardGd = new GridData(4, 4, true, true);
        cardGd.widthHint = 160;
        cardGd.heightHint = 100;
        card.setLayoutData((Object)cardGd);
        card.addPaintListener(e -> {
            Rectangle rect = card.getBounds();
            e.gc.setLineWidth(4);
            e.gc.setForeground(borderColor);
            e.gc.drawLine(0, 0, 0, rect.height);
        });
        Label titleLabel = new Label(card, 0);
        titleLabel.setText(title);
        this.setFontStyle((Control)titleLabel, 1);
        GridData titleGd = new GridData(16384, 0x1000000, false, false);
        titleGd.horizontalIndent = 5;
        titleLabel.setLayoutData((Object)titleGd);
        Label valueLabel = new Label(card, 0);
        valueLabel.setText(value);
        valueLabel.setFont(this.createFont((Control)valueLabel, 24, 1));
        GridData valueGd = new GridData(16384, 0x1000000, false, false);
        valueGd.horizontalIndent = 5;
        valueGd.verticalIndent = 5;
        valueLabel.setLayoutData((Object)valueGd);
        Label percentageLabel = null;
        if (showPercentage) {
            percentageLabel = new Label(card, 0);
            percentageLabel.setText("0.0%");
            percentageLabel.setFont(this.createFont((Control)percentageLabel, 12, 0));
            GridData percentageGd = new GridData(16384, 0x1000000, false, false);
            percentageGd.horizontalIndent = 5;
            percentageLabel.setLayoutData((Object)percentageGd);
            card.setData(DATA_KEY_PERCENTAGE, (Object)percentageLabel);
        }
        card.setData(DATA_KEY_LABELS, (Object)new Label[]{titleLabel, valueLabel});
        return card;
    }

    private Composite createCategoryCard(Composite parent, String title, String icon) {
        Composite card = new Composite(parent, 2048);
        card.setLayout((Layout)this.createGridLayout(2, 15, 15, 10, 8));
        GridData cardGd = new GridData(4, 4, true, true);
        cardGd.widthHint = 140;
        cardGd.heightHint = 150;
        card.setLayoutData((Object)cardGd);
        Composite titleComposite = new Composite(card, 0);
        titleComposite.setLayout((Layout)this.createGridLayout(2, 0, 0, 5, 0));
        GridData titleGd = new GridData(4, 0x1000000, true, false);
        titleGd.horizontalSpan = 2;
        titleComposite.setLayoutData((Object)titleGd);
        Label iconLabel = new Label(titleComposite, 0);
        iconLabel.setText(icon);
        iconLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label titleLabel = new Label(titleComposite, 0);
        titleLabel.setText(title);
        this.setFontStyle((Control)titleLabel, 1);
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        return card;
    }

    private GridLayout createGridLayout(int numColumns, int marginWidth, int marginHeight, int horizontalSpacing, int verticalSpacing) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginWidth = marginWidth;
        layout.marginHeight = marginHeight;
        layout.horizontalSpacing = horizontalSpacing;
        layout.verticalSpacing = verticalSpacing;
        return layout;
    }

    private GridData createGridDataWithHints(int widthHint, int heightHint) {
        GridData gd = new GridData(4, 0x1000000, true, false);
        if (widthHint != -1) {
            gd.widthHint = widthHint;
        }
        if (heightHint != -1) {
            gd.heightHint = heightHint;
        }
        return gd;
    }

    private void setFontStyle(Control control, int style) {
        Font font = control.getFont();
        FontData[] fontData = font.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(style);
            ++i;
        }
        Font newFont = new Font((Device)control.getDisplay(), fontData);
        control.setFont(newFont);
        control.addDisposeListener(e -> newFont.dispose());
    }

    private Font createFont(Control control, int size, int style) {
        FontData[] fontData = control.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            if (size > 0) {
                fontData[i].setHeight(size);
            }
            fontData[i].setStyle(style);
            ++i;
        }
        Font newFont = new Font((Device)control.getDisplay(), fontData);
        control.addDisposeListener(e -> newFont.dispose());
        return newFont;
    }

    private String convertApiPathToLabel(String apiPath) {
        if (apiPath == null || apiPath.isEmpty()) {
            return "";
        }
        return apiPath.replace("/", "_").replace("{", "").replace("}", "");
    }

    private List<String> getSelectedItems(List<Button> checkboxList) {
        ArrayList<String> selected = new ArrayList<String>();
        for (Button checkbox : checkboxList) {
            if (!checkbox.getSelection()) continue;
            selected.add(checkbox.getText());
        }
        return selected;
    }

    private List<String> getSelectedItems(Map<String, Button> checkboxMap) {
        ArrayList<String> selected = new ArrayList<String>();
        for (Map.Entry<String, Button> entry : checkboxMap.entrySet()) {
            if (!entry.getValue().getSelection()) continue;
            selected.add(entry.getKey());
        }
        return selected;
    }

    private void applySelections(List<Button> checkboxList, Set<String> selectedItems) {
        for (Button checkbox : checkboxList) {
            if (!selectedItems.contains(checkbox.getText())) continue;
            checkbox.setSelection(true);
        }
    }

    private void applySelections(Map<String, Button> checkboxMap, Set<String> selectedItems) {
        for (Map.Entry<String, Button> entry : checkboxMap.entrySet()) {
            if (!selectedItems.contains(entry.getKey())) continue;
            entry.getValue().setSelection(true);
        }
    }

    private void updateCard(Label label, int value, Composite card, int total, boolean showPercentage) {
        Label percentageLabel;
        if (label == null || label.isDisposed()) {
            return;
        }
        label.setText(String.valueOf(value));
        if (showPercentage && total > 0 && (percentageLabel = (Label)card.getData(DATA_KEY_PERCENTAGE)) != null && !percentageLabel.isDisposed()) {
            percentageLabel.setText(String.format("%.1f%%", (double)value * 100.0 / (double)total));
        }
        this.refreshComposite(card);
    }

    private void refreshComposite(Composite composite) {
        if (composite != null && !composite.isDisposed()) {
            composite.layout(true, true);
            composite.redraw();
        }
    }

    private String selectAndValidateOpenApiSpecForLegacy() {
        File selectedFile;
        String selectedFilePath;
        block9: {
            block8: {
                File openApiFolder;
                block7: {
                    String openApiSpecFolderPath;
                    block6: {
                        try {
                            openApiSpecFolderPath = this.apiCollectionEntity.getProject().getFolderLocation() + File.separator + ComposerWebserviceMessageConstants.OPENAPI_SPECIFICATION_FOLDER_NAME;
                            openApiFolder = new File(openApiSpecFolderPath);
                            if (openApiFolder.exists() && openApiFolder.isDirectory()) break block6;
                            this.showError(MSG_FOLDER_NOT_FOUND, MSG_FOLDER_NOT_FOUND_DETAILS);
                            return null;
                        }
                        catch (Exception e) {
                            logger.error("Error selecting and validating OpenAPI spec file", (Throwable)e);
                            this.showError(MSG_ERROR, MSG_ERROR_DETAILS_PREFIX + (e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()));
                            return null;
                        }
                    }
                    selectedFilePath = this.openFileDialog(openApiSpecFolderPath);
                    if (selectedFilePath != null) break block7;
                    return null;
                }
                selectedFile = new File(selectedFilePath);
                if (selectedFile.getParentFile().getAbsolutePath().equals(openApiFolder.getAbsolutePath())) break block8;
                this.showError(MSG_INVALID_LOCATION, MSG_INVALID_LOCATION_DETAILS);
                return null;
            }
            String specTitle = this.openApiSpecParser.parseTitle(selectedFilePath);
            if (!StringUtils.isBlank((CharSequence)specTitle)) break block9;
            this.showError(MSG_INVALID_OPENAPI_FILE, MSG_INVALID_OPENAPI_FILE_DETAILS);
            return null;
        }
        this.apiCollectionEntity.setOpenApiSpecFileName(selectedFile.getName());
        FolderController.getInstance().saveFolder((FolderEntity)this.apiCollectionEntity);
        this.showInfo(MSG_SUCCESS, MSG_SUCCESS_DETAILS);
        return selectedFilePath;
    }

    private String openFileDialog(String folderPath) {
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        fileDialog.setText(DIALOG_SELECT_OPENAPI_SPEC);
        fileDialog.setFilterPath(folderPath);
        fileDialog.setFilterExtensions(new String[]{"*.json", "*.yaml;*.yml"});
        fileDialog.setFilterNames(new String[]{FILTER_JSON, FILTER_YAML});
        return fileDialog.open();
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
    }

    private void showInfo(String title, String message) {
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
    }

    private void refreshTabWithFullUI(CTabFolder tabFolder, String openApiSpecFilePath) {
        this.openApiSpecFilePath = openApiSpecFilePath;
        this.initializeOpenApiCache();
        this.part = new ApiCollectionGenerateTestPart(this, this.apiCollectionEntity, openApiSpecFilePath);
        int i = 0;
        while (i < tabFolder.getItemCount()) {
            CTabItem tab = tabFolder.getItem(i);
            if ("Generate Test".equals(tab.getText())) {
                tab.dispose();
                break;
            }
            ++i;
        }
        this.createTab(tabFolder);
        tabFolder.setSelection(tabFolder.getItemCount() - 1);
        if (this.btnGenerateTest != null && !this.btnGenerateTest.isDisposed()) {
            this.part.registerButtonListener();
        }
    }

    private boolean isRootOpenApiCollection() {
        ApiCollectionEntity parentCollection;
        boolean isOpenApiCollection;
        boolean bl = isOpenApiCollection = this.apiCollectionEntity.getCollectionType() == ApiCollectionEntity.CollectionType.OPENAPI_3_0;
        if (!isOpenApiCollection) {
            return false;
        }
        FolderEntity folderEntity = this.apiCollectionEntity.getParentFolder();
        return !(folderEntity instanceof ApiCollectionEntity) || (parentCollection = (ApiCollectionEntity)folderEntity).getCollectionType() != ApiCollectionEntity.CollectionType.OPENAPI_3_0;
    }

    private void createNonRootOpenApiView(CTabFolder tabFolder) {
        CTabItem tabAiTesting = new CTabItem(tabFolder, 0);
        tabAiTesting.setText("Generate Test");
        Composite aiTestComposite = new Composite((Composite)tabFolder, 0);
        aiTestComposite.setLayout((Layout)this.createGridLayout(1, 20, 20, 0, 15));
        aiTestComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label descLabel = new Label(aiTestComposite, 64);
        descLabel.setText(LABEL_AI_TEST_GENERATION_AVAILABLE_ONLY_FOR_ROOT);
        this.setFontStyle((Control)descLabel, 2);
        GridData descGd = new GridData(4, 128, true, false);
        descGd.widthHint = 600;
        descGd.horizontalIndent = 5;
        descLabel.setLayoutData((Object)descGd);
        tabAiTesting.setControl((Control)aiTestComposite);
    }

    private static class CategoryCardData {
        String title;
        String icon;
        Composite card;
        Label passed;
        Label warnings;
        Label errors;
        Label total;

        CategoryCardData(String title, String icon) {
            this.title = title;
            this.icon = icon;
        }
    }
}

