/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.components;

import com.kms.katalon.composer.components.impl.editors.StringComboBoxCellEditor;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.resources.image.ImageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class KeywordsSelectionComposite
extends Composite {
    private TableViewer tableViewer;
    private TableViewerColumn tvcName;
    private KeywordsSelectionModel model;

    public KeywordsSelectionComposite(Composite parent, int style, KeywordsSelectionModel model) {
        super(parent, style);
        this.model = model;
        this.setLayout((Layout)new GridLayout(1, false));
        ComponentBuilder.label((Composite)this).text("Keywords affected by delay").fillHorizontal().build();
        Group group = (Group)ComponentBuilder.group((Composite)this).gridLayout(1).fill().margin(0, 4, 4, 4).build();
        this.createToolBar((Composite)group);
        this.createTableViewer((Composite)group);
        this.setModel(model);
    }

    private void createTableViewer(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.minimumHeight = 250;
        tableComposite.setLayoutData((Object)gd);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        this.tableViewer = new TableViewer(tableComposite, 67586);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tvcName = new TableViewerColumn(this.tableViewer, 0);
        this.tvcName.getColumn().setText("Keywords");
        columnLayout.setColumnData((Widget)this.tvcName.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.tvcName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        this.tvcName.setEditingSupport((EditingSupport)new KeywordsEditingSupport(this.tableViewer, this.model));
    }

    private void createToolBar(Composite parent) {
        Composite container = (Composite)ComponentBuilder.fromGrid((Composite)parent).fill().margin(0).build();
        ToolBar toolbar = (ToolBar)ComponentBuilder.toolBar((Composite)container, (int)0x820000).color(ColorUtil.getToolBarForegroundColor()).build();
        ComponentBuilder.toolItem((Composite)toolbar).text(StringConstants.ADD).image(ImageManager.getImage((String)"add_16.png")).onClick(e -> this.handleAdd()).build();
        ComponentBuilder.toolItem((Composite)toolbar).text(StringConstants.REMOVE).image(ImageManager.getImage((String)"delete_16.png")).onClick(e -> this.handleRemove()).build();
        ComponentBuilder.toolItem((Composite)toolbar).text(StringConstants.RESET_DEFAULT).onClick(e -> this.handleResetToDefault()).build();
    }

    private void handleAdd() {
        String newValue = this.model.getSuggestedKeyword();
        if (newValue == null) {
            return;
        }
        this.model.getSelectedKeywords().add(newValue);
        this.tableViewer.refresh();
        int newIndex = this.model.getSelectedKeywords().size() - 1;
        this.tableViewer.getTable().setSelection(newIndex);
        this.tableViewer.getTable().setFocus();
        this.tableViewer.editElement((Object)this.model.getSelectedKeywords().get(newIndex), 0);
    }

    private void handleRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.model.getSelectedKeywords().removeAll(selection.toList());
        this.tableViewer.refresh();
    }

    private void handleResetToDefault() {
        this.model.getSelectedKeywords().clear();
        this.model.getSelectedKeywords().addAll(this.model.getDefaultSelectedKeywords());
        this.tableViewer.refresh();
    }

    public List<String> getKeywords() {
        return new ArrayList<String>(this.model.getSelectedKeywords());
    }

    public void setModel(KeywordsSelectionModel newModel) {
        this.model = newModel;
        this.tvcName.setEditingSupport((EditingSupport)new KeywordsEditingSupport(this.tableViewer, this.model));
        this.tableViewer.setInput(this.model.getSelectedKeywords());
        this.tableViewer.refresh();
    }

    private static class KeywordsEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;
        private final KeywordsSelectionModel model;

        public KeywordsEditingSupport(TableViewer viewer, KeywordsSelectionModel model) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.model = model;
        }

        protected CellEditor getCellEditor(Object element) {
            return new StringComboBoxCellEditor((Composite)this.viewer.getTable(), this.model.getAvailableKeywordsToSelect());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return element;
        }

        protected void setValue(Object oldValue, Object newValue) {
            if (oldValue == null || newValue == null || oldValue.equals(newValue)) {
                return;
            }
            if (!this.model.canSelect((String)newValue)) {
                return;
            }
            int idx = this.model.getSelectedKeywords().indexOf(oldValue);
            if (idx >= 0) {
                this.model.getSelectedKeywords().set(idx, (String)newValue);
                this.viewer.refresh();
            }
        }
    }

    public static class KeywordsSelectionModel {
        private final String[] allKeywords;
        private final List<String> defaultSelectedKeywords;
        private final List<String> selectedKeywords;

        public KeywordsSelectionModel(String[] allKeywords, List<String> defaultSelectedKeywords, List<String> selectedKeywords) {
            this.allKeywords = allKeywords;
            this.defaultSelectedKeywords = defaultSelectedKeywords;
            this.selectedKeywords = new ArrayList<String>(selectedKeywords);
        }

        public KeywordsSelectionModel() {
            this(new String[0], new ArrayList<String>(), new ArrayList<String>());
        }

        public List<String> getDefaultSelectedKeywords() {
            return this.defaultSelectedKeywords;
        }

        public List<String> getSelectedKeywords() {
            return this.selectedKeywords;
        }

        public String[] getAvailableKeywordsToSelect() {
            ArrayList<String> available = new ArrayList<String>(Arrays.asList(this.allKeywords));
            available.removeAll(this.selectedKeywords);
            return available.toArray(new String[0]);
        }

        public String getSuggestedKeyword() {
            return this.defaultSelectedKeywords.stream().filter(s -> !this.selectedKeywords.contains(s)).findFirst().orElse(Arrays.stream(this.allKeywords).filter(s -> !this.selectedKeywords.contains(s)).findFirst().orElse(null));
        }

        public boolean canSelect(String newKeyword) {
            if (newKeyword == null) {
                return false;
            }
            if (this.selectedKeywords.contains(newKeyword)) {
                return false;
            }
            return Arrays.asList(this.allKeywords).contains(newKeyword);
        }
    }
}

