/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.dialog;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.ApplicationProxyUtil;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.execution.collection.dialog.ExecutionProfileSelectionDialog;
import com.kms.katalon.composer.execution.collection.dialog.RunConfigurationSelectionDialog;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.ImageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.dialog.TestSuiteSelectionDialog;
import com.kms.katalon.composer.execution.part.GenerateCommandAuthenticationPart;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.resources.util.ImageUtil;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.composer.testsuite.parts.TestSuiteRetryUiAdapter;
import com.kms.katalon.composer.testsuite.parts.TestSuiteRetryUiPart;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.mobile.util.MobileRunConfigurationUtil;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.discovery.services.DiscoveryController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.execution.collection.collector.TestExecutionGroupCollector;
import com.kms.katalon.execution.collection.provider.TestExecutionEntryItem;
import com.kms.katalon.execution.collection.provider.TestExecutionGroup;
import com.kms.katalon.execution.console.ConsoleOptionBuilder;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.mobile.util.MobileExecutionUtil;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsRelease;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.CryptoUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GenerateCommandDialog
extends AbstractDialog {
    @Inject
    private ITestOpsController testOpsController;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IEclipseContext context;
    private static final String KATALON_EXECUTABLE_LINUX = "./katalonc";
    private static final String KATALON_EXECUTABLE_WIN32 = "katalonc";
    private static final String KATALON_EXECUTABLE_MACOS = "./katalonc";
    private static final int GENERATE_PROPERTY_ID = 22;
    private static final int GENERATE_COMMAND_ID = 23;
    private static final int GENERATE_TESTOPS_CI_COMMAND_ID = 25;
    private Text txtTestSuite;
    private Combo cbTestOpsRelease;
    private Text txtStatusDelay;
    private Text txtTerminateThreshold;
    private Button btnBrowseTestSuite;
    private Button chkApplyProxy;
    private Button chkAutoUpdateDrivers;
    private Button chkTerminateExecution;
    private ProjectEntity project;
    private static final String ZERO = "0";
    private static final String defaultStatusDelay = Integer.toString(15);
    private static final String defaultPropertyFileName = "console.properties";
    private static final String ARG_CONFIG = "config";
    private static final String ARG_RUN_MODE = "runMode";
    private static final String ARG_PROJECT_PATH = "projectPath";
    private static final String ARG_STATUS_DELAY = "statusDelay";
    private static final String ARG_TERMINATE_EXECUTION = "maxFailedTests";
    private static final String ARG_TEST_SUITE_PATH = "testSuitePath";
    private static final String ARG_TEST_SUITE_COLLECTION_PATH = "testSuiteCollectionPath";
    private static final String ARG_RETRY = "retry";
    private static final String ARG_RETRY_STRATEGY = "retryStrategy";
    private static final String ARG_ANALYTICS_RELEASE_ID = "testOpsReleaseId";
    private static final String ARG_ANALYTICS_PROJECT_ID = "testOpsProjectId";
    private static final String ARG_ADMIN_SERVER_URL = "serverUrl";
    private static final String ARG_API_KEY = "apiKey";
    private String currentProjectFullPath = ProjectController.getInstance().getCurrentProject().getFolderLocation();
    private Group grpPlatform;
    private Group retryOptionsContainer;
    private Composite main;
    private ScrolledComposite scrolledComposite;
    private CLabel lblRunConfiguration;
    private CLabel lblConfigurationData;
    private Button btnChangeRunConfigurationData;
    private Button btnChangeConfiguration;
    private TestExecutionEntryItem testExecutionItem;
    private RunConfigurationDescription runConfigDescription;
    private Composite configurationDataComposite;
    private Composite configurationComposite;
    private Composite overrideComposite;
    private CLabel lblProfileName;
    private Button btnChangeProfile;
    private Button chkOverridePlatform;
    private Label lblTestSuite;
    private AnalyticsSettingStore analyticsSettingStore;
    private TestSuiteRetryUiPart retryUiProvider;
    private GenerateCommandAuthenticationPart authenticationProvider;
    private TestSuiteEntity testSuite;
    private List<AnalyticsRelease> releases;
    private List<AnalyticsProject> testOpsProjects;
    private Combo cbTestOpsProjects;
    private boolean isInTour = false;

    public GenerateCommandDialog(Shell parentShell, ProjectEntity project) {
        super(parentShell);
        this.project = project;
    }

    @PostConstruct
    public void postConstruct() {
        this.setDialogTitle(StringConstants.DIA_TITLE_GENERATE_COMMAND_FOR_CONSOLE);
        final GenerateCommandDialog part = this;
        this.retryUiProvider = new TestSuiteRetryUiPart(new TestSuiteRetryUiAdapter(){

            public void setDirty(boolean value) {
            }

            public TestSuiteEntity getTestSuite() {
                return part.getTestSuite();
            }
        });
        ContextInjectionFactory.inject((Object)this.retryUiProvider, (IEclipseContext)this.context);
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected int getShellStyle() {
        return 0x8860 | GenerateCommandDialog.getDefaultOrientation() | 0x10;
    }

    protected Control createDialogContainer(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.main = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout glMain = new GridLayout();
        glMain.marginHeight = 0;
        glMain.marginWidth = 0;
        this.main.setLayout((Layout)glMain);
        this.createTestSuitePart(this.main);
        this.createPlatformPart(this.main);
        this.authenticationProvider = new GenerateCommandAuthenticationPart(this.main);
        this.createExecutionConfigurationsPart(this.main);
        this.analyticsSettingStore = AnalyticsSettingStore.getStore((String)this.currentProjectFullPath);
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        ContextInjectionFactory.inject((Object)this.analyticsSettingStore, (IEclipseContext)context);
        if (this.analyticsSettingStore.isIntegrationEnabled()) {
            this.createTestOpsPart(this.main);
        }
        this.registerEvent();
        this.getConfigurationAnalytics();
        this.scrolledComposite.setContent((Control)this.main);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinSize(this.main.computeSize(-1, -1));
        return this.scrolledComposite;
    }

    private void createTestSuitePart(Composite parent) {
        Composite testsuiteContainer = new Composite(parent, 0);
        testsuiteContainer.setLayout((Layout)new GridLayout(3, false));
        testsuiteContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblTestSuite = new Label(testsuiteContainer, 0);
        this.lblTestSuite.setText(StringConstants.TEST_SUITE);
        this.txtTestSuite = new Text(testsuiteContainer, 2056);
        this.txtTestSuite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnBrowseTestSuite = new Button(testsuiteContainer, 0x800000);
        this.btnBrowseTestSuite.setText(StringConstants.BROWSE);
    }

    private void createTestOpsPart(Composite parent) {
        Composite testopsContainer = new Composite(parent, 0);
        testopsContainer.setLayout((Layout)new GridLayout());
        testopsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group grpTestOpsContainer = new Group(testopsContainer, 0);
        grpTestOpsContainer.setLayout((Layout)new GridLayout(2, false));
        grpTestOpsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        grpTestOpsContainer.setText(StringConstants.DIA_GRP_KATALON_TESTOPS);
        if (!ApplicationInfo.isPlatformStudio()) {
            Label lblTestOpsProject = new Label((Composite)grpTestOpsContainer, 0);
            lblTestOpsProject.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lblTestOpsProject.setText(StringConstants.DIA_LBL_TESTOPS_PROJECT);
            this.cbTestOpsProjects = new Combo((Composite)grpTestOpsContainer, 8);
            this.cbTestOpsProjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.cbTestOpsProjects.add(StringConstants.DIA_CB_TESTOPS_LOADING);
            this.cbTestOpsProjects.select(0);
            this.cbTestOpsProjects.setEnabled(false);
        }
        Label lblTestOpsRelease = new Label((Composite)grpTestOpsContainer, 0);
        lblTestOpsRelease.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblTestOpsRelease.setText(StringConstants.DIA_LBL_TESTOPS_RELEASE);
        this.cbTestOpsRelease = new Combo((Composite)grpTestOpsContainer, 8);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.cbTestOpsRelease.setLayoutData((Object)gridData);
        this.cbTestOpsRelease.add(StringConstants.DIA_CB_TESTOPS_LOADING);
        this.cbTestOpsRelease.select(0);
        this.cbTestOpsRelease.setEnabled(false);
    }

    private void createPlatformPart(Composite parent) {
        Composite platformContainer = new Composite(parent, 0);
        GridLayout glPlatformContainer = new GridLayout(1, false);
        glPlatformContainer.marginHeight = 0;
        platformContainer.setLayout((Layout)glPlatformContainer);
        platformContainer.setLayoutData((Object)new GridData(768));
        this.grpPlatform = new Group(platformContainer, 0);
        this.grpPlatform.setLayout((Layout)new GridLayout(1, false));
        this.grpPlatform.setLayoutData((Object)new GridData(768));
        this.grpPlatform.setText(StringConstants.DIA_GRP_EXECUTED_PLATFORM);
        this.createConfigurationComposite();
        this.createConfigurationDataComposite();
        this.createExecutionProfileComposite();
        this.createOverrideComposite();
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject.getType() == ProjectType.WEBSERVICE) {
            ((GridData)this.configurationComposite.getLayoutData()).exclude = true;
            this.configurationComposite.setVisible(false);
            ((GridData)this.configurationDataComposite.getLayoutData()).exclude = true;
            this.configurationDataComposite.setVisible(false);
        }
    }

    private void createExecutionProfileComposite() {
        Composite executionComposite = new Composite((Composite)this.grpPlatform, 0);
        executionComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdExecutionComposite = new GridLayout(2, false);
        gdExecutionComposite.marginWidth = 0;
        gdExecutionComposite.marginHeight = 0;
        executionComposite.setLayout((Layout)gdExecutionComposite);
        Label lblRunWith = new Label(executionComposite, 0);
        lblRunWith.setLayoutData((Object)new GridData(36));
        lblRunWith.setText(ComposerExecutionMessageConstants.DIA_LBL_PROFILE);
        Composite profileDetailsComposite = new Composite(executionComposite, 0);
        profileDetailsComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdConfiguration = new GridLayout(2, false);
        gdConfiguration.marginWidth = 0;
        gdConfiguration.marginHeight = 0;
        profileDetailsComposite.setLayout((Layout)gdConfiguration);
        this.lblProfileName = new CLabel(profileDetailsComposite, 0);
        this.lblProfileName.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.btnChangeProfile = new Button(profileDetailsComposite, 0x800000);
        this.btnChangeProfile.setImage(ImageConstants.IMG_16_EDIT);
        this.btnChangeProfile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.btnChangeProfile.setText(StringConstants.EDIT);
    }

    private void createConfigurationComposite() {
        this.configurationComposite = new Composite((Composite)this.grpPlatform, 0);
        this.configurationComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdConfigurationData = new GridLayout(2, false);
        gdConfigurationData.marginWidth = 0;
        gdConfigurationData.marginHeight = 0;
        this.configurationComposite.setLayout((Layout)gdConfigurationData);
        Label lblRunWith = new Label(this.configurationComposite, 0);
        lblRunWith.setLayoutData((Object)new GridData(36));
        lblRunWith.setText(ComposerExecutionMessageConstants.DIA_LBL_RUN_WITH);
        Composite configurationDetailsComposite = new Composite(this.configurationComposite, 0);
        configurationDetailsComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdConfiguration = new GridLayout(2, false);
        gdConfiguration.marginWidth = 0;
        gdConfiguration.marginHeight = 0;
        configurationDetailsComposite.setLayout((Layout)gdConfiguration);
        this.lblRunConfiguration = new CLabel(configurationDetailsComposite, 0);
        this.lblRunConfiguration.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.lblRunConfiguration.setText(ComposerExecutionMessageConstants.DIA_TITLE_RUN_CONFIG_SELECTION);
        this.btnChangeConfiguration = new Button(configurationDetailsComposite, 0x800000);
        this.btnChangeConfiguration.setImage(ImageConstants.IMG_16_EDIT);
        this.btnChangeConfiguration.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.btnChangeConfiguration.setText(StringConstants.EDIT);
    }

    private void createOverrideComposite() {
        this.overrideComposite = new Composite((Composite)this.grpPlatform, 0);
        this.overrideComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdOverrideComposite = new GridLayout(2, false);
        gdOverrideComposite.marginWidth = 0;
        gdOverrideComposite.marginHeight = 0;
        this.overrideComposite.setLayout((Layout)gdOverrideComposite);
        this.chkOverridePlatform = new Button(this.overrideComposite, 32);
        this.chkOverridePlatform.setLayoutData((Object)new GridData(36));
        this.chkOverridePlatform.setText(StringConstants.DIA_CHK_OVERRIDE_PLATFORM);
        Label lblHelp = new Label(this.overrideComposite, 0);
        lblHelp.setImage(ImageManager.getImage((String)"help_16.png"));
        lblHelp.setLayoutData((Object)new GridData(36));
        lblHelp.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                try {
                    Program.launch((String)DocumentationMessageConstants.CHK_OVERRIDE_PLATFORM_HELP_URL);
                    Trackings.trackOpenHelp((String)DocumentationMessageConstants.CHK_OVERRIDE_PLATFORM_HELP_URL);
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openWarning((Shell)GenerateCommandDialog.this.getShell(), (String)StringConstants.WARN_TITLE, (String)ex.getMessage());
                }
            }
        });
    }

    private void createConfigurationDataComposite() {
        this.configurationDataComposite = new Composite((Composite)this.grpPlatform, 0);
        this.configurationDataComposite.setLayoutData((Object)new GridData(768));
        GridLayout gdConfigurationData = new GridLayout(2, false);
        gdConfigurationData.marginWidth = 0;
        gdConfigurationData.marginHeight = 0;
        this.configurationDataComposite.setLayout((Layout)gdConfigurationData);
        Label lblRunConfiguration = new Label(this.configurationDataComposite, 0);
        lblRunConfiguration.setLayoutData((Object)new GridData(36));
        lblRunConfiguration.setText(ComposerExecutionMessageConstants.DIA_LBL_RUN_CONFIGURATION);
        Composite configurationDataDetails = new Composite(this.configurationDataComposite, 0);
        configurationDataDetails.setLayoutData((Object)new GridData(768));
        GridLayout gdConfigurationDataDetails = new GridLayout(2, false);
        gdConfigurationDataDetails.marginWidth = 0;
        gdConfigurationDataDetails.marginHeight = 0;
        configurationDataDetails.setLayout((Layout)gdConfigurationDataDetails);
        this.lblConfigurationData = new CLabel(configurationDataDetails, 0);
        this.lblConfigurationData.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.lblConfigurationData.setText(ComposerExecutionMessageConstants.DIA_MSG_CONFIGURATION_IS_REQUIRED);
        this.btnChangeRunConfigurationData = new Button(configurationDataDetails, 0x800000);
        this.btnChangeRunConfigurationData.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.btnChangeRunConfigurationData.setImage(ImageConstants.IMG_16_EDIT);
        this.btnChangeRunConfigurationData.setText(StringConstants.EDIT);
    }

    private void createExecutionConfigurationsPart(Composite parent) {
        Composite optionsContainer = new Composite(parent, 0);
        optionsContainer.setLayout((Layout)new GridLayout());
        optionsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpOptionsContainer = new Group(optionsContainer, 0);
        grpOptionsContainer.setLayout((Layout)new GridLayout(3, false));
        grpOptionsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpOptionsContainer.setText(StringConstants.DIA_GRP_EXECUTION_CONFIGURATIONS);
        this.chkAutoUpdateDrivers = new Button((Composite)grpOptionsContainer, 32);
        GridData gd = new GridData(4, 0x1000000, true, false, 3, 1);
        this.chkAutoUpdateDrivers.setLayoutData((Object)gd);
        this.chkAutoUpdateDrivers.setText(StringConstants.DIA_CHK_AUTO_UPDATE_WEBDRIVER);
        Composite terminationExecutionComp = new Composite((Composite)grpOptionsContainer, 0);
        GridLayout gl3 = new GridLayout(3, false);
        gl3.marginWidth = 0;
        gl3.marginHeight = 0;
        terminationExecutionComp.setLayout((Layout)gl3);
        this.chkTerminateExecution = new Button(terminationExecutionComp, 32);
        GridData gd2 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.chkTerminateExecution.setLayoutData((Object)gd2);
        this.chkTerminateExecution.setText(StringConstants.DIA_CHK_APPLY_TERMINATE);
        this.txtTerminateThreshold = new Text(terminationExecutionComp, 0x1000800);
        GridData gdTxtTerminateThreshold = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdTxtTerminateThreshold.widthHint = 30;
        this.txtTerminateThreshold.setLayoutData((Object)gdTxtTerminateThreshold);
        this.txtTerminateThreshold.setTextLimit(5);
        this.chkApplyProxy = new Button((Composite)grpOptionsContainer, 32);
        this.chkApplyProxy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.chkApplyProxy.setText(StringConstants.DIA_CHK_APPLY_PROXY);
        Composite statusComposite = new Composite((Composite)grpOptionsContainer, 0);
        GridLayout gl2 = new GridLayout(3, false);
        gl2.marginWidth = 0;
        gl2.marginHeight = 0;
        statusComposite.setLayout((Layout)gl2);
        Label lblUpdateStatusTiming = new Label(statusComposite, 0);
        GridData gd1 = new GridData();
        gd1.horizontalIndent = 2;
        lblUpdateStatusTiming.setLayoutData((Object)gd1);
        lblUpdateStatusTiming.setText(StringConstants.DIA_LBL_UPDATE_EXECUTION_STATUS);
        this.txtStatusDelay = new Text(statusComposite, 0x1000800);
        GridData gdTxtUpdateStatusTiming = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdTxtUpdateStatusTiming.widthHint = 30;
        this.txtStatusDelay.setLayoutData((Object)gdTxtUpdateStatusTiming);
        this.txtStatusDelay.setTextLimit(5);
        Label lblSeconds = new Label(statusComposite, 0);
        lblSeconds.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblSeconds.setText(StringConstants.DIA_LBL_SECONDS);
        this.retryOptionsContainer = new Group((Composite)grpOptionsContainer, 0);
        this.retryOptionsContainer.setLayout((Layout)new GridLayout(3, false));
        this.retryOptionsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.retryOptionsContainer.setText(StringConstants.DIA_GRP_RETRY_OPTIONS);
        Composite retryComposite = new Composite((Composite)this.retryOptionsContainer, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        retryComposite.setLayout((Layout)gl);
        retryComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.retryUiProvider.createRetryComposite(retryComposite);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 22, StringConstants.DIA_BTN_GEN_PROPERTY_FILE, false);
        this.createButton(parent, 23, StringConstants.DIA_BTN_GEN_COMMAND, this.isValidInput());
        if (this.analyticsSettingStore.isIntegrationEnabled()) {
            this.createButton(parent, 25, StringConstants.DIA_BTN_GEN_TESTOPS_CI_COMMAND, this.isValidInput());
        }
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected boolean hasDocumentation() {
        return true;
    }

    protected String getDocumentationUrl() {
        return DocumentationMessageConstants.DIALOG_GENERATE_COMMAND;
    }

    protected void setInput() {
        this.setInputForRetry();
        this.txtStatusDelay.setText(defaultStatusDelay);
        this.setDefaultProfile();
        ScopedPreferenceStore prefs = GenerateCommandDialog.getPreference();
        prefs.setDefault("generateCommand.applyProxy", true);
        this.chkApplyProxy.setSelection(true);
        prefs.setDefault("generateCommand.autoUpdateDrivers", false);
        prefs.setDefault("generateCommand.applyFailedThreshold", false);
        this.chkAutoUpdateDrivers.setSelection(true);
        this.txtTerminateThreshold.setEnabled(false);
        this.loadLastWorkingData();
        this.updatePlatformLayout();
    }

    private void setInputForRetry() {
        TestSuiteRetryUiPart.RetryControlStateDescription description = new TestSuiteRetryUiPart.RetryControlStateDescription(0, DefaultRerunSetting.RetryStrategyValue.ALL_EXECUTIONS);
        this.retryUiProvider.synRetryControlStatesByDescription(description);
    }

    private void setDefaultProfile() {
        try {
            RunConfigurationDescription runConfigurationDescription = this.getStoredConfigurationDescription();
            if (runConfigurationDescription != null) {
                ExecutionProfileEntity defaultExecutionProfile = GlobalVariableController.getInstance().getDefaultExecutionProfile(this.project);
                runConfigurationDescription.setProfileName(defaultExecutionProfile.getName());
                ScopedPreferenceStore prefs = GenerateCommandDialog.getPreference();
                prefs.setValue("generateCommand.runConfigurationDescription", JsonUtil.toJson((Object)runConfigurationDescription));
            }
        }
        catch (ControllerException error) {
            LoggerSingleton.logError((Throwable)error);
        }
    }

    private void loadLastWorkingData() {
        try {
            ScopedPreferenceStore prefs = GenerateCommandDialog.getPreference();
            if (!prefs.isDefault("generateCommand.updateStatusTimeInterval")) {
                this.txtStatusDelay.setText(String.valueOf(prefs.getInt("generateCommand.updateStatusTimeInterval")));
            }
            if (!prefs.isDefault("generateCommand.updateFailedThreshold")) {
                this.txtTerminateThreshold.setText(String.valueOf(prefs.getInt("generateCommand.updateFailedThreshold")));
            }
            if (!prefs.isDefault("generateCommand.applyProxy")) {
                this.chkApplyProxy.setSelection(prefs.getBoolean("generateCommand.applyProxy"));
            }
            if (!prefs.isDefault("generateCommand.applyFailedThreshold")) {
                this.chkTerminateExecution.setSelection(prefs.getBoolean("generateCommand.applyFailedThreshold"));
                this.txtTerminateThreshold.setEnabled(this.chkTerminateExecution.getSelection());
            }
            if (!prefs.isDefault("generateCommand.autoUpdateDrivers")) {
                this.chkAutoUpdateDrivers.setSelection(prefs.getBoolean("generateCommand.autoUpdateDrivers"));
            } else {
                this.chkAutoUpdateDrivers.setSelection(true);
            }
            if (!prefs.isDefault("generateCommand.overridePlatform")) {
                this.chkOverridePlatform.setSelection(prefs.getBoolean("generateCommand.overridePlatform"));
            }
            if (!prefs.isDefault("generateCommand.suiteId")) {
                String prefSuiteId = prefs.getString("generateCommand.suiteId");
                this.changeSuiteArtifact(this.getSelectedTestSuite(prefSuiteId));
            }
            this.loadLastWorkingDataForRetry(prefs);
            this.onRunConfigurationChanged(this.getStoredConfigurationDescription());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void loadLastWorkingDataForRetry(ScopedPreferenceStore prefs) {
        boolean shouldRetryAllExecutions;
        boolean shouldRetryFailedExecution;
        int retryNumber = 0;
        DefaultRerunSetting.RetryStrategyValue value = DefaultRerunSetting.RetryStrategyValue.ALL_EXECUTIONS;
        if (!prefs.isDefault("generateCommand.retry")) {
            retryNumber = prefs.getInt("generateCommand.retry");
        }
        if (!prefs.isDefault("generateCommand.retry.forFailedExecutions") && (shouldRetryFailedExecution = prefs.getBoolean("generateCommand.retry.forFailedExecutions"))) {
            value = DefaultRerunSetting.RetryStrategyValue.FAILED_EXECUTIONS;
        }
        if (!prefs.isDefault("generateCommand.retry.forAllExecutions") && (shouldRetryAllExecutions = prefs.getBoolean("generateCommand.retry.forAllExecutions"))) {
            value = DefaultRerunSetting.RetryStrategyValue.ALL_EXECUTIONS;
        }
        if (!prefs.isDefault("generateCommand.retry.immediately")) {
            boolean shouldRetryImmediately;
            boolean bl = shouldRetryImmediately = this.featureController.canUse(ProductFeature.RERUN_IMMEDIATELY) && prefs.getBoolean("generateCommand.retry.immediately");
            if (shouldRetryImmediately) {
                value = DefaultRerunSetting.RetryStrategyValue.IMMEDIATELY;
            }
        }
        TestSuiteRetryUiPart.RetryControlStateDescription description = new TestSuiteRetryUiPart.RetryControlStateDescription(retryNumber, value);
        this.retryUiProvider.synRetryControlStatesByDescription(description);
    }

    private FileEntity getSelectedTestSuite(String prefSuiteId) throws Exception {
        if (this.isTestSuite(prefSuiteId)) {
            return TestSuiteController.getInstance().getTestSuiteByDisplayId(prefSuiteId, this.project);
        }
        return TestSuiteCollectionController.getInstance().getTestRunByDisplayId(prefSuiteId);
    }

    protected void registerControlModifyListeners() {
        this.btnBrowseTestSuite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    TestSuiteSelectionDialog dialog = new TestSuiteSelectionDialog(GenerateCommandDialog.this.getShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter(new EntityProvider()));
                    dialog.setInput(TreeEntityUtil.getChildren(null, (FolderEntity)FolderController.getInstance().getTestSuiteRoot(GenerateCommandDialog.this.project)));
                    if (dialog.open() != 0) {
                        return;
                    }
                    Object result = dialog.getFirstResult();
                    if (result == null) {
                        return;
                    }
                    ITreeEntity tsTreeEntity = (ITreeEntity)result;
                    FileEntity fileEntity = (FileEntity)tsTreeEntity.getObject();
                    GenerateCommandDialog.this.changeSuiteArtifact(fileEntity);
                    GenerateCommandDialog.this.onRunConfigurationChanged(GenerateCommandDialog.this.runConfigDescription);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
        VerifyListener verifyNumberListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        };
        this.retryUiProvider.registerRetryControlListeners();
        this.txtStatusDelay.addVerifyListener(verifyNumberListener);
        this.txtStatusDelay.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                GenerateCommandDialog.this.correctNumberInput(GenerateCommandDialog.this.txtStatusDelay, defaultStatusDelay);
            }

            public void focusGained(FocusEvent e) {
                GenerateCommandDialog.this.txtStatusDelay.selectAll();
            }
        });
        this.txtTerminateThreshold.addVerifyListener(verifyNumberListener);
        this.txtTerminateThreshold.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                GenerateCommandDialog.this.txtTerminateThreshold.selectAll();
            }
        });
        this.txtTerminateThreshold.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = GenerateCommandDialog.this.txtTerminateThreshold.getText();
                if (text.startsWith(GenerateCommandDialog.ZERO)) {
                    String replace = text.substring(1);
                    GenerateCommandDialog.this.txtTerminateThreshold.setText(replace);
                }
            }
        });
        this.chkTerminateExecution.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GenerateCommandDialog.this.txtTerminateThreshold.setEnabled(GenerateCommandDialog.this.chkTerminateExecution.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnChangeConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunConfigurationSelectionDialog dialog = new RunConfigurationSelectionDialog(GenerateCommandDialog.this.getParentShell(), GenerateCommandDialog.this.runConfigDescription);
                ContextInjectionFactory.inject((Object)((Object)dialog), (IEclipseContext)GenerateCommandDialog.this.context);
                if (dialog.open() != 0) {
                    return;
                }
                GenerateCommandDialog.this.onRunConfigurationChanged(dialog.getSelectedConfiguration());
            }
        });
        this.btnChangeRunConfigurationData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GenerateCommandDialog.this.runConfigDescription == null) {
                    return;
                }
                Map newValue = GenerateCommandDialog.this.testExecutionItem.changeRunConfigurationData(GenerateCommandDialog.this.getShell(), GenerateCommandDialog.this.runConfigDescription.getRunConfigurationData());
                GenerateCommandDialog.this.runConfigDescription.setRunConfigurationData(newValue);
                GenerateCommandDialog.this.onRunConfigurationDataChanged();
            }
        });
        this.btnChangeProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    List profiles = GlobalVariableController.getInstance().getAllGlobalVariableCollections(ProjectController.getInstance().getCurrentProject());
                    ExecutionProfileEntity selectedProfile = profiles.stream().filter(p -> p.getName().equals(GenerateCommandDialog.this.runConfigDescription.getProfileName())).findFirst().orElse(null);
                    ExecutionProfileSelectionDialog dialog = new ExecutionProfileSelectionDialog(GenerateCommandDialog.this.getParentShell(), profiles, selectedProfile);
                    if (dialog.open() != 0) {
                        return;
                    }
                    GenerateCommandDialog.this.runConfigDescription.setProfileName(dialog.getSelectedProfile().getName());
                    GenerateCommandDialog.this.updateExecutionProfileLabel();
                }
                catch (ControllerException ex) {
                    MultiStatusErrorDialog.showErrorDialog((String)ComposerExecutionMessageConstants.PA_MSG_UNABLE_TO_SELECT_EXECUTION_PROFILES, (String)ex.getMessage(), (String)ExceptionsUtil.getMessageForThrowable((Throwable)ex));
                }
            }
        });
    }

    private void onRunConfigurationDataChanged() {
        try {
            this.updateRunConfigurationDataLabel();
        }
        finally {
            this.setGenerateCommandButtonStates();
        }
    }

    private void setGenerateCommandButtonStates() {
        boolean isValidInput = this.isValidInput();
        this.getButton(23).setEnabled(isValidInput);
        this.getButton(22).setEnabled(isValidInput);
        if (this.analyticsSettingStore.isIntegrationEnabled()) {
            this.getButton(25).setEnabled(isValidInput);
        }
    }

    private void onRunConfigurationChanged(RunConfigurationDescription configurationDescription) {
        try {
            this.testExecutionItem = this.getSelectedExecutionItem(configurationDescription);
            if (this.testExecutionItem != null && !this.testExecutionItem.shouldBeDisplayed(this.project)) {
                this.testExecutionItem = null;
            }
            if (this.testExecutionItem == null) {
                this.runConfigDescription = TestExecutionGroupCollector.getInstance().getDefaultConfiguration(ProjectController.getInstance().getCurrentProject());
                this.testExecutionItem = this.getSelectedExecutionItem(this.runConfigDescription);
            } else {
                this.runConfigDescription = configurationDescription;
            }
            this.updateRunConfigurationLabel();
            this.updateRunConfigurationDataLabel();
            this.updateExecutionProfileLabel();
            this.updateConfigurationDataCompositeLayout();
        }
        finally {
            this.setGenerateCommandButtonStates();
        }
    }

    private void updateExecutionProfileLabel() {
        this.lblProfileName.setImage(ImageConstants.IMG_16_PROFILE);
        this.lblProfileName.setText(this.runConfigDescription.getProfileName());
        this.lblProfileName.getParent().layout();
    }

    private void resetLabel(CLabel label, String defautText) {
        label.setImage(null);
        label.setText(defautText);
    }

    private void layoutShell() {
        Shell shell = this.getShell();
        shell.setRedraw(false);
        this.main.layout(true, true);
        this.scrolledComposite.setMinSize(this.main.computeSize(-1, -1));
        shell.setSize(shell.getBounds().width, shell.computeSize((int)-1, (int)-1).y);
        shell.setRedraw(true);
        shell.layout(true);
    }

    private void updateControlLayout(Composite composite, boolean visible) {
        GridData gdConfigurationData = (GridData)composite.getLayoutData();
        gdConfigurationData.exclude = !visible;
        composite.setVisible(visible);
        composite.getParent().pack();
        this.main.layout(true, true);
        this.layoutShell();
    }

    private void updatePlatformLayout() {
        this.updateControlLayout((Composite)this.grpPlatform, this.isTestSuite(this.txtTestSuite.getText()) || this.isTestSuiteCollection(this.txtTestSuite.getText()));
        this.updateControlLayout(this.overrideComposite, this.isTestSuiteCollection(this.txtTestSuite.getText()));
        this.updateConfigurationDataCompositeLayout();
    }

    private void updateConfigurationDataCompositeLayout() {
        this.updateControlLayout(this.configurationDataComposite, this.testExecutionItem != null && this.testExecutionItem.requiresExtraConfiguration() && this.testExecutionItem.shouldBeDisplayed(this.project));
    }

    private void updateRunConfigurationLabel() {
        if (this.testExecutionItem == null) {
            return;
        }
        this.lblRunConfiguration.setText(this.testExecutionItem.getName());
        try {
            String imageUrlAsString = this.testExecutionItem.getImageUrlAsString();
            if (StringUtils.isNotEmpty((CharSequence)imageUrlAsString)) {
                this.lblRunConfiguration.setImage(ImageUtil.loadImage((String)imageUrlAsString));
            } else {
                this.lblRunConfiguration.setImage(null);
            }
        }
        catch (MalformedURLException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.configurationComposite.layout(true, true);
    }

    private void updateRunConfigurationDataLabel() {
        if (this.testExecutionItem == null) {
            return;
        }
        if (this.runConfigDescription == null) {
            this.resetLabel(this.lblConfigurationData, ComposerExecutionMessageConstants.DIA_MSG_CONFIGURATION_IS_REQUIRED);
        }
        String text = (String)StringUtils.defaultIfEmpty((CharSequence)this.testExecutionItem.displayRunConfigurationData(this.runConfigDescription.getRunConfigurationData()), (CharSequence)ComposerExecutionMessageConstants.DIA_MSG_CONFIGURATION_IS_REQUIRED);
        this.lblConfigurationData.setText(text);
        this.configurationDataComposite.layout(true, true);
    }

    private TestExecutionEntryItem getSelectedExecutionItem(RunConfigurationDescription runConfigurationDescription) {
        if (runConfigurationDescription == null) {
            return null;
        }
        String runConfigurationId = runConfigurationDescription.getRunConfigurationId();
        TestExecutionGroup group = TestExecutionGroupCollector.getInstance().getGroup(runConfigurationDescription.getGroupName());
        if (group == null) {
            this.resetLabel(this.lblRunConfiguration, ComposerExecutionMessageConstants.DIA_TITLE_RUN_CONFIG_SELECTION);
            return null;
        }
        Optional executionItemOpt = group.getItem(runConfigurationId);
        if (!executionItemOpt.isPresent()) {
            this.resetLabel(this.lblRunConfiguration, ComposerExecutionMessageConstants.DIA_TITLE_RUN_CONFIG_SELECTION);
            return null;
        }
        return (TestExecutionEntryItem)executionItemOpt.get();
    }

    private void correctNumberInput(Text txtFieldNumber, String defaultValue) {
        String textNumber = txtFieldNumber.getText();
        if (StringUtils.isBlank((CharSequence)textNumber)) {
            txtFieldNumber.setText(defaultValue);
            return;
        }
        if (textNumber.length() > 1 && textNumber.startsWith(ZERO)) {
            txtFieldNumber.setText(Integer.valueOf(textNumber).toString());
        }
    }

    private String projectLocation() {
        return this.project.getFolderLocation();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 12: {
                this.close();
                break;
            }
            case 22: {
                this.generatePropertyPressed();
                break;
            }
            case 23: {
                this.generateCommandPressed();
                break;
            }
            case 25: {
                this.generateTestOpsCICommandPressed();
            }
        }
    }

    private void generatePropertyPressed() {
        try {
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setFilterNames(new String[]{"Property Files (*.properties)"});
            dialog.setFilterExtensions(new String[]{"*.properties"});
            dialog.setFilterPath(this.projectLocation());
            dialog.setFileName(defaultPropertyFileName);
            String result = dialog.open();
            if (result == null) {
                return;
            }
            this.savePropertyFile(result);
        }
        catch (Exception e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)StringConstants.WARN_TITLE, (String)e.getMessage());
        }
    }

    private void generateCommandPressed() {
        try {
            GeneratedCommandDialog generatedCommandDialog = new GeneratedCommandDialog(this.getShell(), this.generateCommand(), this.isInTour, GenerateCommandMode.CONSOLE_COMMAND);
            generatedCommandDialog.open();
            Trackings.trackGenerateCmd();
        }
        catch (Exception e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)StringConstants.WARN_TITLE, (String)e.getMessage());
        }
    }

    private void generateTestOpsCICommandPressed() {
        try {
            GeneratedCommandDialog generatedCommandDialog = new GeneratedCommandDialog(this.getShell(), this.generateTestOpsCICommand(), GenerateCommandMode.TESTOPS_CI_COMMAND);
            generatedCommandDialog.open();
            Trackings.trackGenerateCmd();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openWarning((Shell)this.getShell(), (String)StringConstants.WARN_TITLE, (String)e.getMessage());
        }
    }

    private void savePropertyFile(String fileLocation) throws Exception {
        if (StringUtils.isBlank((CharSequence)fileLocation)) {
            throw new Exception(StringConstants.DIA_MSG_PLS_SPECIFY_FILE_LOCATION);
        }
        try {
            Map<String, String> consoleAgrsMap = this.getUserConsoleAgrsMap(GenerateCommandMode.PROPERTIES_FILE);
            if (consoleAgrsMap.containsKey(this.wrapArgName(ARG_CONFIG))) {
                consoleAgrsMap.remove(this.wrapArgName(ARG_CONFIG));
                consoleAgrsMap.put(ARG_CONFIG, "");
            }
            ExecutionUtil.savePropertiesFile(consoleAgrsMap, (String)fileLocation);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private String generateCommand() throws ExecutionException, DALException {
        Map<String, String> consoleAgrsMap = this.getUserConsoleAgrsMap(GenerateCommandMode.CONSOLE_COMMAND);
        StringBuilder commandBuilder = new StringBuilder();
        switch (Platform.getOS()) {
            case "macosx": {
                commandBuilder.append("./katalonc");
                break;
            }
            case "win32": {
                commandBuilder.append(KATALON_EXECUTABLE_WIN32);
                break;
            }
            default: {
                commandBuilder.append("./katalonc");
            }
        }
        commandBuilder.append(" -noSplash");
        for (String key : consoleAgrsMap.keySet()) {
            commandBuilder.append(" ");
            commandBuilder.append(this.wrapArgName(key));
            String value = consoleAgrsMap.get(key);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            commandBuilder.append("=");
            commandBuilder.append(value);
        }
        return commandBuilder.toString();
    }

    private String generateTestOpsCICommand() throws Exception {
        Map<String, String> consoleAgrsMap = this.getUserConsoleAgrsMap(GenerateCommandMode.TESTOPS_CI_COMMAND);
        StringBuilder commandBuilder = new StringBuilder();
        for (String key : consoleAgrsMap.keySet()) {
            commandBuilder.append(" ");
            commandBuilder.append(this.wrapArgName(key));
            String value = consoleAgrsMap.get(key);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            commandBuilder.append("=");
            commandBuilder.append(value);
        }
        return commandBuilder.toString();
    }

    private Map<String, String> getUserConsoleAgrsMap(GenerateCommandMode generateCommandMode) throws ExecutionException, DALException {
        AnalyticsSettingStore analyticsSettingStore;
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        if (generateCommandMode == GenerateCommandMode.CONSOLE_COMMAND) {
            args.put(ARG_RUN_MODE, "console");
        }
        if (generateCommandMode != GenerateCommandMode.TESTOPS_CI_COMMAND) {
            args.put(ARG_PROJECT_PATH, this.getArgumentValueToSave(this.project.getLocation(), generateCommandMode));
        }
        if (!StringUtils.equals((CharSequence)this.txtStatusDelay.getText(), (CharSequence)defaultStatusDelay)) {
            args.put(ARG_STATUS_DELAY, this.txtStatusDelay.getText());
        }
        if (this.txtTerminateThreshold.getEnabled() && StringUtils.isNotEmpty((CharSequence)this.txtTerminateThreshold.getText())) {
            args.put(ARG_TERMINATE_EXECUTION, this.txtTerminateThreshold.getText());
        }
        String numOfRetry = Integer.toString(this.retryUiProvider.getRetryNumber());
        args.put(ARG_RETRY, numOfRetry);
        if (!StringUtils.equals((CharSequence)numOfRetry, (CharSequence)ZERO)) {
            args.put(ARG_RETRY_STRATEGY, this.getRetryStrategy());
        }
        this.addServerUrlIfOnPremise(args);
        String entityId = this.txtTestSuite.getText();
        boolean isTestSuite = this.isTestSuite(entityId);
        if (isTestSuite) {
            args.put(ARG_TEST_SUITE_PATH, this.getArgumentValueToSave(entityId, generateCommandMode));
            for (Map.Entry entry : ConsoleOptionBuilder.argsMap((RunConfigurationDescription)this.runConfigDescription).entrySet()) {
                args.put((String)entry.getKey(), this.getArgumentValueToSave((String)entry.getValue(), generateCommandMode));
            }
        } else {
            args.put(ARG_TEST_SUITE_COLLECTION_PATH, this.getArgumentValueToSave(entityId, generateCommandMode));
            if (this.chkOverridePlatform.getSelection()) {
                for (Map.Entry entry : ConsoleOptionBuilder.argsMap((RunConfigurationDescription)this.runConfigDescription).entrySet()) {
                    args.put((String)entry.getKey(), this.getArgumentValueToSave((String)entry.getValue(), generateCommandMode));
                }
            }
        }
        args.putAll(this.authenticationProvider.getConsoleArgsMap(generateCommandMode));
        if (generateCommandMode == GenerateCommandMode.TESTOPS_CI_COMMAND && args.containsKey(ARG_API_KEY)) {
            args.remove(ARG_API_KEY);
        }
        if ((analyticsSettingStore = AnalyticsSettingStore.getStore((String)this.currentProjectFullPath)).isIntegrationEnabled()) {
            if (this.cbTestOpsRelease.getSelectionIndex() > 0 && this.releases != null) {
                args.put(ARG_ANALYTICS_RELEASE_ID, String.valueOf(this.releases.get(this.cbTestOpsRelease.getSelectionIndex() - 1).getId()));
            }
            if (this.cbTestOpsProjects != null && this.cbTestOpsProjects.getSelectionIndex() > 0 && this.testOpsProjects != null) {
                args.put(ARG_ANALYTICS_PROJECT_ID, String.valueOf(this.testOpsProjects.get(this.cbTestOpsProjects.getSelectionIndex() - 1).getId()));
            }
        }
        this.putConfigArgs(args);
        String appiumDirectory = this.getAppiumDirectoryForCurrentRunConfig(isTestSuite, entityId, this.chkOverridePlatform.getSelection());
        if (appiumDirectory != null) {
            args.put("appiumDirectory", this.getArgumentValueToSave(appiumDirectory, generateCommandMode));
        }
        return args;
    }

    private boolean usingMobileRunConfigurationId() {
        String runConfigId = this.runConfigDescription.getRunConfigurationId();
        return MobileRunConfigurationUtil.isAndroidPlatform((String)runConfigId) || MobileRunConfigurationUtil.isiOSPlatform((String)runConfigId);
    }

    private boolean testSuiteCollectionContainsTestSuiteWithMobileConfiguration(String tscEntityId) throws DALException {
        String testSuiteCollectionEntityFullPath = this.currentProjectFullPath + File.separator + tscEntityId.replace("/", File.separator) + ".ts";
        TestSuiteCollectionEntity testSuiteCollectionEntity = TestSuiteCollectionController.getInstance().getTestSuiteCollection(testSuiteCollectionEntityFullPath);
        if (testSuiteCollectionEntity == null) {
            return false;
        }
        Predicate<TestSuiteRunConfiguration> containMobileOrCustomMobileRunConfig = testSuiteRunConfig -> {
            String groupName = testSuiteRunConfig.getConfiguration().getGroupName();
            if (groupName.equals("Mobile") || groupName.equals("Custom")) {
                String runConfigId = testSuiteRunConfig.getConfiguration().getRunConfigurationId();
                boolean isMobileRunConfigId = MobileRunConfigurationUtil.isAndroidPlatform((String)runConfigId) || MobileRunConfigurationUtil.isiOSPlatform((String)runConfigId);
                boolean isCustomMobileRunConfigId = MobileRunConfigurationUtil.usingCustomRunConfigurationId((String)runConfigId, (String)this.currentProjectFullPath);
                return (isCustomMobileRunConfigId || isMobileRunConfigId) && testSuiteRunConfig.isRunEnabled();
            }
            return false;
        };
        return testSuiteCollectionEntity.getTestSuiteRunConfigurations().stream().anyMatch(containMobileOrCustomMobileRunConfig);
    }

    private String getAppiumDirectoryForCurrentRunConfig(boolean isTestSuite, String entityId, boolean isPlatformOverriden) throws DALException {
        String resultAppiumDir;
        boolean mobileOrCustomRunConfigId = this.usingMobileRunConfigurationId() || MobileRunConfigurationUtil.usingCustomRunConfigurationId((String)this.runConfigDescription.getRunConfigurationId(), (String)this.currentProjectFullPath);
        String string = resultAppiumDir = mobileOrCustomRunConfigId ? StringUtils.defaultString((String)MobileExecutionUtil.findAppiumDir()) : null;
        if (isTestSuite || isPlatformOverriden) {
            return resultAppiumDir;
        }
        boolean anyTestSuitesEnabled = this.testSuiteCollectionContainsTestSuiteWithMobileConfiguration(entityId);
        return anyTestSuitesEnabled ? StringUtils.defaultString((String)MobileExecutionUtil.findAppiumDir()) : null;
    }

    private void addServerUrlIfOnPremise(Map<String, String> args) {
        String adminServerUrl;
        IDiscoveryController discoveryController = DiscoveryController.getInstance();
        String testOpsUrl = Optional.ofNullable(discoveryController.getServerUrl(ServerType.TESTOPS)).orElse("");
        if (!this.isOnPremiseUrl(testOpsUrl)) {
            return;
        }
        String string = adminServerUrl = discoveryController.isDiscovered() ? testOpsUrl : Optional.ofNullable(discoveryController.getServerUrl(ServerType.ADMIN)).orElse("");
        if (StringUtils.isNotEmpty((CharSequence)adminServerUrl)) {
            args.put(ARG_ADMIN_SERVER_URL, adminServerUrl);
        }
    }

    private boolean isOnPremiseUrl(String urlString) {
        String hostname;
        block3: {
            try {
                URL url = new URL(urlString);
                hostname = url.getHost();
                if (!StringUtils.isBlank((CharSequence)hostname)) break block3;
                return false;
            }
            catch (MalformedURLException e) {
                LoggerSingleton.logError((Throwable)e);
                return false;
            }
        }
        hostname = hostname.toLowerCase();
        return !hostname.endsWith(".katalon.com") && !hostname.endsWith(".katalon.io");
    }

    private String getRetryStrategy() {
        return this.retryUiProvider.getRetryStrategy().getUserFacingValue();
    }

    private void putConfigArgs(Map<String, String> args) {
        boolean shouldPutConfigArgs;
        boolean shouldPutProxyConfigurations = this.chkApplyProxy.getSelection();
        boolean shouldPutAutoUpdateDrivers = this.chkAutoUpdateDrivers.getSelection();
        boolean shouldPutKobitonConfigurations = KobitonPreferencesProvider.isKobitonIntegrationAvailable();
        boolean bl = shouldPutConfigArgs = shouldPutProxyConfigurations || shouldPutKobitonConfigurations || shouldPutAutoUpdateDrivers;
        if (!shouldPutConfigArgs) {
            return;
        }
        args.put(this.wrapArgName(ARG_CONFIG), "");
        if (shouldPutProxyConfigurations) {
            this.putProxyToArgs(args);
        }
        if (shouldPutKobitonConfigurations) {
            this.putKobitonToArgs(args);
        }
        if (shouldPutAutoUpdateDrivers) {
            args.put("webui.autoUpdateDrivers", Boolean.toString(true));
        }
    }

    private void putKobitonToArgs(Map<String, String> args) {
        args.put("kobiton.authentication.serverUrl", this.wrapArgumentValue(KobitonPreferencesProvider.getKobitonServerUrl()));
        args.put("kobiton.authentication.username", this.wrapArgumentValue(KobitonPreferencesProvider.getKobitonUserName()));
        args.put("kobiton.authentication.apiKey", this.wrapArgumentValue(KobitonPreferencesProvider.getKobitonApiKey()));
    }

    private void putProxyToArgs(Map<String, String> args) {
        this.putAuthProxyToArgs(args);
        this.putSystemProxyToArgs(args);
    }

    private void putAuthProxyToArgs(Map<String, String> args) {
        ProxyInformation proxyInfo = ApplicationProxyUtil.getAuthProxyInformation();
        args.put("proxy.auth.option", proxyInfo.getProxyOption());
        ProxyOption proxyOption = ProxyOption.valueOf((String)proxyInfo.getProxyOption());
        if (proxyOption == ProxyOption.MANUAL_CONFIG) {
            args.put("proxy.auth.server.type", proxyInfo.getProxyServerType());
            if (StringUtils.isNotBlank((CharSequence)proxyInfo.getProxyServerAddress())) {
                args.put("proxy.auth.server.address", proxyInfo.getProxyServerAddress());
            }
            if (proxyInfo.getProxyServerPort() >= 0) {
                args.put("proxy.auth.server.port", Integer.toString(proxyInfo.getProxyServerPort()));
            }
            if (StringUtils.isNotBlank((CharSequence)proxyInfo.getUsername())) {
                args.put("proxy.auth.username", proxyInfo.getUsername());
            }
            if (StringUtils.isNotBlank((CharSequence)proxyInfo.getPassword())) {
                args.put("proxy.auth.password", this.encodeSensitiveInfo(proxyInfo.getPassword()));
            }
            if (StringUtils.isNotBlank((CharSequence)proxyInfo.getExceptionList())) {
                args.put("proxy.auth.excludes", this.wrapArgumentValue(proxyInfo.getExceptionList()));
            }
        }
    }

    private void putSystemProxyToArgs(Map<String, String> args) {
        ProxyInformation proxyInfo = ApplicationProxyUtil.getSystemProxyInformation();
        args.put("proxy.system.option", proxyInfo.getProxyOption());
        ProxyOption proxyOption = ProxyOption.valueOf((String)proxyInfo.getProxyOption());
        if (proxyOption == ProxyOption.MANUAL_CONFIG) {
            args.put("proxy.system.server.type", proxyInfo.getProxyServerType());
            if (StringUtils.isNotBlank((CharSequence)proxyInfo.getProxyServerAddress())) {
                args.put("proxy.system.server.address", proxyInfo.getProxyServerAddress());
            }
            if (proxyInfo.getProxyServerPort() >= 0) {
                args.put("proxy.system.server.port", Integer.toString(proxyInfo.getProxyServerPort()));
            }
            if (StringUtils.isNotBlank((CharSequence)proxyInfo.getUsername())) {
                args.put("proxy.system.username", proxyInfo.getUsername());
            }
            if (StringUtils.isNotBlank((CharSequence)proxyInfo.getPassword())) {
                args.put("proxy.system.password", this.encodeSensitiveInfo(proxyInfo.getPassword()));
            }
            if (StringUtils.isNotBlank((CharSequence)proxyInfo.getExceptionList())) {
                args.put("proxy.system.excludes", this.wrapArgumentValue(proxyInfo.getExceptionList()));
            }
        }
        args.put("proxy.system.applyToDesiredCapabilities", Boolean.toString(proxyInfo.isApplyToDesiredCapabilities()));
    }

    private String encodeSensitiveInfo(String sensitiveInfo) {
        if (StringUtils.isBlank((CharSequence)sensitiveInfo)) {
            return "";
        }
        try {
            CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)sensitiveInfo);
            return CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException error) {
            LoggerSingleton.logError((Throwable)error);
            return "";
        }
    }

    private boolean isTestSuite(String id) {
        try {
            return TestSuiteController.getInstance().getTestSuiteByDisplayId(id, ProjectController.getInstance().getCurrentProject()) != null;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    private boolean isTestSuiteCollection(String id) {
        try {
            return TestSuiteCollectionController.getInstance().getTestRunByDisplayId(id) != null;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    private String wrapArgName(String name) {
        return "-" + name;
    }

    private String getArgumentValueToSave(String value, GenerateCommandMode generateCommandMode) {
        if (generateCommandMode == GenerateCommandMode.PROPERTIES_FILE) {
            return value;
        }
        return this.wrapArgumentValue(value);
    }

    private String wrapArgumentValue(String value) {
        return "\"" + value + "\"";
    }

    private boolean isValidInput() {
        String entityId = this.txtTestSuite.getText();
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return false;
        }
        if (!this.isTestSuite(entityId)) {
            return true;
        }
        if (this.runConfigDescription == null || this.testExecutionItem == null || this.runConfigDescription.getRunConfigurationId().isEmpty()) {
            return false;
        }
        if (!this.testExecutionItem.requiresExtraConfiguration()) {
            return true;
        }
        Map runConfigurationData = this.runConfigDescription.getRunConfigurationData();
        return runConfigurationData != null && !runConfigurationData.isEmpty();
    }

    private void changeSuiteArtifact(FileEntity testSuite) {
        if (testSuite == null) {
            return;
        }
        this.txtTestSuite.setText(testSuite.getIdForDisplay());
        if (testSuite instanceof TestSuiteEntity) {
            this.testSuite = (TestSuiteEntity)testSuite;
        }
        this.updatePlatformLayout();
    }

    private static ScopedPreferenceStore getPreference() {
        return PreferenceStoreManager.getPreferenceStore(GenerateCommandDialog.class);
    }

    private void saveUserInput() {
        ScopedPreferenceStore prefs = GenerateCommandDialog.getPreference();
        prefs.setValue("generateCommand.suiteId", this.txtTestSuite.getText());
        prefs.setValue("generateCommand.retry", Integer.toString(this.retryUiProvider.getRetryNumber()));
        prefs.setValue("generateCommand.retry.forFailedExecutions", this.retryUiProvider.getRetryStrategy().equals((Object)DefaultRerunSetting.RetryStrategyValue.FAILED_EXECUTIONS));
        prefs.setValue("generateCommand.retry.forAllExecutions", this.retryUiProvider.getRetryStrategy().equals((Object)DefaultRerunSetting.RetryStrategyValue.ALL_EXECUTIONS));
        prefs.setValue("generateCommand.retry.immediately", this.retryUiProvider.getRetryStrategy().equals((Object)DefaultRerunSetting.RetryStrategyValue.IMMEDIATELY));
        prefs.setValue("generateCommand.applyProxy", this.chkApplyProxy.getSelection());
        prefs.setValue("generateCommand.autoUpdateDrivers", this.chkAutoUpdateDrivers.getSelection());
        prefs.setValue("generateCommand.applyFailedThreshold", this.chkTerminateExecution.getSelection());
        prefs.setValue("generateCommand.overridePlatform", this.chkOverridePlatform.getSelection());
        prefs.setValue("generateCommand.updateStatusTimeInterval", this.txtStatusDelay.getText());
        prefs.setValue("generateCommand.updateFailedThreshold", this.txtTerminateThreshold.getText());
        prefs.setValue("generateCommand.runConfigurationDescription", this.runConfigDescription != null ? JsonUtil.toJson((Object)this.runConfigDescription) : "");
        try {
            prefs.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void getConfigurationAnalytics() {
        if (this.analyticsSettingStore.isIntegrationEnabled()) {
            this.getTestOpsProjects();
        }
    }

    private void fetchTestOpsProject() throws AnalyticsApiException {
        this.testOpsProjects = this.testOpsController.getProjects();
    }

    private void getTestOpsProjects() {
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                this.fetchTestOpsProject();
                UISynchronizeService.asyncExec(() -> {
                    if (this.cbTestOpsProjects != null && !this.cbTestOpsProjects.isDisposed()) {
                        this.setDefaultTestOpsProject();
                        this.testOpsProjects.forEach(project -> {
                            this.cbTestOpsProjects.add(project.getName());
                            this.cbTestOpsProjects.notifyListeners(13, new Event());
                        });
                    }
                });
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                UISynchronizeService.asyncExec(() -> {
                    this.setDefaultTestOpsProject();
                    this.cbTestOpsProjects.notifyListeners(13, new Event());
                });
            }
        });
    }

    private void setDefaultTestOpsProject() {
        if (this.cbTestOpsProjects != null && !this.cbTestOpsProjects.isDisposed()) {
            this.cbTestOpsProjects.removeAll();
            this.cbTestOpsProjects.add(StringConstants.DIA_CB_DEFAULT_PROJECT);
            this.cbTestOpsProjects.select(0);
            this.cbTestOpsProjects.setEnabled(true);
        }
    }

    private void getRelases() {
        int selectedProjectIndex = this.cbTestOpsProjects != null ? this.cbTestOpsProjects.getSelectionIndex() : 0;
        Thread getReleaseThread = new Thread(() -> {
            try {
                AnalyticsProject project = this.analyticsSettingStore.getProject();
                if (project != null) {
                    long projectId = selectedProjectIndex == 0 ? project.getId() : this.testOpsProjects.get(selectedProjectIndex - 1).getId();
                    this.releases = this.testOpsController.getReleases(Long.valueOf(projectId));
                    UISynchronizeService.asyncExec(() -> {
                        if (this.cbTestOpsRelease != null && !this.cbTestOpsRelease.isDisposed()) {
                            this.setDefaultTestOpsRelease();
                            this.releases.forEach(release -> this.cbTestOpsRelease.add(String.format("%s (id: %s)", release.getName(), release.getId())));
                        }
                    });
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                UISynchronizeService.asyncExec(() -> this.setDefaultTestOpsRelease());
            }
        });
        getReleaseThread.start();
    }

    private void setDefaultTestOpsRelease() {
        if (this.cbTestOpsRelease != null && !this.cbTestOpsRelease.isDisposed()) {
            this.cbTestOpsRelease.removeAll();
            this.cbTestOpsRelease.add(StringConstants.DIA_CB_DEFAULT_LASTEST_RELEASE);
            this.cbTestOpsRelease.select(0);
            this.cbTestOpsRelease.setEnabled(true);
        }
    }

    private RunConfigurationDescription getStoredConfigurationDescription() {
        ScopedPreferenceStore prefs = GenerateCommandDialog.getPreference();
        String runConfigAsJson = prefs.getString("generateCommand.runConfigurationDescription");
        if (StringUtils.isEmpty((CharSequence)runConfigAsJson)) {
            return null;
        }
        return (RunConfigurationDescription)JsonUtil.fromJson((String)runConfigAsJson, RunConfigurationDescription.class);
    }

    public boolean close() {
        if (this.isInTour) {
            return false;
        }
        this.saveUserInput();
        return super.close();
    }

    TestSuiteEntity getTestSuite() {
        return this.testSuite;
    }

    private void registerEvent() {
        if (this.cbTestOpsProjects != null) {
            this.cbTestOpsProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GenerateCommandDialog.this.cbTestOpsRelease.setEnabled(false);
                    GenerateCommandDialog.this.cbTestOpsRelease.removeAll();
                    GenerateCommandDialog.this.cbTestOpsRelease.add(StringConstants.DIA_CB_TESTOPS_LOADING);
                    GenerateCommandDialog.this.cbTestOpsRelease.select(0);
                    GenerateCommandDialog.this.getRelases();
                }
            });
        } else {
            this.getRelases();
        }
    }

    public void changeTSName(String tsName) {
        try {
            Object testSuiteId = tsName;
            if (!tsName.startsWith(GlobalMessageConstants.ROOT_FOLDER_NAME_TEST_SUITE)) {
                testSuiteId = GlobalMessageConstants.ROOT_FOLDER_NAME_TEST_SUITE + "/" + tsName;
            }
            this.changeSuiteArtifact(this.getSelectedTestSuite((String)testSuiteId));
            this.setGenerateCommandButtonStates();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void setInTour(boolean isInTour) {
        this.isInTour = isInTour;
    }

    public static enum GenerateCommandMode {
        CONSOLE_COMMAND,
        PROPERTIES_FILE,
        TESTOPS_CI_COMMAND;

    }

    private class GeneratedCommandDialog
    extends Dialog {
        private static final int COPY_TO_CLIPBOARD_ID = 24;
        private String command;
        private Text txtCommand;
        private GenerateCommandMode commandMode;
        private boolean isInTour;

        public GeneratedCommandDialog(Shell parentShell, String command, GenerateCommandMode commandMode) {
            super(parentShell);
            this.isInTour = false;
            this.command = command;
            this.commandMode = commandMode;
            this.isInTour = false;
        }

        public GeneratedCommandDialog(Shell parentShell, String command, boolean isInTour, GenerateCommandMode commandMode) {
            super(parentShell);
            this.isInTour = false;
            this.command = command;
            this.commandMode = commandMode;
            this.isInTour = isInTour;
        }

        protected Control createDialogArea(Composite parent) {
            Composite main = (Composite)super.createDialogArea(parent);
            GridLayout glMain = (GridLayout)main.getLayout();
            glMain.numColumns = 1;
            GridData gdMain = (GridData)main.getLayoutData();
            gdMain.widthHint = 500;
            Label message = new Label(main, 0);
            message.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            message.setText(StringConstants.DIA_LBL_GENERATED_COMMAND_MESSAGE);
            this.txtCommand = new Text(main, 2632);
            GridData gdCommand = new GridData(4, 4, true, true);
            gdCommand.minimumHeight = 100;
            this.txtCommand.setLayoutData((Object)gdCommand);
            this.txtCommand.setText(this.getCommand());
            if (this.commandMode != GenerateCommandMode.TESTOPS_CI_COMMAND) {
                GenerateCommandDialog.this.authenticationProvider.createNoticesComposite(main);
            }
            return main;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 24, StringConstants.DIA_BTN_COPY_TO_CLIPBOARD, true);
            this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 12: {
                    this.close();
                    break;
                }
                case 24: {
                    this.txtCommand.selectAll();
                    this.txtCommand.copy();
                }
            }
        }

        protected boolean isResizable() {
            return true;
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(StringConstants.DIA_TITLE_GENERATED_COMMAND);
            super.configureShell(newShell);
        }

        public String getCommand() {
            if (this.command == null) {
                return StringConstants.EMPTY;
            }
            return this.command;
        }

        public boolean close() {
            if (this.isInTour) {
                return false;
            }
            return super.close();
        }
    }
}

