/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.menu;

import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.menu.ExecutionHandledMenuItem;
import com.kms.katalon.composer.execution.menu.ExistingExecutionHandledMenuItem;
import com.kms.katalon.constants.helper.ConstantsHelper;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;

public abstract class AbstractExecutionMenuContribution {
    private static final String EXISTING_EXECUTION_COMMAND_ID = "com.kms.katalon.composer.execution.command.existing";
    private static final int DEFAULT_MAX_TITLE_WIDTH = 20;
    private static final List<WebUIDriverType> supportedDrivers = List.of(WebUIDriverType.CHROME_DRIVER, WebUIDriverType.HEADLESS_DRIVER, WebUIDriverType.EDGE_CHROMIUM_DRIVER, WebUIDriverType.FIREFOX_DRIVER, WebUIDriverType.FIREFOX_HEADLESS_DRIVER, WebUIDriverType.SAFARI_DRIVER);
    @Inject
    protected ECommandService commandService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        List existingDrivers = ExecutionSessionSocketServer.getInstance().getAllAvailableExecutionSessionByDriverTypeName(this.getDriverTypeName());
        WebUIDriverType driverType = WebUIDriverType.fromStringValue((String)this.getDriverTypeName());
        if (driverType == null || !supportedDrivers.contains(driverType) || existingDrivers.isEmpty()) {
            this.aboutToShowDefault(menuItems);
        } else {
            this.aboutToShowWithExisting(menuItems, existingDrivers);
        }
    }

    protected void aboutToShowWithExisting(List<MMenuElement> menuItems, List<ExecutionSession> exisingDrivers) {
        MMenu executionMenu = this.createExecutionMenu();
        ExecutionHandledMenuItem defaultMenuItem = this.createDefaultMenuItem();
        defaultMenuItem.setLabel(ComposerExecutionMessageConstants.LBL_EXECUTION_NEW_SESSION);
        List executionMenuItems = executionMenu.getChildren();
        executionMenuItems.add(new ExecutionHandledMenuItem((MHandledMenuItem)defaultMenuItem));
        executionMenuItems.add(MMenuFactory.INSTANCE.createMenuSeparator());
        HashMap<String, Integer> labelMap = new HashMap<String, Integer>();
        for (ExecutionSession executionSession : exisingDrivers) {
            Map<String, Object> parameters = this.createParametersForExistingSession(executionSession);
            ParameterizedCommand executionCommand = this.commandService.createCommand(this.getExistingExecutionCommandId(), parameters);
            Object abbreviatedLabel = this.getLabelForExecutionSession(executionSession);
            if (labelMap.containsKey(abbreviatedLabel)) {
                Integer numberOfInstances = (Integer)labelMap.get(abbreviatedLabel) + 1;
                labelMap.put((String)abbreviatedLabel, numberOfInstances);
                abbreviatedLabel = (String)abbreviatedLabel + " (" + String.valueOf(numberOfInstances) + ")";
            } else {
                labelMap.put((String)abbreviatedLabel, 1);
            }
            MHandledMenuItem executionMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)executionCommand, (String)abbreviatedLabel, (String)ConstantsHelper.getApplicationURI());
            executionMenuItem.setIconURI(this.getIconUri());
            executionMenuItem.setTooltip(null);
            executionMenuItems.add(new ExistingExecutionHandledMenuItem(executionMenuItem));
        }
        menuItems.add((MMenuElement)executionMenu);
    }

    protected MMenu createExecutionMenu() {
        Object menuLabel = this.getMenuLabel();
        String defaultItemLabel = ExecutionDefaultSettingStore.getStore().getExecutionConfiguration();
        if (defaultItemLabel.equals(menuLabel)) {
            menuLabel = (String)menuLabel + " (default)";
        }
        MMenu executionMenu = MenuFactory.createPopupMenu((String)menuLabel, (String)ConstantsHelper.getApplicationURI());
        executionMenu.setIconURI(this.getIconUri());
        executionMenu.setTooltip(null);
        return executionMenu;
    }

    protected String getLabelForExecutionSession(ExecutionSession executionSession) {
        String executionTitle = executionSession.getTitle();
        if (executionTitle.isEmpty()) {
            executionTitle = ComposerExecutionMessageConstants.LBL_EXECUTION_EXISTING_SESSION_BLANK_TITLE;
        }
        return StringUtils.abbreviate((String)executionTitle, (int)20);
    }

    protected String getExistingExecutionCommandId() {
        return EXISTING_EXECUTION_COMMAND_ID;
    }

    public void aboutToShowDefault(List<MMenuElement> items) {
        items.add((MMenuElement)this.createDefaultMenuItem());
    }

    protected LaunchMode getLaunchMode() {
        return LaunchMode.RUN;
    }

    private Map<String, Object> createParametersForExistingSession(ExecutionSession executionSession) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("com.kms.katalon.composer.execution.existingSession.sessionId", executionSession.getSessionId());
        parameters.put("com.kms.katalon.composer.execution.existingSession.serverUrl", executionSession.getRemoteUrl());
        parameters.put("com.kms.katalon.composer.execution.existingSession.driverName", executionSession.getDriverTypeName());
        parameters.put("com.kms.katalon.composer.execution.existingSession.webSocketUrl", executionSession.getWebSocketUrl());
        parameters.put("com.kms.katalon.composer.execution.runMode", this.getLaunchMode().toString());
        return parameters;
    }

    public ExecutionHandledMenuItem createDefaultMenuItem() {
        ParameterizedCommand executionCommand = this.commandService.createCommand(this.getCommandId(), this.getParametersForCommand());
        MHandledMenuItem executionMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)executionCommand, (String)this.getMenuLabel(), (String)ConstantsHelper.getApplicationURI());
        executionMenuItem.setTooltip(null);
        executionMenuItem.setIconURI(this.getIconUri());
        return new ExecutionHandledMenuItem(executionMenuItem);
    }

    protected Map<String, Object> getParametersForCommand() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("com.kms.katalon.composer.execution.runMode", this.getLaunchMode().toString());
        return parameters;
    }

    protected abstract String getIconUri();

    protected abstract String getDriverTypeName();

    protected abstract String getCommandId();

    protected abstract String getMenuLabel();
}

