/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.part;

import com.kms.katalon.composer.components.impl.control.GifCLabel;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.execution.constants.ImageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.launcher.IDEObservableLauncher;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class LauncherItem
extends Composite {
    private static final Image IMG_DONE = ImageConstants.IMG_16_DONE;
    private static final Image IMG_WATCH = ImageConstants.IMG_16_WATCH;
    private static final Image IMG_STOP = ImageConstants.IMG_16_STOP;
    private static final Image IMG_WAIT = ImageConstants.IMG_16_WAIT;
    private static final Image IMG_TERMINATE = ImageConstants.IMG_16_TERMINATE;
    private static final Image IMG_PAUSE = ImageConstants.IMG_16_PAUSE;
    private static final Image IMG_PLAY = ImageConstants.IMG_16_PLAY;
    private static final Image IMG_ERROR = ImageConstants.IMG_16_JOBVIEW_ERROR;
    private static final Image IMG_FAIL = ImageConstants.IMG_16_JOBVIEW_FAILED;
    private static final Image IMG_SKIP = ImageConstants.IMG_16_JOBVIEW_SKIPPED;
    private static final String CONTROL_ID = "launcherId";
    private Label watchingIcon;
    private Label progressLabel;
    private ProgressBar progressBar;
    private IDEObservableLauncher launcher;

    public LauncherItem(Composite parent, IDEObservableLauncher launcher) {
        this(parent, launcher, 0);
    }

    public LauncherItem(Composite parent, IDEObservableLauncher launcher, int style) {
        super(parent, style | 0x800);
        this.launcher = launcher;
        this.create(this, launcher);
        this.sync();
    }

    public String getLauncherId() {
        return ComponentDataUtil.getText((Widget)this, (String)CONTROL_ID);
    }

    public void sync() {
        if (this.launcher == null) {
            return;
        }
        ILauncherResult result = this.launcher.getResult();
        if (result != null) {
            this.setProgress(result.getExecutedTestCases(), result.getTotalTestCases());
        }
        if (!ControlUtil.isDisposed((Widget)this.watchingIcon)) {
            this.watchingIcon.setVisible(this.launcher.isObserved());
        }
    }

    public void setProgress(int progress, int total) {
        if (!ControlUtil.isDisposed((Widget)this.progressLabel)) {
            this.progressLabel.setText(MessageFormat.format("{0}/{1}", progress, total));
            this.progressLabel.pack();
        }
        if (!ControlUtil.isDisposed((Widget)this.progressBar)) {
            this.progressBar.setSelection(progress);
            this.progressBar.setMaximum(total);
        }
    }

    protected void create(Composite container, IDEObservableLauncher launcher) {
        boolean shouldShowProgress;
        ComponentBuilder.fromGrid((Composite)container).gridLayout(3).fillHorizontal().build();
        container.setData(CONTROL_ID, (Object)launcher.getId());
        container.setBackground(ColorUtil.getCompositeBackgroundColor());
        container.setBackgroundMode(2);
        this.watchingIcon = (Label)ComponentBuilder.label((Composite)container).image(IMG_WATCH).width(30).build();
        this.createLauncherIdComposite(container, launcher);
        this.progressLabel = (Label)ComponentBuilder.label((Composite)container, (int)64).right().build();
        if (launcher.getStatus() == LauncherStatus.RUNNING || launcher.getStatus() == LauncherStatus.SENDING_REPORT || launcher.getStatus() == LauncherStatus.PREPARE_REPORT || launcher.getStatus() == LauncherStatus.UPLOAD_REPORT || launcher.getStatus() == LauncherStatus.PREPARE_INTEGRATION_REPORT) {
            GifCLabel lblLauncherStatus = (GifCLabel)ComponentBuilder.from((Widget)new GifCLabel(container, 0)).left().width(30).build();
            try {
                lblLauncherStatus.setGifImage(ImageConstants.URL_16_LOADING.openStream());
            }
            catch (IOException error) {
                LogUtil.logError((Throwable)error);
            }
        } else {
            ComponentBuilder.label((Composite)container).image(this.getLauncherStatusImage(launcher)).width(30).left().build();
        }
        Label lblStatus = (Label)ComponentBuilder.label((Composite)container).colSpan(2).fillHorizontal().build();
        String displayMessage = launcher.getDisplayMessage();
        String doneMessage = LauncherStatus.DONE.toString();
        if (displayMessage.indexOf(doneMessage) == 1) {
            switch (this.getExecutionStatus(launcher)) {
                case ERROR: {
                    displayMessage = displayMessage.replaceFirst(doneMessage, "Error");
                    break;
                }
                case FAILED: {
                    displayMessage = displayMessage.replaceFirst(doneMessage, "Failed");
                    break;
                }
                case PASSED: {
                    displayMessage = displayMessage.replaceFirst(doneMessage, "Passed");
                    break;
                }
                case SKIPPED: {
                    displayMessage = displayMessage.replaceFirst(doneMessage, "Skipped");
                    break;
                }
            }
        }
        lblStatus.setText(displayMessage);
        boolean bl = shouldShowProgress = launcher.getStatus() == LauncherStatus.RUNNING || launcher.getStatus() == LauncherStatus.WAITING || launcher.getStatus() == LauncherStatus.SUSPENDED;
        if (shouldShowProgress) {
            ComponentBuilder.label((Composite)container).build();
            this.progressBar = (ProgressBar)ComponentBuilder.from((Widget)new ProgressBar(container, 67584)).height(12).fillHorizontal().build();
            this.progressBar.setMinimum(0);
            if (launcher.getStatus() == LauncherStatus.SUSPENDED) {
                this.progressBar.setState(4);
            }
            Composite compositeLauncherToolbar = (Composite)ComponentBuilder.gridContainer((Composite)container).right().build();
            ToolBar toolBar = (ToolBar)ComponentBuilder.toolBar((Composite)compositeLauncherToolbar, (int)0x820000).color(ColorUtil.getToolBarForegroundColor()).build();
            boolean isComplete = launcher.getStatus() == LauncherStatus.TERMINATED || launcher.getStatus() == LauncherStatus.DONE;
            ToolItem stopButton = (ToolItem)ComponentBuilder.toolItem((Composite)toolBar).image(IMG_STOP).onClick(event -> {
                launcher.stop();
                ComponentEventUtil.triggerSelectionEvent((Widget)container);
            }).build();
            stopButton.setEnabled(!isComplete);
            boolean isRunMode = launcher.getMode() == LaunchMode.RUN;
            ToolItem pauseButton = (ToolItem)ComponentBuilder.toolItem((Composite)toolBar).onClick(event -> {
                if (launcher.getStatus() == LauncherStatus.RUNNING) {
                    launcher.suspend();
                } else {
                    launcher.resume();
                }
                ComponentEventUtil.triggerSelectionEvent((Widget)container);
            }).build();
            pauseButton.setEnabled(!isRunMode);
            if (launcher.getStatus() == LauncherStatus.SUSPENDED) {
                pauseButton.setImage(IMG_PLAY);
                pauseButton.setToolTipText(StringConstants.PA_LOG_RESUME);
            } else if (launcher.getStatus() == LauncherStatus.RUNNING) {
                pauseButton.setImage(IMG_PAUSE);
                pauseButton.setToolTipText(StringConstants.PA_LOG_PAUSE);
            }
        } else {
            ComponentUtil.setMarginBottom((Composite)container, (int)5);
        }
        container.setCursor(new Cursor((Device)Display.getCurrent(), 21));
    }

    private void createLauncherIdComposite(Composite parent, IDEObservableLauncher launcher) {
        boolean isDebugMode = launcher.getMode() == LaunchMode.DEBUG;
        Composite launcherIdComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)(isDebugMode ? 2 : 1)).fillHorizontal().build();
        if (isDebugMode) {
            ComponentBuilder.label((Composite)launcherIdComposite).image(ImageConstants.IMG_16_DEBUG).build();
        }
        ComponentBuilder.label((Composite)launcherIdComposite, (int)64).text(launcher.getName()).bold().fillHorizontal().build();
    }

    private TestStatus.TestStatusValue getExecutionStatus(IDEObservableLauncher launcher) {
        TestStatus.TestStatusValue status = TestStatus.TestStatusValue.INCOMPLETE;
        ILauncherResult result = launcher.getResult();
        if (result.getNumErrors() > 0) {
            status = TestStatus.TestStatusValue.ERROR;
        } else if (result.getNumFailures() > 0) {
            status = TestStatus.TestStatusValue.FAILED;
        } else if (result.getNumPasses() > 0) {
            status = TestStatus.TestStatusValue.PASSED;
        } else if (result.getNumSkips() > 0) {
            status = TestStatus.TestStatusValue.SKIPPED;
        }
        return status;
    }

    private Image getLauncherStatusImage(IDEObservableLauncher launcher) {
        switch (launcher.getStatus()) {
            case DONE: {
                switch (this.getExecutionStatus(launcher)) {
                    case ERROR: {
                        return IMG_ERROR;
                    }
                    case FAILED: {
                        return IMG_FAIL;
                    }
                    case PASSED: {
                        return IMG_DONE;
                    }
                    case SKIPPED: {
                        return IMG_SKIP;
                    }
                }
                return null;
            }
            case SUSPENDED: {
                return null;
            }
            case TERMINATED: {
                return IMG_TERMINATE;
            }
            case WAITING: {
                return IMG_WAIT;
            }
        }
        return null;
    }
}

