/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration.impl;

import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WebUIExecutionSetting
extends DefaultExecutionSetting {
    @Inject
    private IFeatureController featureController;

    public WebUIExecutionSetting() {
        this.setTimeout(WebUiExecutionSettingStore.getStore().safelyGetElementTimeout());
    }

    public Map<String, Object> getGeneralProperties() {
        Map generalProperties = super.getGeneralProperties();
        generalProperties.putAll(this.getWebUiExecutionProperties());
        return generalProperties;
    }

    public WebUiExecutionSettingStore getWebUiStore() {
        return new WebUiExecutionSettingStore(this.getCurrentProject());
    }

    private Map<String, Object> getWebUiExecutionProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        WebUiExecutionSettingStore webUiSettingStore = this.getWebUiStore();
        try {
            props.put("timeout", webUiSettingStore.getElementTimeout());
            props.put("enablePageLoadTimeout", webUiSettingStore.getEnablePageLoadTimeout());
            props.put("defaultPageLoadTimeout", webUiSettingStore.getPageLoadTimeout());
            props.put("actionDelay", webUiSettingStore.getActionDelay());
            props.put("useActionDelayInSecond", (Object)webUiSettingStore.getUseDelayActionTimeUnit());
            props.put("ignorePageLoadTimeoutException", webUiSettingStore.getIgnorePageLoadTimeout());
            props.put("excludeKeywords", webUiSettingStore.getExcludeKeywordList());
            props.put("methodsPriorityOrder", webUiSettingStore.getMethodsPriorityOrder());
            props.put("selfHealingEnabled", webUiSettingStore.getSelfHealingEnabled(this.canUseSelfHealing()));
            props.put("aiSelfHealingEnabled", this.canUseSelfHealing() && webUiSettingStore.getAISelfHealingEnabled() != false);
            props.put("aiSelfHealingInputSources", webUiSettingStore.getAISelfHealingInputSources());
            props.put("timeCapsuleEnabled", webUiSettingStore.getTimeCapsuleEnabled());
            props.put("flutterAppTestingEnabled", webUiSettingStore.isEnableFlutterAppTesting());
            props.put("canvasTextExtractionEnabled", webUiSettingStore.isEnableCanvasTextExtraction());
            props.put("closedShadowDOMEnabled", webUiSettingStore.isEnableClosedShadowDOMTesting());
            props.put("xpathsPriority", webUiSettingStore.getCapturedTestObjectXpathLocators());
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return props;
    }

    private boolean canUseSelfHealing() {
        return this.featureController.canUse(ProductFeature.SELF_HEALING);
    }
}

