/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class CustomProjectTrackerPreferenceHelper {
    private static final String PREFIX = "BranchProjectTracker_";
    private static final String KEY_PROJECTS = "projects";
    private static final String KEY_PROJECT = "project";

    public static void saveToPreferences(Repository repo, String branch, List<String> projects) {
        XMLMemento preferencesMemento = CustomProjectTrackerPreferenceHelper.createXMLMemento(projects);
        String preferenceKey = CustomProjectTrackerPreferenceHelper.getPreferenceKey(repo, branch);
        CustomProjectTrackerPreferenceHelper.saveToPreferenceStore(preferenceKey, preferencesMemento);
    }

    private static XMLMemento createXMLMemento(List<String> projectPaths) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)KEY_PROJECTS);
        projectPaths.forEach(path -> {
            IMemento child = memento.createChild(KEY_PROJECT);
            child.putTextData(path);
        });
        return memento;
    }

    public static String getPreferenceKey(Repository repo, String branch) {
        return "BranchProjectTracker__" + repo.getDirectory().getAbsolutePath() + "_" + branch;
    }

    private static void saveToPreferenceStore(String key, XMLMemento content) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        StringWriter writer = new StringWriter();
        try {
            content.save((Writer)writer);
            store.setValue(key, writer.toString());
        }
        catch (IOException e) {
            Activator.logError((String)"Error writing branch-project associations", (Throwable)e);
        }
    }

    public static List<String> restoreFromPreferences(Repository repo, String branch) {
        XMLMemento memento;
        String key = CustomProjectTrackerPreferenceHelper.getPreferenceKey(repo, branch);
        String value = Activator.getDefault().getPreferenceStore().getString(key);
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            memento = XMLMemento.createReadRoot((Reader)new StringReader(value));
        }
        catch (WorkbenchException e) {
            Activator.logError((String)"Error reading branch-project associations", (Throwable)e);
            return Collections.emptyList();
        }
        IMemento[] children = memento.getChildren(KEY_PROJECT);
        if (children.length == 0) {
            return Collections.emptyList();
        }
        List<String> projectPaths = Stream.of(children).map(IMemento::getTextData).filter(x -> !StringUtils.isEmptyOrNull((String)x)).collect(Collectors.toList());
        return projectPaths;
    }
}

