/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.utils;

import java.io.File;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

public class Protocol {
    private static final TreeMap<String, Protocol> PROTOCOLS = new TreeMap();
    public static final Protocol GIT = new Protocol("git", true, true, false);
    public static final Protocol SSH = new Protocol("ssh", true, true, true){

        @Override
        public boolean handles(URIish uri) {
            if (!uri.isRemote()) {
                return false;
            }
            String scheme = uri.getScheme();
            if (StringUtils.equals((CharSequence)this.getDefaultScheme(), (CharSequence)scheme)) {
                return true;
            }
            if (StringUtils.equalsAny((CharSequence)scheme, (CharSequence[])new CharSequence[]{"ssh+git", "git+ssh"})) {
                return true;
            }
            return StringUtils.isBlank((CharSequence)scheme) && StringUtils.isNotBlank((CharSequence)uri.getHost()) && StringUtils.isNotBlank((CharSequence)uri.getPath());
        }
    };
    public static final Protocol SFTP = new Protocol("sftp", true, true, true);
    public static final Protocol HTTP = new Protocol("http", true, true, true);
    public static final Protocol HTTPS = new Protocol("https", true, true, true);
    public static final Protocol FTP = new Protocol("ftp", true, true, true);
    public static final Protocol FILE = new Protocol("file", false, false, false){

        @Override
        public boolean handles(URIish uri) {
            if (StringUtils.equals((CharSequence)this.getDefaultScheme(), (CharSequence)uri.getScheme())) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)uri.getHost()) || uri.getPort() > 0 || StringUtils.isNotBlank((CharSequence)uri.getUser()) || StringUtils.isNotBlank((CharSequence)uri.getPass()) || StringUtils.isBlank((CharSequence)uri.getPath())) {
                return false;
            }
            if (StringUtils.isBlank((CharSequence)uri.getScheme())) {
                return FS.DETECTED.resolve(new File("."), uri.getPath()).isDirectory();
            }
            return false;
        }
    };
    private final String defaultScheme;
    private final boolean hasHost;
    private final boolean hasPort;
    private final boolean canAuthenticate;

    private Protocol(String defaultScheme, boolean hasHost, boolean hasPort, boolean canAuthenticate) {
        this.defaultScheme = defaultScheme;
        this.hasHost = hasHost;
        this.hasPort = hasPort;
        this.canAuthenticate = canAuthenticate;
        PROTOCOLS.put(defaultScheme, this);
    }

    public boolean handles(URIish uri) {
        return StringUtils.equals((CharSequence)this.getDefaultScheme(), (CharSequence)uri.getScheme());
    }

    public String getDefaultScheme() {
        return this.defaultScheme;
    }

    public boolean hasHost() {
        return this.hasHost;
    }

    public boolean hasPort() {
        return this.hasPort;
    }

    public boolean canAuthenticate() {
        return this.canAuthenticate;
    }

    public static Protocol[] values() {
        return PROTOCOLS.values().toArray(new Protocol[PROTOCOLS.size()]);
    }

    public static Protocol fromDefaultScheme(String scheme) {
        return PROTOCOLS.get(scheme);
    }

    public static Protocol fromUri(URIish uri) {
        for (Protocol p : PROTOCOLS.values()) {
            if (!p.handles(uri)) continue;
            return p;
        }
        return null;
    }
}

