/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.wizards;

import com.kms.katalon.composer.integration.git.constants.GitStringConstants;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefContentAssistProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CustomPushBranchPage
extends WizardPage {
    private final Repository repository;
    private final Ref ref;
    private RemoteConfig remoteConfig;
    private List<RemoteConfig> remoteConfigs;
    private RefContentAssistProvider assist;
    private BranchConfig.BranchRebaseMode upstreamConfig = BranchConfig.BranchRebaseMode.NONE;
    private boolean forceUpdateSelected = false;
    private Set<Resource> disposables = new HashSet<Resource>();
    private ComboViewer remoteBranchNameComboViewer;

    public CustomPushBranchPage(Repository repository, ObjectId commitToPush, Ref ref) {
        super(UIText.PushBranchPage_PageName);
        this.setTitle(UIText.PushBranchPage_PageTitle);
        this.setMessage(GitStringConstants.MSG_PUSH_BRANCH_DIALOG);
        this.repository = repository;
        this.ref = ref;
    }

    RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    String getFullRemoteReference() {
        String branchName = this.remoteBranchNameComboViewer.getCombo().getText();
        if (!branchName.startsWith("refs/")) {
            return "refs/heads/" + branchName;
        }
        return branchName;
    }

    boolean isConfigureUpstreamSelected() {
        return this.upstreamConfig != BranchConfig.BranchRebaseMode.NONE;
    }

    boolean isRebaseSelected() {
        return this.upstreamConfig == BranchConfig.BranchRebaseMode.REBASE;
    }

    boolean isForceUpdateSelected() {
        return this.forceUpdateSelected;
    }

    public void createControl(Composite parent) {
        try {
            this.remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig());
            Collections.sort(this.remoteConfigs, new Comparator<RemoteConfig>(){

                @Override
                public int compare(RemoteConfig first, RemoteConfig second) {
                    return String.CASE_INSENSITIVE_ORDER.compare(first.getName(), second.getName());
                }
            });
        }
        catch (URISyntaxException e) {
            this.remoteConfigs = new ArrayList<RemoteConfig>();
            this.handleError(e);
        }
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Composite inputPanel = new Composite(main, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)inputPanel);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(inputPanel);
        Composite sourceComposite = new Composite(inputPanel, 0);
        sourceComposite.setLayoutData((Object)GridDataFactory.fillDefaults().indent(UIUtils.getControlIndent(), 0).create());
        RowLayout rowLayout = RowLayoutFactory.fillDefaults().create();
        rowLayout.center = true;
        sourceComposite.setLayout((Layout)rowLayout);
        Label sourceLabel = new Label(sourceComposite, 0);
        sourceLabel.setText(GitStringConstants.LBL_CURRENT_BRANCH_NAME);
        if (this.ref != null) {
            Label localBranchLabel = new Label(sourceComposite, 0);
            localBranchLabel.setText(Repository.shortenRefName((String)this.ref.getName()));
            Image branchIcon = UIIcons.BRANCH.createImage();
            this.disposables.add((Resource)branchIcon);
            Label branchIconLabel = new Label(sourceComposite, 0);
            branchIconLabel.setLayoutData((Object)new RowData(branchIcon.getBounds().width, branchIcon.getBounds().height));
            branchIconLabel.setImage(branchIcon);
        }
        Composite remoteGroup = new Composite(inputPanel, 0);
        remoteGroup.setLayoutData((Object)GridDataFactory.fillDefaults().indent(UIUtils.getControlIndent(), 0).create());
        remoteGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        Label branchNameLabel = new Label(remoteGroup, 0);
        branchNameLabel.setText(GitStringConstants.LBL_REMOTE_BRANCH_NAME);
        this.remoteBranchNameComboViewer = new ComboViewer(remoteGroup, 4);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(300, -1).applyTo(this.remoteBranchNameComboViewer.getControl());
        this.remoteBranchNameComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.remoteBranchNameComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof Ref) {
                    return Repository.shortenRefName((String)((Ref)element).getName());
                }
                return super.getText(element);
            }
        });
        this.remoteBranchNameComboViewer.getCombo().setText(this.getSuggestedBranchName());
        this.setControl((Control)main);
        this.checkPage();
        this.remoteBranchNameComboViewer.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomPushBranchPage.this.checkPage();
            }
        });
    }

    private void checkPage() {
        block9: {
            String branchName;
            block8: {
                block7: {
                    try {
                        if (this.remoteConfig != null) break block7;
                        this.setErrorMessage(UIText.PushBranchPage_ChooseRemoteError);
                    }
                    catch (Throwable throwable) {
                        this.setPageComplete(this.getErrorMessage() == null);
                        throw throwable;
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                branchName = this.remoteBranchNameComboViewer.getCombo().getText();
                if (branchName.length() != 0) break block8;
                this.setErrorMessage(MessageFormat.format(GitStringConstants.MSG_ERR_MISSING_REMOTE_BRANCH, this.remoteConfig.getName()));
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            if (Repository.isValidRefName((String)("refs/heads/" + branchName))) break block9;
            this.setErrorMessage(UIText.PushBranchPage_InvalidBranchNameError);
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        if (this.isConfigureUpstreamSelected() && this.hasDifferentUpstreamConfiguration()) {
            this.setMessage(UIText.PushBranchPage_UpstreamConfigOverwriteWarning, 2);
        } else {
            this.setMessage(GitStringConstants.MSG_PUSH_BRANCH_DIALOG);
        }
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    void setSelectedRemote(String remoteName, URIish urIish) {
        try {
            RemoteConfig config = new RemoteConfig((Config)this.repository.getConfig(), remoteName);
            config.addURI(urIish);
            this.remoteConfig = config;
            this.setRefAssist(this.remoteConfig);
            this.checkPage();
        }
        catch (URISyntaxException e) {
            this.handleError(e);
        }
    }

    private String getSuggestedBranchName() {
        if (this.ref != null && !this.ref.getName().startsWith("refs/remotes/")) {
            String branchName = Repository.shortenRefName((String)this.ref.getName());
            BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), branchName);
            String merge = branchConfig.getMerge();
            if (!branchConfig.isRemoteLocal() && merge != null && merge.startsWith("refs/heads/")) {
                return Repository.shortenRefName((String)merge);
            }
            return branchName;
        }
        return "";
    }

    private void setRefAssist(RemoteConfig config) {
        if (config == null || config.getURIs().isEmpty()) {
            return;
        }
        this.assist = new RefContentAssistProvider(this.repository, (URIish)config.getURIs().get(0), this.getShell());
        String currentText = this.remoteBranchNameComboViewer.getCombo().getText();
        List data = this.assist.getRefsForContentAssist(false, true);
        Collections.sort(data, new Comparator<Ref>(){

            @Override
            public int compare(Ref ref1, Ref ref2) {
                return StringUtils.compareWithCase((String)Repository.shortenRefName((String)ref1.getName()), (String)Repository.shortenRefName((String)ref2.getName()));
            }
        });
        this.remoteBranchNameComboViewer.setInput((Object)data);
        this.remoteBranchNameComboViewer.getCombo().setText(currentText);
    }

    private boolean hasDifferentUpstreamConfiguration() {
        String branchName = Repository.shortenRefName((String)this.ref.getName());
        BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), branchName);
        String remote = branchConfig.getRemote();
        if (remote == null) {
            return false;
        }
        if (!remote.equals(this.remoteConfig.getName())) {
            return true;
        }
        String merge = branchConfig.getMerge();
        if (merge == null || !merge.equals(this.getFullRemoteReference())) {
            return true;
        }
        return branchConfig.isRebase() ^ this.isRebaseSelected();
    }

    private void handleError(URISyntaxException e) {
        Activator.handleError((String)e.getMessage(), (Throwable)e, (boolean)false);
        this.setErrorMessage(e.getMessage());
    }

    public void dispose() {
        super.dispose();
        for (Resource disposable : this.disposables) {
            disposable.dispose();
        }
    }
}

