/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.wizards;

import com.kms.katalon.composer.integration.git.components.utils.Protocol;
import com.kms.katalon.composer.integration.git.components.wizards.CustomPushBranchPage;
import com.kms.katalon.composer.integration.git.components.wizards.CustomRepositorySelectionPage;
import com.kms.katalon.composer.integration.git.internal.push.CustomConfirmationPage;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.core.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class CustomPushBranchWizard
extends Wizard {
    private final Repository repository;
    private final ObjectId commitToPush;
    private final Ref ref;
    private CustomRepositorySelectionPage addRemotePage;
    private CustomPushBranchPage pushBranchPage;
    private CustomConfirmationPage confirmationPage;

    public CustomPushBranchWizard(Repository repository, Ref ref) throws URISyntaxException {
        this(repository, ref.getObjectId(), ref);
    }

    public CustomPushBranchWizard(Repository repository, ObjectId commitToPush) throws URISyntaxException {
        this(repository, commitToPush, null);
    }

    private CustomPushBranchWizard(Repository repository, ObjectId commitToPush, Ref ref) throws URISyntaxException {
        this.repository = repository;
        this.commitToPush = commitToPush;
        this.ref = ref;
        assert (this.repository != null);
        assert (this.commitToPush != null);
        final List allRemoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)repository.getConfig());
        if (allRemoteConfigs.isEmpty()) {
            this.addRemotePage = new CustomRepositorySelectionPage(true, allRemoteConfigs, null);
        }
        this.pushBranchPage = new CustomPushBranchPage(repository, commitToPush, ref){

            public void setVisible(boolean visible) {
                if (!visible) {
                    super.setVisible(visible);
                    return;
                }
                if (CustomPushBranchWizard.this.addRemotePage != null) {
                    this.setSelectedRemote("origin", CustomPushBranchWizard.this.addRemotePage.getSelection().getURI());
                } else {
                    RemoteConfig remoteConfig = (RemoteConfig)allRemoteConfigs.get(0);
                    this.setSelectedRemote(remoteConfig.getName(), (URIish)remoteConfig.getURIs().get(0));
                }
                super.setVisible(visible);
            }
        };
        this.confirmationPage = new CustomConfirmationPage(repository){

            public void setVisible(boolean visible) {
                this.setSelection(CustomPushBranchWizard.this.getRepositorySelection(), CustomPushBranchWizard.this.getRefSpecs());
                CustomRepositorySelectionPage remotePage = CustomPushBranchWizard.this.getAddRemotePage();
                if (remotePage != null) {
                    this.setCredentials(remotePage.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_PUSH);
    }

    public void addPages() {
        if (this.addRemotePage != null) {
            this.addPage((IWizardPage)this.addRemotePage);
        }
        this.addPage((IWizardPage)this.pushBranchPage);
        this.addPage((IWizardPage)this.confirmationPage);
    }

    public String getWindowTitle() {
        if (this.ref != null) {
            return MessageFormat.format(UIText.PushBranchWizard_WindowTitle, Repository.shortenRefName((String)this.ref.getName()));
        }
        return UIText.PushCommitHandler_pushCommitTitle;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.confirmationPage && this.confirmationPage.isPageComplete();
    }

    public boolean performFinish() {
        try {
            CustomRepositorySelectionPage remotePage = this.getAddRemotePage();
            if (remotePage != null) {
                this.storeCredentials(remotePage);
                URIish uri = remotePage.getSelection().getURI();
                this.configureNewRemote(uri);
            }
            if (this.pushBranchPage.isConfigureUpstreamSelected()) {
                this.configureUpstream();
            }
            this.startPush();
        }
        catch (IOException e) {
            this.confirmationPage.setErrorMessage(e.getMessage());
            return false;
        }
        catch (URISyntaxException e) {
            this.confirmationPage.setErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }

    private CustomRepositorySelectionPage getAddRemotePage() {
        return this.addRemotePage;
    }

    private RepositorySelection getRepositorySelection() {
        CustomRepositorySelectionPage remotePage = this.getAddRemotePage();
        if (remotePage != null) {
            return remotePage.getSelection();
        }
        return new RepositorySelection(null, this.pushBranchPage.getRemoteConfig());
    }

    private List<RefSpec> getRefSpecs() {
        String src = this.ref != null ? this.ref.getName() : this.commitToPush.getName();
        String dst = this.pushBranchPage.getFullRemoteReference();
        RefSpec refSpec = new RefSpec().setSourceDestination(src, dst).setForceUpdate(this.pushBranchPage.isForceUpdateSelected());
        return Arrays.asList(refSpec);
    }

    private void storeCredentials(CustomRepositorySelectionPage remotePage) {
        if (!remotePage.getStoreInSecureStore()) {
            return;
        }
        URIish uri = remotePage.getSelection().getURI();
        if (uri != null) {
            SecureStoreUtils.storeCredentials((UserPasswordCredentials)remotePage.getCredentials(), (URIish)uri);
        }
    }

    private void configureNewRemote(URIish uri) throws URISyntaxException, IOException {
        StoredConfig config = this.repository.getConfig();
        String remoteName = this.getRemoteName();
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, remoteName);
        remoteConfig.addURI(uri);
        RefSpec defaultFetchSpec = new RefSpec().setForceUpdate(true).setSourceDestination("refs/heads/*", "refs/remotes/" + remoteName + "/*");
        remoteConfig.addFetchRefSpec(defaultFetchSpec);
        remoteConfig.update((Config)config);
        config.save();
    }

    private void configureUpstream() throws IOException {
        if (this.ref == null) {
            return;
        }
        String remoteName = this.getRemoteName();
        String fullRemoteBranchName = this.pushBranchPage.getFullRemoteReference();
        String localBranchName = Repository.shortenRefName((String)this.ref.getName());
        StoredConfig config = this.repository.getConfig();
        config.setString("branch", localBranchName, "remote", remoteName);
        config.setString("branch", localBranchName, "merge", fullRemoteBranchName);
        if (this.pushBranchPage.isRebaseSelected()) {
            config.setBoolean("branch", localBranchName, "rebase", true);
        } else {
            config.unset("branch", localBranchName, "rebase");
        }
        config.save();
    }

    private void startPush() throws IOException {
        PushOperationResult result = this.confirmationPage.getConfirmedResult();
        PushOperationSpecification pushSpec = result.deriveSpecification(false);
        PushOperationUI pushOperationUI = new PushOperationUI(this.repository, pushSpec, false);
        pushOperationUI.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        pushOperationUI.setShowConfigureButton(false);
        pushOperationUI.start();
        this.trackPushOperation(result.getURIs());
    }

    private void trackPushOperation(Collection<URIish> uris) {
        try {
            URIish uri = uris.stream().findFirst().get();
            String protocol = Protocol.fromUri(uri).getDefaultScheme();
            Trackings.trackGitOperation((String)"push", (String)protocol);
        }
        catch (Exception exception) {}
    }

    private String getRemoteName() {
        return this.pushBranchPage.getRemoteConfig().getName();
    }
}

