/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.handlers;

import com.kms.katalon.composer.integration.git.components.wizards.CustomGitFetchWizard;
import com.kms.katalon.composer.integration.git.handlers.AbstractGitProjectHandler;
import com.kms.katalon.composer.integration.git.internal.fetch.CustomFetchOperationUI;
import jakarta.inject.Named;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.FetchActionHandler;
import org.eclipse.egit.ui.internal.actions.SimpleFetchActionHandler;
import org.eclipse.egit.ui.internal.fetch.SimpleConfigureFetchDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.swt.widgets.Shell;

public class FetchHandler
extends AbstractGitProjectHandler {
    private static String FETCH_COMMAND_ID = "org.eclipse.egit.ui.team.Fetch";
    @Named(value="activeShell")
    private Shell shell;

    @Override
    public String getEgitCommandId() {
        return FETCH_COMMAND_ID;
    }

    @Override
    public boolean canExecute() {
        return this.getCurrentProject() != null && (this.getHandler().isEnabled() || this.getSimpleHandler().isEnabled());
    }

    public FetchActionHandler getHandler() {
        FetchActionHandler handler = new FetchActionHandler();
        handler.setSelection((ISelection)this.createIProjectSelection());
        return handler;
    }

    private SimpleFetchActionHandler getSimpleHandler() {
        SimpleFetchActionHandler handler = new SimpleFetchActionHandler();
        handler.setSelection((ISelection)this.createIProjectSelection());
        return handler;
    }

    @Override
    public void execute() {
        SimpleFetchActionHandler simpleHandler = this.getSimpleHandler();
        if (simpleHandler.isEnabled()) {
            this.executeSimpleFetch(simpleHandler);
            return;
        }
        this.executeFetch();
    }

    private void executeFetch() {
        CustomGitFetchWizard fetchWizard;
        Repository repository = this.getRepository();
        if (repository == null) {
            return;
        }
        try {
            fetchWizard = new CustomGitFetchWizard(repository);
        }
        catch (URISyntaxException x) {
            ErrorDialog.openError((Shell)this.shell, (String)UIText.FetchAction_wrongURITitle, (String)UIText.FetchAction_wrongURIMessage, (IStatus)new Status(4, "org.eclipse.egit.ui", x.getMessage(), (Throwable)x));
            return;
        }
        WizardDialog dlg = new WizardDialog(this.shell, (IWizard)fetchWizard);
        dlg.setHelpAvailable(false);
        dlg.open();
    }

    private void executeSimpleFetch(SimpleFetchActionHandler simpleHandler) {
        Repository repository = this.getRepository();
        if (repository == null) {
            return;
        }
        RemoteConfig config = SimpleConfigureFetchDialog.getConfiguredRemote((Repository)repository);
        if (config == null) {
            MessageDialog.openInformation((Shell)this.shell, (String)UIText.SimpleFetchActionHandler_NothingToFetchDialogTitle, (String)UIText.SimpleFetchActionHandler_NothingToFetchDialogMessage);
            return;
        }
        new CustomFetchOperationUI(repository, config, Activator.getDefault().getPreferenceStore().getInt("core_remote_connection_timeout"), false).start();
    }
}

