/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import net.sf.jasperreports.engine.query.JRHibernateQueryExecuter;
import org.hibernate.type.Type;

public abstract class JRHibernateAbstractDataSource
implements JRDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_FIELD_ALIAS_TYPE_MISMATCH = "data.hibernate.field.alias.type.mismatch";
    public static final String EXCEPTION_MESSAGE_KEY_MANY_FIELDS_DETECTED = "data.hibernate.many.fields.detected";
    public static final String EXCEPTION_MESSAGE_KEY_NO_FIELD_ALIAS = "data.hibernate.no.field.alias";
    public static final String EXCEPTION_MESSAGE_KEY_NO_FIELD_READER = "data.hibernate.no.field.reader";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_RETURN_ALIAS = "data.hibernate.unknown.return.alias";
    private final JRAbstractBeanDataSource.PropertyNameProvider propertyNameProvider;
    private final Map<String, FieldReader> fieldReaders;
    protected final JRHibernateQueryExecuter queryExecuter;
    private Object currentReturnValue;

    protected JRHibernateAbstractDataSource(JRHibernateQueryExecuter queryExecuter, boolean useFieldDescription, boolean useIndexOnSingleReturn) {
        this.propertyNameProvider = new JRAbstractBeanDataSource.DefaultPropertyNameProvider(useFieldDescription);
        this.queryExecuter = queryExecuter;
        this.fieldReaders = this.assignReaders(useIndexOnSingleReturn);
    }

    protected Map<String, FieldReader> assignReaders(boolean useIndexOnSingleReturn) {
        HashMap<String, FieldReader> readers;
        block9: {
            int i;
            HashMap<String, Integer> aliasesMap;
            Type[] returnTypes;
            JRField[] fields;
            block7: {
                block8: {
                    readers = new HashMap<String, FieldReader>();
                    fields = this.queryExecuter.getDataset().getFields();
                    returnTypes = this.queryExecuter.getReturnTypes();
                    String[] aliases = this.queryExecuter.getReturnAliases();
                    aliasesMap = new HashMap<String, Integer>();
                    if (aliases != null) {
                        for (i = 0; i < aliases.length; ++i) {
                            aliasesMap.put(aliases[i], i);
                        }
                    }
                    if (returnTypes.length != 1) break block7;
                    if (!returnTypes[0].isEntityType() && !returnTypes[0].isComponentType()) break block8;
                    for (i = 0; i < fields.length; ++i) {
                        JRField field = fields[i];
                        readers.put(field.getName(), this.getFieldReaderSingleReturn(aliasesMap, field, useIndexOnSingleReturn));
                    }
                    break block9;
                }
                if (fields.length > 1) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MANY_FIELDS_DETECTED, (Object[])null);
                }
                if (fields.length != 1) break block9;
                JRField field = fields[0];
                if (useIndexOnSingleReturn) {
                    readers.put(field.getName(), new IndexFieldReader(0));
                } else {
                    readers.put(field.getName(), new IdentityFieldReader());
                }
                break block9;
            }
            for (i = 0; i < fields.length; ++i) {
                JRField field = fields[i];
                readers.put(field.getName(), this.getFieldReader(returnTypes, aliasesMap, field));
            }
        }
        return readers;
    }

    protected FieldReader getFieldReaderSingleReturn(Map<String, Integer> aliasesMap, JRField field, boolean useIndex) {
        FieldReader reader;
        String fieldMapping = this.getFieldMapping(field);
        if (aliasesMap.containsKey(fieldMapping)) {
            reader = useIndex ? new IndexFieldReader(0) : new IdentityFieldReader();
        } else {
            int firstNestedIdx = fieldMapping.indexOf(46);
            if (firstNestedIdx >= 0 && aliasesMap.containsKey(fieldMapping.substring(0, firstNestedIdx))) {
                fieldMapping = fieldMapping.substring(firstNestedIdx + 1);
            }
            reader = useIndex ? new IndexPropertyFieldReader(0, fieldMapping) : new PropertyFieldReader(fieldMapping);
        }
        return reader;
    }

    protected FieldReader getFieldReader(Type[] returnTypes, Map<String, Integer> aliasesMap, JRField field) {
        FieldReader reader;
        String fieldMapping = this.getFieldMapping(field);
        Integer fieldIdx = aliasesMap.get(fieldMapping);
        if (fieldIdx == null) {
            int firstNestedIdx = fieldMapping.indexOf(46);
            if (firstNestedIdx < 0) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_RETURN_ALIAS, fieldMapping);
            }
            String fieldAlias = fieldMapping.substring(0, firstNestedIdx);
            String fieldProperty = fieldMapping.substring(firstNestedIdx + 1);
            fieldIdx = aliasesMap.get(fieldAlias);
            if (fieldIdx == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_FIELD_ALIAS, fieldAlias);
            }
            Type type = returnTypes[fieldIdx];
            if (!type.isEntityType() && !type.isComponentType()) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FIELD_ALIAS_TYPE_MISMATCH, fieldAlias);
            }
            reader = new IndexPropertyFieldReader(fieldIdx, fieldProperty);
        } else {
            reader = new IndexFieldReader(fieldIdx);
        }
        return reader;
    }

    protected void setCurrentRowValue(Object currentReturnValue) {
        this.currentReturnValue = currentReturnValue;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        FieldReader reader = this.fieldReaders.get(jrField.getName());
        if (reader == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_FIELD_READER, jrField.getName());
        }
        return reader.getFieldValue(this.currentReturnValue);
    }

    protected String getFieldMapping(JRField field) {
        return this.propertyNameProvider.getPropertyName(field);
    }

    protected static class IndexPropertyFieldReader
    implements FieldReader {
        private final int idx;
        private final String property;

        protected IndexPropertyFieldReader(int idx, String property) {
            this.idx = idx;
            this.property = property;
        }

        @Override
        public Object getFieldValue(Object resultValue) throws JRException {
            return JRAbstractBeanDataSource.getBeanProperty(((Object[])resultValue)[this.idx], this.property);
        }
    }

    protected static class PropertyFieldReader
    implements FieldReader {
        private final String property;

        protected PropertyFieldReader(String property) {
            this.property = property;
        }

        @Override
        public Object getFieldValue(Object resultValue) throws JRException {
            return JRAbstractBeanDataSource.getBeanProperty(resultValue, this.property);
        }
    }

    protected static class IndexFieldReader
    implements FieldReader {
        private final int idx;

        protected IndexFieldReader(int idx) {
            this.idx = idx;
        }

        @Override
        public Object getFieldValue(Object resultValue) {
            return ((Object[])resultValue)[this.idx];
        }
    }

    protected static class IdentityFieldReader
    implements FieldReader {
        protected IdentityFieldReader() {
        }

        @Override
        public Object getFieldValue(Object resultValue) {
            return resultValue;
        }
    }

    protected static interface FieldReader {
        public Object getFieldValue(Object var1) throws JRException;
    }
}

