/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.handler;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.folder.handlers.deletion.IDeleteFolderHandler;
import com.kms.katalon.composer.objectrepository.constant.ComposerObjectRepositoryMessageConstants;
import com.kms.katalon.composer.objectrepository.handler.DeleteTestObjectHandler;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteTestObjectFolderHandler
extends DeleteTestObjectHandler
implements IDeleteFolderHandler {
    public FolderEntity.FolderType getFolderType() {
        return FolderEntity.FolderType.WEBELEMENT;
    }

    public boolean execute(FolderTreeEntity folderTreeEntity, IProgressMonitor monitor) {
        try {
            FolderEntity folder = folderTreeEntity.getObject();
            if (folder == null) {
                return false;
            }
            List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(folder);
            monitor.beginTask(MessageFormat.format(ComposerObjectRepositoryMessageConstants.HAND_DELETE_OBJECT_FOLDER_TASK_NAME, folder.getName()), descendantEntities.size() + 1);
            List affectedTestCaseScripts = TestArtifactScriptRefactor.createForFolderEntity((FolderEntity)folder).findReferrersInTestCaseScripts(ProjectController.getInstance().getCurrentProject());
            ArrayList<WebElementEntity> undeletedTestObjects = new ArrayList<WebElementEntity>();
            for (Object entity : descendantEntities) {
                if (monitor.isCanceled()) {
                    return false;
                }
                if (entity instanceof WebElementEntity && !this.deleteTestObject((WebElementEntity)entity, monitor, descendantEntities, affectedTestCaseScripts)) {
                    undeletedTestObjects.add((WebElementEntity)entity);
                    continue;
                }
                if (!(entity instanceof FolderEntity)) continue;
                this.deleteFolder((FolderEntity)entity, undeletedTestObjects, monitor);
            }
            this.deleteFolder(folder, undeletedTestObjects, monitor);
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)folderTreeEntity.getParent());
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private boolean deleteTestObject(WebElementEntity testObject, IProgressMonitor monitor, List<Object> descendant, List<IFile> affectedTestCaseScripts) {
        try {
            String testObjectId = testObject.getIdForDisplay();
            monitor.subTask(MessageFormat.format(ComposerObjectRepositoryMessageConstants.HAND_DELETE_OBJECT_SUB_TASK_NAME, testObjectId));
            boolean bl = this.performDeleteTestObject(testObject, descendant, TestArtifactScriptRefactor.createForTestObjectEntity((String)testObjectId).findReferrers(affectedTestCaseScripts));
            return bl;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.worked(1);
        }
    }
}

