/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.util;

import com.kms.katalon.composer.objectrepository.util.QatWebElement;
import com.kms.katalon.composer.objectrepository.util.QatWebElementProperty;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.SaveWebElementInfoEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.prefs.CsvPreference;

public class Util {
    public static final String SPY_EXEC_FILE_NAME = "ObjectSpyToolStandaloneApplication.exe";

    public static String getPhysicalLocation(String relativePath) {
        try {
            String currentPath = Util.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (currentPath.endsWith("jar")) {
                File file = new File(Util.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                file = new File(file.getParentFile(), "..//" + relativePath);
                return file.getAbsolutePath();
            }
            File file = new File(currentPath + relativePath);
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isProcessRunning(String exeName) {
        try {
            if (exeName.length() > 25) {
                exeName = exeName.substring(0, 25);
            }
            Process process = Runtime.getRuntime().exec("tasklist", null, null);
            String output = Util.readInputStream(process.getInputStream(), true);
            String[] stringArray = output.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String line = stringArray[n2];
                if (line != null && line.trim().contains(exeName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String readInputStream(InputStream is, boolean multiline) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            if (!multiline) continue;
            sb.append("\n");
        }
        reader.close();
        is.close();
        return sb.toString();
    }

    public static String generateGuid() {
        return UUID.randomUUID().toString();
    }

    public static void importElements(ProjectEntity project, FolderEntity webElementRootFolder, String elementFileDir, String propertyFileDir, ObjectRepositoryController controller) throws Exception {
        HashMap<String, Entity> entitiesMap = new HashMap<String, Entity>();
        List<Object> qatWebElements = Util.readFromCSVFile(elementFileDir, QatWebElement.class);
        List<Object> qatProperties = Util.readFromCSVFile(propertyFileDir, QatWebElementProperty.class);
        ArrayList<FolderEntity> entities = new ArrayList<FolderEntity>();
        for (Object obj : qatWebElements) {
            QatWebElement qatWebElement = (QatWebElement)obj;
            String name = qatWebElement.getName();
            FolderEntity entity = null;
            if (qatWebElement.isPage()) {
                entity = new FolderEntity();
                if (name == null || name.trim().equals("")) {
                    name = "folder";
                }
            } else {
                entity = new WebElementEntity();
                ((WebElementEntity)entity).setElementGuidId(qatWebElement.getId());
                if (name == null || name.trim().equals("")) {
                    name = "element";
                }
            }
            entity.setId("");
            entity.setName(name);
            entity.setProject(project);
            entitiesMap.put(qatWebElement.getId(), (Entity)entity);
            entities.add(entity);
            String defaultRootElementGuidId = "00000000-0000-0000-0000-000000000000";
            if (qatWebElement.getParentId().equals(defaultRootElementGuidId)) {
                entity.setParentFolder(webElementRootFolder);
            } else {
                Entity parentWebElement = (Entity)entitiesMap.get(qatWebElement.getParentId());
                if (parentWebElement == null) {
                    entity.setParentFolder(webElementRootFolder);
                } else if (parentWebElement instanceof FolderEntity) {
                    entity.setParentFolder((FolderEntity)parentWebElement);
                } else if (parentWebElement instanceof WebElementEntity) {
                    entity.setParentFolder(((WebElementEntity)parentWebElement).getParentFolder());
                }
            }
            if (!(entity instanceof WebElementEntity)) continue;
            Util.addWebElementProperties((WebElementEntity)entity, qatProperties);
        }
        if (entities.size() > 0) {
            ArrayList<SaveWebElementInfoEntity> webElementInfoEntities = new ArrayList<SaveWebElementInfoEntity>();
            for (Entity entity : entities) {
                SaveWebElementInfoEntity webInfo = new SaveWebElementInfoEntity();
                if (entity instanceof WebElementEntity) {
                    Util.setRefElementGuiD((WebElementEntity)entity, entitiesMap, controller);
                    webInfo.setWebElement((WebElementEntity)entity);
                } else if (entity instanceof FolderEntity) {
                    webInfo.setFolder((FolderEntity)entity);
                }
                webElementInfoEntities.add(webInfo);
            }
            controller.importWebElement(webElementInfoEntities);
        }
    }

    private static List<Object> readFromCSVFile(String csvFileName, Class<?> beanCleass) throws Exception {
        try (CsvBeanReader beanReader = null;){
            Object obj;
            beanReader = new CsvBeanReader((Reader)new FileReader(csvFileName), CsvPreference.STANDARD_PREFERENCE);
            String[] header = beanReader.getHeader(true);
            ArrayList<Object> returnValue = new ArrayList<Object>();
            while ((obj = beanReader.read(beanCleass, header)) != null) {
                returnValue.add(obj);
            }
            ArrayList<Object> arrayList = returnValue;
            return arrayList;
        }
    }

    private static void addWebElementProperties(WebElementEntity webElement, List<Object> qatProperties) throws Exception {
        HashSet<String> excluded = new HashSet<String>();
        for (Object obj : qatProperties) {
            QatWebElementProperty prop = (QatWebElementProperty)obj;
            if (!prop.getElementId().equalsIgnoreCase(webElement.getElementGuidId())) continue;
            WebElementPropertyEntity propEntity = new WebElementPropertyEntity();
            propEntity.setName(prop.getName());
            propEntity.setType(prop.getType());
            String propValue = prop.getValue();
            if (propValue != null && propValue.length() > 1000) {
                propValue = propValue.substring(0, 1000);
            }
            propEntity.setValue(propValue);
            propEntity.setMatchCondition("is exactly".equals(prop.getMatchCondition()) ? "equals" : prop.getMatchCondition());
            propEntity.setIsSelected(prop.getIsSelected());
            String strProps = String.format("%s\t%s\t%s\t%s", prop.getName(), prop.getType(), prop.getValue(), prop.getMatchCondition());
            if (!excluded.add(strProps)) continue;
            webElement.getWebElementProperties().add(propEntity);
        }
    }

    private static void setRefElementGuiD(WebElementEntity entity, Map<String, Entity> entitiesMap, ObjectRepositoryController controller) {
        List props = entity.getWebElementProperties();
        for (WebElementPropertyEntity webElementPropertyEntity : props) {
            Entity theFrame;
            if (!webElementPropertyEntity.getName().equalsIgnoreCase("ref_element") || (theFrame = entitiesMap.get(webElementPropertyEntity.getValue())) == null || !(theFrame instanceof WebElementEntity)) continue;
            try {
                webElementPropertyEntity.setValue(((WebElementEntity)theFrame).getIdForDisplay().replace("\\", "/"));
            }
            catch (Exception e) {
                webElementPropertyEntity.setValue(((WebElementEntity)theFrame).getLocation());
                e.printStackTrace();
            }
            break;
        }
    }

    public static boolean isFileExist(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }
}

