/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.actions;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.i18n.Messages;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.UIUtil;

public class ExportEditorSourceAction
extends Action {
    public ExportEditorSourceAction() {
        super(Messages.getString("JavaDecompilerActionBarContributor.Action.ExportSource"));
        this.setImageDescriptor(JavaDecompilerPlugin.getImageDescriptor("icons/etool16/export_wiz.png"));
        this.setDisabledImageDescriptor(JavaDecompilerPlugin.getImageDescriptor("icons/dtool16/export_wiz.png"));
    }

    public void run() {
        JavaDecompilerClassFileEditor classEditor = null;
        JavaDecompilerClassFileEditor editor = UIUtil.getActiveEditor();
        if (editor != null) {
            classEditor = editor;
        }
        if (classEditor != null) {
            IClassFile cf = ((IClassFileEditorInput)classEditor.getEditorInput()).getClassFile();
            FileDialog dialog = new FileDialog(classEditor.getEditorSite().getShell(), 0x10002000);
            dialog.setFileName(cf.getElementName().replaceAll("\\..+", ""));
            dialog.setFilterExtensions(new String[]{"*.java"});
            String file = dialog.open();
            if (file != null && file.trim().length() > 0) {
                String projectFile = file.trim();
                try {
                    FileUtil.writeToFile(new File(projectFile), cf.getSource());
                }
                catch (CoreException e) {
                    ExceptionHandler.handle((CoreException)e, (String)Messages.getString("JavaDecompilerActionBarContributor.ErrorDialog.Title"), (String)Messages.getString("JavaDecompilerActionBarContributor.ErrorDialog.Message.ExportFailed"));
                }
            } else {
                return;
            }
        }
    }

    public boolean isEnabled() {
        JavaDecompilerClassFileEditor editor = UIUtil.getActiveEditor();
        return editor != null;
    }
}

