/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.actions;

import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.actions.ByteCodeAction;
import org.sf.feeling.decompiler.actions.DebugModeAction;
import org.sf.feeling.decompiler.actions.DecompilerPeferenceAction;
import org.sf.feeling.decompiler.actions.DisassemblerAction;
import org.sf.feeling.decompiler.actions.ExportEditorSourceAction;
import org.sf.feeling.decompiler.actions.ExportSourceAction;
import org.sf.feeling.decompiler.actions.SourceCodeAction;
import org.sf.feeling.decompiler.editor.DecompilerType;
import org.sf.feeling.decompiler.editor.IDecompilerDescriptor;
import org.sf.feeling.decompiler.util.UIUtil;

public class SubMenuCreator
implements IMenuCreator {
    private MenuManager dropDownMenuMgr;

    public Menu getMenu(Menu parent) {
        final Menu menu = new Menu(parent);
        this.fillMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                while (menu.getItemCount() > 0) {
                    menu.getItem(0).dispose();
                }
                SubMenuCreator.this.fillMenu(menu);
            }
        });
        return menu;
    }

    private void fillMenu(Menu menu) {
        IContributionItem[] items;
        String[] decompilerTypeArray;
        MenuManager menuMgr = new MenuManager();
        String[] stringArray = decompilerTypeArray = DecompilerType.getDecompilerTypes();
        int n = decompilerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            String decompilerType = stringArray[n2];
            IDecompilerDescriptor decompilerDescriptor = JavaDecompilerPlugin.getDefault().getDecompilerDescriptor(decompilerType);
            menuMgr.add((IAction)decompilerDescriptor.getDecompileAction());
            ++n2;
        }
        IContributionItem[] iContributionItemArray = items = menuMgr.getItems();
        int n3 = items.length;
        n = 0;
        while (n < n3) {
            IContributionItem item;
            IContributionItem newItem = item = iContributionItemArray[n];
            if (item instanceof ActionContributionItem) {
                newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
            }
            newItem.fill(menu, -1);
            ++n;
        }
    }

    public Menu getMenu(Control parent) {
        this.createDropDownMenuMgr();
        return this.dropDownMenuMgr.createContextMenu(parent);
    }

    public void dispose() {
        if (this.dropDownMenuMgr != null) {
            this.dropDownMenuMgr.dispose();
            this.dropDownMenuMgr = null;
        }
    }

    private void createDropDownMenuMgr() {
        if (this.dropDownMenuMgr == null) {
            this.dropDownMenuMgr = new MenuManager();
            String[] stringArray = DecompilerType.getDecompilerTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String decompilerType = stringArray[n2];
                this.dropDownMenuMgr.add((IAction)JavaDecompilerPlugin.getDefault().getDecompilerDescriptor(decompilerType).getDecompileAction());
                ++n2;
            }
            this.dropDownMenuMgr.add((IContributionItem)new Separator());
            this.dropDownMenuMgr.add((IAction)new SourceCodeAction());
            this.dropDownMenuMgr.add((IAction)new ByteCodeAction());
            this.dropDownMenuMgr.add((IAction)new DisassemblerAction());
            this.dropDownMenuMgr.add((IContributionItem)new Separator());
            this.dropDownMenuMgr.add((IAction)new DebugModeAction());
            this.dropDownMenuMgr.add((IContributionItem)new Separator());
            List list = UIUtil.getExportSelections();
            if (list != null) {
                this.dropDownMenuMgr.add((IAction)new ExportSourceAction(list));
            } else {
                this.dropDownMenuMgr.add((IAction)new ExportEditorSourceAction());
            }
            this.dropDownMenuMgr.add((IContributionItem)new Separator());
            this.dropDownMenuMgr.add((IContributionItem)new PreferenceActionContributionItem((IAction)new DecompilerPeferenceAction()));
        }
    }

    private static class PreferenceActionContributionItem
    extends ActionContributionItem {
        public PreferenceActionContributionItem(IAction action) {
            super(action);
        }

        public boolean isEnabledAllowed() {
            return true;
        }
    }
}

