/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.preference.IPreferenceStore;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.DecompilerSourceMapper;
import org.sf.feeling.decompiler.editor.IDecompiler;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.editor.NoStackTraceException;
import org.sf.feeling.decompiler.util.ClassUtil;
import org.sf.feeling.decompiler.util.DecompileUtil;
import org.sf.feeling.decompiler.util.DecompilerOutputUtil;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;
import org.sf.feeling.decompiler.util.SortMemberUtil;
import org.sf.feeling.decompiler.util.SourceMapperUtil;
import org.sf.feeling.decompiler.util.UIUtil;

public abstract class BaseDecompilerSourceMapper
extends DecompilerSourceMapper {
    private static Map<String, String> options = new HashMap<String, String>();
    protected IDecompiler originalDecompiler;
    private IDecompiler usedDecompiler;
    private String classLocation;

    static {
        CompilerOptions option = new CompilerOptions();
        options = option.getMap();
        options.put("org.eclipse.jdt.core.compiler.compliance", DecompilerOutputUtil.getMaxDecompileLevel());
        options.put("org.eclipse.jdt.core.compiler.source", DecompilerOutputUtil.getMaxDecompileLevel());
    }

    public BaseDecompilerSourceMapper(IPath sourcePath, String rootPath) {
        this(sourcePath, rootPath, options);
    }

    public BaseDecompilerSourceMapper(IPath sourcePath, String rootPath, Map<String, String> options) {
        super(sourcePath, rootPath, options);
    }

    public char[] findSource(IType type, IBinaryType info) {
        SourceMapper rootSourceMapper;
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean ignoreExistingSource = prefs.getBoolean("org.sf.feeling.decompiler.alwaysuse");
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        IPackageFragment pkgFrag = type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkgFrag.getParent();
        JavaDecompilerPlugin.getDefault().syncLibrarySource(root);
        char[] attachedSource = null;
        if (UIUtil.requestFromJavadocHover() && !this.fromInput(type) && ignoreExistingSource) {
            this.sourceRanges.remove(type);
            attachedSource = ((SourceMapper)originalSourceMapper.get(root)).findSource(type, info);
            return attachedSource;
        }
        if (originalSourceMapper.containsKey(root) && (attachedSource = ((SourceMapper)originalSourceMapper.get(root)).findSource(type, info)) != null && !ignoreExistingSource) {
            this.updateSourceRanges(type, attachedSource);
            this.isAttachedSource = true;
            this.mapSourceSwitch(type, attachedSource, true);
            SourceMapperUtil.mapSource(((PackageFragmentRoot)root).getSourceMapper(), type, attachedSource, info);
            return attachedSource;
        }
        if (info == null) {
            if (ignoreExistingSource) {
                return null;
            }
            return attachedSource;
        }
        try {
            if (root instanceof PackageFragmentRoot) {
                PackageFragmentRoot pfr = (PackageFragmentRoot)root;
                SourceMapper sourceMapper = pfr.getSourceMapper();
                if (!originalSourceMapper.containsKey(root)) {
                    ReflectionUtils.setFieldValue((Object)this, "options", ReflectionUtils.getFieldValue(sourceMapper, "options"));
                    originalSourceMapper.put(root, sourceMapper);
                }
                if (sourceMapper != null && !ignoreExistingSource && !(sourceMapper instanceof DecompilerSourceMapper) && (attachedSource = sourceMapper.findSource(type, info)) != null) {
                    this.updateSourceRanges(type, attachedSource);
                    this.isAttachedSource = true;
                    this.mapSourceSwitch(type, attachedSource, true);
                    SourceMapperUtil.mapSource(((PackageFragmentRoot)root).getSourceMapper(), type, attachedSource, info);
                    return attachedSource;
                }
                if (sourceMapper != this) {
                    pfr.setSourceMapper((SourceMapper)this);
                }
            }
        }
        catch (JavaModelException e) {
            JavaDecompilerPlugin.logError(e, "Could not set source mapper.");
        }
        this.isAttachedSource = false;
        if (JavaDecompilerPlugin.getDefault().isAutoAttachSource()) {
            JavaDecompilerPlugin.getDefault().attachSource(root, false);
        }
        String className = new String(info.getName());
        String fullName = new String(info.getFileName());
        int classNameIndex = fullName.lastIndexOf(className);
        if (classNameIndex < 0) {
            String msg = String.format("Unable to find className \"%s\" in fullName \"%s\"", className, fullName);
            JavaDecompilerPlugin.logError(null, msg);
            return this.messageWithExceptionsAsSourceCode(msg, exceptions);
        }
        className = fullName.substring(classNameIndex);
        int index = className.lastIndexOf(47);
        className = className.substring(index + 1);
        this.classLocation = "";
        this.usedDecompiler = this.decompile(null, type, exceptions, root, className);
        if (this.noDecompiledSourceCodeAvailable(this.usedDecompiler) && this.usedDecompiler == null) {
            String msg = String.format("Failed to decompile using %s", this.getDecompilerName());
            exceptions.add(new RuntimeException(msg));
            return this.messageWithExceptionsAsSourceCode(msg, exceptions);
        }
        String code = this.usedDecompiler.getSource();
        boolean showReport = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayMetadata");
        if (!showReport) {
            code = this.usedDecompiler.removeComment(code);
        }
        boolean showLineNumber = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        boolean align = prefs.getBoolean("jd.ide.eclipse.prefs.RealignLineNumbers");
        if (showLineNumber && align || UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
            if (showReport) {
                code = this.usedDecompiler.removeComment(code);
            }
            DecompilerOutputUtil decompilerOutputUtil = new DecompilerOutputUtil(this.usedDecompiler.getDecompilerType(), code);
            code = decompilerOutputUtil.realign();
        }
        StringBuffer source = new StringBuffer();
        if (!UIUtil.isDebugPerspective() && !JavaDecompilerPlugin.getDefault().isDebugMode()) {
            boolean useSorter = prefs.getBoolean("org.sf.feeling.decompiler.use_eclipse_sorter");
            if (useSorter) {
                className = new String(info.getName());
                fullName = new String(info.getFileName());
                if (fullName.lastIndexOf(className) != -1) {
                    className = fullName.substring(fullName.lastIndexOf(className));
                }
                code = SortMemberUtil.sortMember(type.getPackageFragment().getElementName(), className, code);
            }
            source.append(this.formatSource(code));
            if (showReport) {
                this.printDecompileReport(source, this.classLocation, exceptions);
            }
        } else {
            source.append(code);
        }
        char[] sourceAsCharArray = source.toString().toCharArray();
        if (originalSourceMapper.containsKey(root) && (rootSourceMapper = (SourceMapper)originalSourceMapper.get(root)).findSource(type, info) == null) {
            SourceMapperUtil.mapSource(rootSourceMapper, type, sourceAsCharArray, info);
        }
        this.updateSourceRanges(type, sourceAsCharArray);
        return sourceAsCharArray;
    }

    private boolean noDecompiledSourceCodeAvailable(IDecompiler decompiler) {
        return this.usedDecompiler == null || this.usedDecompiler.getSource() == null || this.usedDecompiler.getSource().isEmpty();
    }

    private char[] messageWithExceptionsAsSourceCode(String message, Collection<Exception> exceptions) {
        StringBuffer source = new StringBuffer(1024);
        source.append("/*");
        source.append(message.replaceAll("\\/\\*", "\\*"));
        if (exceptions != null && !exceptions.isEmpty()) {
            source.append("\n\n");
            this.logExceptions(exceptions, source);
        }
        source.append("*/");
        return source.toString().toCharArray();
    }

    private void updateSourceRanges(IType type, char[] attachedSource) {
        if (type.getParent() instanceof ClassFile) {
            try {
                DecompileUtil.updateSourceRanges((IClassFile)((ClassFile)type.getParent()), new String(attachedSource));
            }
            catch (JavaModelException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean fromInput(IType type) {
        JavaDecompilerClassFileEditor editor = UIUtil.getActiveEditor();
        if (editor != null && editor.getEditorInput() instanceof IClassFileEditorInput) {
            IClassFile input = ((IClassFileEditorInput)editor.getEditorInput()).getClassFile();
            IType inputType = (IType)ReflectionUtils.invokeMethod((Object)input, "getOuterMostEnclosingType", new Class[0], new Object[0]);
            return type.equals(inputType);
        }
        return false;
    }

    private IDecompiler decompile(IDecompiler decompiler, IType type, Collection<Exception> exceptions, IPackageFragmentRoot root, String className) {
        Boolean displayNumber;
        IDecompiler result;
        block25: {
            result = decompiler;
            String pkg = type.getPackageFragment().getElementName().replace('.', '/');
            displayNumber = null;
            if (UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
                displayNumber = JavaDecompilerPlugin.getDefault().isDisplayLineNumber();
                JavaDecompilerPlugin.getDefault().displayLineNumber(Boolean.TRUE);
            }
            try {
                if (root.isArchive()) {
                    String archivePath = this.getArchivePath(root);
                    this.classLocation = String.valueOf(this.classLocation) + archivePath;
                    if (result == null) {
                        try {
                            Throwable throwable = null;
                            Object var11_16 = null;
                            try (ByteArrayInputStream in = new ByteArrayInputStream(type.getClassFile().getBytes());){
                                result = ClassUtil.checkAvailableDecompiler(this.originalDecompiler, in);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (JavaModelException e) {
                            Logger.error(e.toString());
                            result = this.originalDecompiler;
                        }
                    }
                    result.decompileFromArchive(archivePath, pkg, className);
                    break block25;
                }
                String rootLocation = null;
                try {
                    if (root.getUnderlyingResource() != null) {
                        rootLocation = root.getUnderlyingResource().getLocation().toOSString();
                        this.classLocation = String.valueOf(this.classLocation) + rootLocation + "/" + pkg + "/" + className;
                    } else if (root instanceof ExternalPackageFragmentRoot) {
                        rootLocation = ((ExternalPackageFragmentRoot)root).getPath().toOSString();
                        this.classLocation = String.valueOf(this.classLocation) + rootLocation + "/" + pkg + "/" + className;
                    } else {
                        rootLocation = root.getPath().toOSString();
                        this.classLocation = String.valueOf(this.classLocation) + rootLocation + "/" + pkg + "/" + className;
                    }
                    if (result == null) {
                        result = ClassUtil.checkAvailableDecompiler(this.originalDecompiler, new File(this.classLocation));
                    }
                    result.decompile(rootLocation, pkg, className);
                }
                catch (JavaModelException e) {
                    exceptions.add((Exception)((Object)e));
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (displayNumber != null) {
            JavaDecompilerPlugin.getDefault().displayLineNumber(displayNumber);
        }
        return result;
    }

    @Override
    public String decompile(String decompilerType, File file) {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        Boolean displayNumber = null;
        if (UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
            displayNumber = JavaDecompilerPlugin.getDefault().isDisplayLineNumber();
            JavaDecompilerPlugin.getDefault().displayLineNumber(Boolean.TRUE);
        }
        IDecompiler currentDecompiler = ClassUtil.checkAvailableDecompiler(this.originalDecompiler, file);
        currentDecompiler.decompile(file.getParentFile().getAbsolutePath(), "", file.getName());
        if (displayNumber != null) {
            JavaDecompilerPlugin.getDefault().displayLineNumber(displayNumber);
        }
        if (currentDecompiler.getSource() == null || currentDecompiler.getSource().length() == 0) {
            return null;
        }
        String code = currentDecompiler.getSource();
        boolean showReport = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayMetadata");
        if (!showReport) {
            code = currentDecompiler.removeComment(code);
        }
        boolean showLineNumber = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        boolean align = prefs.getBoolean("jd.ide.eclipse.prefs.RealignLineNumbers");
        if (showLineNumber && align || UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
            if (showReport) {
                code = currentDecompiler.removeComment(code);
            }
            DecompilerOutputUtil decompilerOutputUtil = new DecompilerOutputUtil(currentDecompiler.getDecompilerType(), code);
            code = decompilerOutputUtil.realign();
        }
        StringBuffer source = new StringBuffer();
        if (!UIUtil.isDebugPerspective() && !JavaDecompilerPlugin.getDefault().isDebugMode()) {
            source.append(this.formatSource(code));
            if (showReport) {
                LinkedList<Exception> exceptions = new LinkedList<Exception>();
                exceptions.addAll(currentDecompiler.getExceptions());
                this.printDecompileReport(source, file.getAbsolutePath(), exceptions);
            }
        } else {
            source.append(code);
        }
        return source.toString();
    }

    protected void logExceptions(Collection<Exception> exceptions, StringBuffer buffer) {
        if (exceptions.isEmpty()) {
            return;
        }
        buffer.append("\n\tCaught exceptions:");
        if (exceptions == null || exceptions.isEmpty()) {
            return;
        }
        buffer.append("\n");
        StringWriter stackTraces = new StringWriter();
        Throwable throwable = null;
        Object var5_6 = null;
        try (PrintWriter stackTracesP = new PrintWriter(stackTraces);){
            for (Exception ex : exceptions) {
                if (ex instanceof NoStackTraceException) {
                    stackTracesP.append("\t");
                    stackTracesP.println(ex.getMessage());
                    continue;
                }
                ex.printStackTrace(stackTracesP);
                stackTracesP.println("");
            }
            stackTracesP.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        buffer.append(stackTraces.toString());
    }

    protected abstract String getDecompilerName();

    protected abstract String getDecompilerVersion();

    protected void printDecompileReport(StringBuffer source, String fileLocation, Collection<Exception> exceptions) {
        String log = this.usedDecompiler.getLog();
        String logMsg = log.replaceAll("\t", "").replaceAll("\n\\s*", "\n\t");
        source.append("\n\n/*");
        source.append("\n\tDECOMPILATION REPORT\n");
        if (this.usedDecompiler != this.originalDecompiler) {
            source.append("\n\tWARNING: used decompiler was changed from ");
            source.append(this.originalDecompiler.getDecompilerName());
            source.append(" to ");
            source.append(this.usedDecompiler.getDecompilerName());
            this.logExceptions(this.originalDecompiler.getExceptions(), source);
        }
        source.append("\n\tDecompiled from: ");
        source.append(fileLocation);
        source.append("\n\tTotal time: ");
        source.append(this.usedDecompiler.getDecompilationTime());
        source.append(" ms\n\t");
        source.append(logMsg);
        exceptions.addAll(this.usedDecompiler.getExceptions());
        this.logExceptions(exceptions, source);
        String decompiler = this.usedDecompiler.getDecompilerName();
        String ver = this.usedDecompiler.getDecompilerVersion();
        if (decompiler != null) {
            source.append("\n\tDecompiled with ");
            source.append(decompiler);
            if (ver != null) {
                source.append(" version ");
                source.append(ver);
            }
            source.append(".\n");
        }
        source.append("*/");
    }
}

