/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.sf.feeling.decompiler.util.ReflectionUtils;

public class DecompilerOutputUtil {
    public static final String NO_LINE_NUMBER = "// Warning: No line numbers available in class file";
    private final String input;
    private final List<InputLine> inputLines = new ArrayList<InputLine>();
    private CompilationUnit unit;
    private final List<JavaSrcLine> javaSrcLines = new ArrayList<JavaSrcLine>();
    public static final String line_separator = System.getProperty("line.separator", "\r\n");
    private String decompilerType;
    private static String level = null;
    private static int jslLevel = -1;

    public DecompilerOutputUtil(String decompilerType, String input) {
        this.input = String.valueOf(input) + line_separator;
        this.decompilerType = decompilerType;
    }

    public String realign() {
        if (this.input == null) {
            return null;
        }
        if (this.input.isEmpty()) {
            return this.input;
        }
        this.fillOutputList();
        this.javaSrcLines.add(null);
        ASTParser parser = ASTParser.newParser((int)DecompilerOutputUtil.getMaxJSLLevel());
        CompilerOptions option = new CompilerOptions();
        Map options = option.getMap();
        options.put("org.eclipse.jdt.core.compiler.compliance", DecompilerOutputUtil.getMaxDecompileLevel());
        options.put("org.eclipse.jdt.core.compiler.source", DecompilerOutputUtil.getMaxDecompileLevel());
        parser.setCompilerOptions(options);
        parser.setSource(this.input.toCharArray());
        this.unit = (CompilationUnit)parser.createAST(null);
        List types = this.unit.types();
        int i = 0;
        while (i < types.size()) {
            if (types.get(i) instanceof AbstractTypeDeclaration) {
                this.processElements((AbstractTypeDeclaration)types.get(i));
            }
            ++i;
        }
        int firstTypeLine = Integer.MAX_VALUE;
        int lastTypeLine = Integer.MIN_VALUE;
        int i2 = 0;
        while (i2 < types.size()) {
            if (types.get(i2) instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration type = (AbstractTypeDeclaration)types.get(i2);
                this.processTypes(type);
                int numLine = this.unit.getLineNumber(type.getStartPosition());
                if (numLine < firstTypeLine) {
                    firstTypeLine = numLine;
                }
                if ((numLine = this.unit.getLineNumber(type.getStartPosition() + type.getLength() - 1)) > lastTypeLine) {
                    lastTypeLine = numLine;
                }
            }
            ++i2;
        }
        if (this.javaSrcLines.size() == 1) {
            String warning = "\r\n// Warning: No line numbers available in class file\r\n";
            return String.valueOf(warning) + this.input;
        }
        if (firstTypeLine != Integer.MAX_VALUE) {
            this.addBelow(firstTypeLine - 1, 0, 0);
        }
        if (lastTypeLine != Integer.MIN_VALUE) {
            this.addBelow(this.inputLines.size() - 2, lastTypeLine, this.javaSrcLines.size() - 1);
        }
        return this.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String replace(String text, String searchString, String replacement) {
        if (DecompilerOutputUtil.isEmpty(text) || DecompilerOutputUtil.isEmpty(searchString) || replacement == null) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= 16));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            end = text.indexOf(searchString, 2);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public String toString() {
        int trimSpace;
        int lastBracketIndex;
        StringBuffer realignOutput = new StringBuffer();
        int lineNumberWidth = String.valueOf(this.javaSrcLines.size()).length();
        boolean generateEmptyString = true;
        int leftTrimSpace = 0;
        Pattern pattern = Pattern.compile("/\\*\\s+\\*/", 2);
        Matcher matcher = pattern.matcher(this.input);
        if (matcher.find()) {
            generateEmptyString = false;
            pattern = Pattern.compile("([ ]+)import", 2);
            matcher = pattern.matcher(this.input);
            if (matcher.find()) {
                leftTrimSpace = matcher.group().replace("import", "").length();
            }
        } else {
            pattern = Pattern.compile("([ ]+)import", 2);
            matcher = pattern.matcher(this.input);
            if (matcher.find()) {
                leftTrimSpace = matcher.group().replace("import", "").length();
                generateEmptyString = true;
            }
        }
        if ((lastBracketIndex = this.input.lastIndexOf(125)) != -1 && (trimSpace = this.getLeftPosition(this.input, this.input.lastIndexOf(125, lastBracketIndex - 1)) - this.getLeftPosition(this.input, lastBracketIndex)) > 4) {
            leftTrimSpace += trimSpace - 4;
        }
        int i = 1;
        while (i < this.javaSrcLines.size()) {
            JavaSrcLine javaSrcLine = this.initJavaSrcListItem(i);
            if (javaSrcLine.inputLines.size() > 0) {
                String line;
                int numLine;
                int index;
                List<Integer> beforeLines;
                int outputLineNumber = this.getOutputLineNumber(javaSrcLine);
                if (outputLineNumber != -1 && (beforeLines = this.getBeforeLines(javaSrcLine)) != null && !beforeLines.isEmpty() && (index = realignOutput.lastIndexOf(line_separator)) == realignOutput.length() - line_separator.length()) {
                    realignOutput.replace(index, index + line_separator.length(), "");
                    int j = 0;
                    while (j < beforeLines.size()) {
                        numLine = beforeLines.get(j);
                        line = this.inputLines.get((int)numLine).line;
                        line = this.removeJavaLineNumber(line.replace("\r\n", "\n").replace("\n", ""), j == 0 && generateEmptyString, leftTrimSpace);
                        realignOutput.append(line);
                        ++j;
                    }
                    realignOutput.append(line_separator);
                    javaSrcLine.inputLines.removeAll(beforeLines);
                }
                if (i > 0) {
                    realignOutput.append("/* " + this.getLineNumber(outputLineNumber, lineNumberWidth) + " */ ");
                }
                int j = 0;
                while (j < javaSrcLine.inputLines.size()) {
                    numLine = javaSrcLine.inputLines.get(j);
                    line = this.inputLines.get((int)numLine).line;
                    line = this.removeJavaLineNumber(line.replace("\r\n", "\n").replace("\n", ""), j == 0 && generateEmptyString, leftTrimSpace);
                    realignOutput.append(line);
                    ++j;
                }
            } else if (i > 1) {
                realignOutput.append("/* " + this.getLineNumber(-1, lineNumberWidth) + " */ ");
            }
            realignOutput.append(line_separator);
            ++i;
        }
        return realignOutput.toString();
    }

    private List<Integer> getBeforeLines(JavaSrcLine javaSrcLine) {
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>();
        for (int num : javaSrcLine.inputLines) {
            InputLine line = this.inputLines.get(num);
            if (line != null && line.outputLineNum != -1) break;
            lineNumbers.add(num);
        }
        return lineNumbers;
    }

    private int getOutputLineNumber(JavaSrcLine javaSrcLine) {
        for (int numLine : javaSrcLine.inputLines) {
            InputLine inputLine = this.inputLines.get(numLine);
            if (inputLine == null || inputLine.outputLineNum == -1) continue;
            return inputLine.outputLineNum;
        }
        return -1;
    }

    private int getLeftPosition(String string, int index) {
        if (string == null || string.length() < index) {
            return -1;
        }
        int j = index - 1;
        while (j >= 0) {
            if (j < 0) break;
            if (string.charAt(j) == '\n') {
                return index - j;
            }
            --j;
        }
        return -1;
    }

    private String getLineNumber(int i, int lineNumberWidth) {
        String number = String.valueOf(i);
        int width = number.length();
        if (i == -1) {
            width = 0;
            number = "";
        }
        if (width < lineNumberWidth) {
            int j = 0;
            while (j < lineNumberWidth - width) {
                number = " " + number;
                ++j;
            }
        }
        return number;
    }

    private String generageEmptyString(int length) {
        char[] chs = new char[length];
        int i = 0;
        while (i < chs.length) {
            chs[i] = 32;
            ++i;
        }
        return new String(chs);
    }

    private void fillOutputList() {
        int lineStart = 0;
        int lineEnd = 0;
        this.inputLines.add(null);
        while (lineStart < this.input.length()) {
            lineEnd = (lineEnd = this.input.indexOf(10, lineEnd)) == -1 ? this.input.length() : ++lineEnd;
            InputLine outputLine = new InputLine();
            outputLine.line = this.input.substring(lineStart, lineEnd);
            this.inputLines.add(outputLine);
            lineStart = lineEnd;
        }
    }

    public static int parseJavaLineNumber(String decompilerType, String line) {
        String regex = "/\\*\\s*\\d+\\s*\\*/";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(line.trim());
        if (matcher.find()) {
            return Integer.parseInt(matcher.group().replaceAll("[^0-9]", ""));
        }
        return -1;
    }

    public static int parseJavaLineNumber(String line) {
        String regex = "/\\*\\s*\\d+\\s*\\*/";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(line.trim());
        if (matcher.find()) {
            return Integer.parseInt(matcher.group().replaceAll("[^0-9]", ""));
        }
        regex = "//\\s+\\d+";
        pattern = Pattern.compile(regex, 2);
        matcher = pattern.matcher(line.trim());
        if (matcher.find()) {
            return Integer.parseInt(matcher.group().replaceAll("[^0-9]", ""));
        }
        return -1;
    }

    private String removeJavaLineNumber(String line, boolean generageEmptyString, int leftTrimSpace) {
        String regex = "/\\*\\s*\\d+\\s*\\*/";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(line.trim());
        if (matcher.find()) {
            line = line.replace(matcher.group(), "");
            if (generageEmptyString) {
                line = String.valueOf(this.generageEmptyString(matcher.group().length())) + line;
            }
        }
        if ((matcher = (pattern = Pattern.compile(regex = "/\\*\\s+\\*/", 2)).matcher(line)).find()) {
            line = line.replace(matcher.group(), "");
            if (generageEmptyString) {
                line = String.valueOf(this.generageEmptyString(matcher.group().length())) + line;
            }
        }
        if (leftTrimSpace > 0 && line.startsWith(this.generageEmptyString(leftTrimSpace))) {
            line = line.substring(leftTrimSpace);
        }
        return line;
    }

    private JavaSrcLine initJavaSrcListItem(int outputLineNum) {
        JavaSrcLine javaSrcLine;
        if (this.javaSrcLines.size() <= outputLineNum) {
            int a = this.javaSrcLines.size();
            while (a <= outputLineNum) {
                this.javaSrcLines.add(null);
                ++a;
            }
        }
        if ((javaSrcLine = this.javaSrcLines.get(outputLineNum)) == null) {
            javaSrcLine = new JavaSrcLine();
            this.javaSrcLines.set(outputLineNum, javaSrcLine);
        }
        return javaSrcLine;
    }

    private void addAbove(int inputBeginLineNo, int inputLineNo, int outputLineNo) {
        if (outputLineNo == 1) {
            return;
        }
        int offset = 1;
        block0: while (inputBeginLineNo <= inputLineNo - offset) {
            int offsetInputLine = inputLineNo - offset;
            InputLine inputLine = this.inputLines.get(offsetInputLine);
            if (inputLine.outputLineNum != -1) break;
            JavaSrcLine javaSrcLine = null;
            int offsetOutputLine = outputLineNo - offset;
            if (offsetOutputLine > 0) {
                javaSrcLine = this.initJavaSrcListItem(offsetOutputLine);
            }
            if (offsetOutputLine == 1 || javaSrcLine.inputLines.size() > 0) {
                int offsetOutputLineNext = offsetOutputLine + 1;
                JavaSrcLine javaSrcLineNext = this.initJavaSrcListItem(offsetOutputLineNext);
                int innerOffset = offset;
                while (inputLineNo - innerOffset >= inputBeginLineNo) {
                    int innerOffsetInputLine = inputLineNo - innerOffset;
                    inputLine = this.inputLines.get(innerOffsetInputLine);
                    if (inputLine.outputLineNum != -1) break block0;
                    javaSrcLineNext.inputLines.add(0, innerOffsetInputLine);
                    inputLine.calculatedNumLineJavaSrc = offsetOutputLineNext;
                    ++innerOffset;
                }
                break;
            }
            javaSrcLine.inputLines.add(offsetInputLine);
            inputLine.calculatedNumLineJavaSrc = offsetOutputLine;
            ++offset;
        }
    }

    private void addBelow(int inputEndLineNo, int inputLineNo, int outputLineNo) {
        int offset = 1;
        block0: while (inputLineNo + offset < inputEndLineNo) {
            int offsetInputLine = inputLineNo + offset;
            InputLine outputLine = this.inputLines.get(offsetInputLine);
            if (outputLine.outputLineNum != -1) break;
            int offsetOutputLine = outputLineNo + offset;
            JavaSrcLine javaSrcLine = this.initJavaSrcListItem(offsetOutputLine);
            if (javaSrcLine.inputLines.size() > 0) {
                int offsetOutputLinePrev = offsetOutputLine - 1;
                JavaSrcLine javaSrcLinePrev = this.initJavaSrcListItem(offsetOutputLinePrev);
                int innerOffset = offset;
                while (inputLineNo + innerOffset <= inputEndLineNo) {
                    int innerOffsetInputLine = inputLineNo + innerOffset;
                    outputLine = this.inputLines.get(innerOffsetInputLine);
                    if (outputLine.outputLineNum != -1) break block0;
                    javaSrcLinePrev.inputLines.add(innerOffsetInputLine);
                    outputLine.calculatedNumLineJavaSrc = offsetOutputLinePrev;
                    ++innerOffset;
                }
                break;
            }
            javaSrcLine.inputLines.add(offsetInputLine);
            outputLine.calculatedNumLineJavaSrc = offsetOutputLine;
            ++offset;
        }
        if (inputLineNo + offset == inputEndLineNo) {
            int offsetOutputLine = outputLineNo + offset;
            JavaSrcLine javaSrcLine = this.initJavaSrcListItem(offsetOutputLine);
            javaSrcLine.inputLines.add(inputEndLineNo);
            InputLine outputLine = this.inputLines.get(inputEndLineNo);
            outputLine.calculatedNumLineJavaSrc = offsetOutputLine;
        }
    }

    private void processTypes(AbstractTypeDeclaration rootType) {
        List declarations = rootType.bodyDeclarations();
        for (Object declaration : declarations) {
            if (!(declaration instanceof AbstractTypeDeclaration)) continue;
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)declaration;
            this.processTypes(typeDeclaration);
        }
        int beginTypeLine = Integer.MAX_VALUE;
        int endTypeLine = Integer.MIN_VALUE;
        int firstMethodLine = Integer.MAX_VALUE;
        int lastMethodLine = Integer.MIN_VALUE;
        int beginTypeInputLineNo = this.unit.getLineNumber(rootType.getStartPosition());
        int endTypeInputLineNo = this.unit.getLineNumber(rootType.getStartPosition() + rootType.getLength() - 1);
        int inputLineNo = beginTypeInputLineNo;
        while (inputLineNo <= endTypeInputLineNo) {
            InputLine inputLine = this.inputLines.get(inputLineNo);
            int numLineJavaSrc = inputLine.outputLineNum;
            if (numLineJavaSrc == -1) {
                numLineJavaSrc = inputLine.calculatedNumLineJavaSrc;
            }
            if (numLineJavaSrc != -1) {
                if (beginTypeLine > numLineJavaSrc) {
                    beginTypeLine = numLineJavaSrc;
                }
                if (endTypeLine < numLineJavaSrc) {
                    endTypeLine = numLineJavaSrc;
                }
                if (firstMethodLine > inputLineNo) {
                    firstMethodLine = inputLineNo;
                }
                if (lastMethodLine < inputLineNo) {
                    lastMethodLine = inputLineNo;
                }
            }
            ++inputLineNo;
        }
        if (beginTypeLine != Integer.MAX_VALUE) {
            this.addAbove(beginTypeInputLineNo, firstMethodLine, beginTypeLine);
            this.addBelow(endTypeInputLineNo, lastMethodLine, endTypeLine);
        }
    }

    private void processMembers(AbstractTypeDeclaration rootType) {
        ArrayList bodyDeclarations = new ArrayList();
        if (rootType instanceof EnumDeclaration) {
            EnumDeclaration enumDeclaration = (EnumDeclaration)rootType;
            List enumDeclarations = enumDeclaration.enumConstants();
            int lastInputLineNo = -1;
            for (Object enumDeclObj : enumDeclarations) {
                if (!(enumDeclObj instanceof EnumConstantDeclaration)) continue;
                ASTNode element = (ASTNode)enumDeclObj;
                int p = element.getStartPosition();
                int inputBeginLine = this.unit.getLineNumber(p);
                if (inputBeginLine != lastInputLineNo) {
                    bodyDeclarations.add(enumDeclObj);
                }
                lastInputLineNo = inputBeginLine;
            }
        }
        bodyDeclarations.addAll(rootType.bodyDeclarations());
        for (Object bodyDeclaration : bodyDeclarations) {
            if (!(bodyDeclaration instanceof MethodDeclaration) && !(bodyDeclaration instanceof Initializer) && !(bodyDeclaration instanceof FieldDeclaration) && !(bodyDeclaration instanceof EnumConstantDeclaration)) continue;
            ASTNode element = (ASTNode)bodyDeclaration;
            int p = element.getStartPosition();
            int inputBeginLine = this.unit.getLineNumber(p);
            int inputEndLine = this.unit.getLineNumber(p + element.getLength() - 1);
            this.processMember(inputBeginLine, inputEndLine);
        }
    }

    private void processMember(int inputBeginLine, int inputEndLine) {
        int lastOutputLine = -1;
        int lastInputLine = -1;
        int maxLine = -1;
        int inputNumLine = inputBeginLine;
        while (inputNumLine <= inputEndLine) {
            InputLine inputLine = this.inputLines.get(inputNumLine);
            inputLine.outputLineNum = DecompilerOutputUtil.parseJavaLineNumber(this.decompilerType, inputLine.line);
            if (inputLine.outputLineNum > 1) {
                lastOutputLine = inputLine.outputLineNum;
                lastInputLine = inputNumLine;
                JavaSrcLine javaSrcLine = this.initJavaSrcListItem(inputLine.outputLineNum);
                javaSrcLine.inputLines.add(inputNumLine);
                this.addAbove(inputBeginLine, inputNumLine, inputLine.outputLineNum);
                if (lastOutputLine > maxLine) {
                    maxLine = lastOutputLine;
                }
            }
            ++inputNumLine;
        }
        if (lastInputLine != -1 && lastInputLine < inputEndLine) {
            this.addBelow(inputEndLine, lastInputLine, maxLine);
        }
    }

    private void processElements(AbstractTypeDeclaration rootType) {
        if (rootType instanceof TypeDeclaration || rootType instanceof EnumDeclaration) {
            this.processMembers(rootType);
        }
        List bodyDeclarations = rootType.bodyDeclarations();
        for (Object bodyDeclaration : bodyDeclarations) {
            if (!(bodyDeclaration instanceof AbstractTypeDeclaration)) continue;
            this.processElements((AbstractTypeDeclaration)bodyDeclaration);
        }
    }

    public static String getMaxDecompileLevel() {
        if (level != null) {
            return level;
        }
        Object obj = ReflectionUtils.invokeMethod(JavaCore.class, "latestSupportedJavaVersion");
        if (obj != null) {
            level = (String)obj;
            return level;
        }
        Pattern p = Pattern.compile("^\\d+$");
        LinkedList allVersions = new LinkedList(JavaCore.getAllVersions());
        Iterator it = allVersions.iterator();
        while (it.hasNext()) {
            String v = (String)it.next();
            if (p.matcher(v).matches()) continue;
            it.remove();
        }
        if (allVersions.isEmpty()) {
            level = "1.8";
            return level;
        }
        ArrayList<Integer> allVersionsInt = new ArrayList<Integer>();
        for (String v : allVersions) {
            allVersionsInt.add(Integer.parseInt(v));
        }
        level = Integer.toString((Integer)Collections.max(allVersionsInt));
        return level;
    }

    public static int getMaxJSLLevel() {
        if (jslLevel != -1) {
            return jslLevel;
        }
        Object obj = ReflectionUtils.invokeMethod(AST.class, "getJLSLatest");
        if (obj != null) {
            jslLevel = (Integer)obj;
            return jslLevel;
        }
        Pattern p = Pattern.compile("^JLS\\d+$");
        int maxFieldValue = 8;
        Field[] fieldArray = AST.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getType() == Integer.TYPE && p.matcher(f.getName()).matches()) {
                try {
                    int value = f.getInt(AST.class);
                    if (value > maxFieldValue) {
                        maxFieldValue = value;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        jslLevel = maxFieldValue;
        return jslLevel;
    }

    private class InputLine {
        String line;
        int outputLineNum = -1;
        int calculatedNumLineJavaSrc = -1;

        private InputLine() {
        }

        public String toString() {
            return this.line;
        }
    }

    private class JavaSrcLine {
        List<Integer> inputLines = new ArrayList<Integer>();

        private JavaSrcLine() {
        }

        public String toString() {
            return this.inputLines.toString();
        }
    }
}

